/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Label;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class LabelTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Label.html");
    }

    @Test
    public void can_find_label_by_id() {
        ComponentFactory.component(Label.class, (By)By.$((String)"#label_1"));
        try {
            ComponentFactory.component(Label.class, (By)By.$((String)"#label_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#label_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_label() {
        try {
            ComponentFactory.component(Label.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Label but a Abbr"));
        }
    }

    @Test
    public void test_label_i18nAttributes() {
        Label label = (Label)ComponentFactory.component(Label.class, (By)By.$((String)"#label_1"));
        Language.assertThat((Object)label.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)label.language(), (Matcher)Matchers.is((Object)"en"));
    }

    @Test
    public void test_label_coreAttributes() {
        Label label = (Label)ComponentFactory.component(Label.class, (By)By.$((String)"#label_1"));
        Language.assertThat((Object)label.id(), (Matcher)Matchers.is((Object)"label_1"));
        Language.assertThat((Object)label.classname(), (Matcher)Matchers.is((Object)"myLABELClass"));
        Language.assertThat((Object)label.style(), (Matcher)Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)label.title(), (Matcher)Matchers.is((Object)"labelTitle"));
    }

    @Test
    public void test_label_specifics_attributes() {
        Label label_1 = (Label)ComponentFactory.component(Label.class, (By)By.$((String)"#label_1"));
        Label label_2 = (Label)ComponentFactory.component(Label.class, (By)By.$((String)"#label_2"));
        Language.assertThat((Object)label_1._for(), (Matcher)Matchers.is((Object)"lname"));
        Language.assertThat((Object)label_2.accesskey(), (Matcher)Matchers.is((Object)"L"));
        Language.assertThat((Object)label_1.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Label with state : enabled:true, visible:true, content: First name"));
    }

    @Test
    public void test_label_content() {
        Language.assertThat((Object)((Label)ComponentFactory.component(Label.class, (By)By.$((String)"#label_3"))).content(), (Matcher)Matchers.is((Object)"Home phone number"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Label)ComponentFactory.component(Label.class, (By)By.$((String)"#label_3"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Label with state : enabled:true, visible:true, content: Home phone number"));
    }
}

