/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Caption;
import org.testatoo.cartridge.html4.element.Cellhalign;
import org.testatoo.cartridge.html4.element.Cellvalign;
import org.testatoo.cartridge.html4.element.Col;
import org.testatoo.cartridge.html4.element.Colgroup;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Scope;
import org.testatoo.cartridge.html4.element.TBody;
import org.testatoo.cartridge.html4.element.TFoot;
import org.testatoo.cartridge.html4.element.TFrame;
import org.testatoo.cartridge.html4.element.THead;
import org.testatoo.cartridge.html4.element.TRules;
import org.testatoo.cartridge.html4.element.Table;
import org.testatoo.cartridge.html4.element.Td;
import org.testatoo.cartridge.html4.element.Th;
import org.testatoo.cartridge.html4.element.Tr;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class TableTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Table.html");
    }

    @Test
    public void can_find_table_by_id() {
        ComponentFactory.component(Table.class, (By)By.$((String)"#table_1"));
        try {
            ComponentFactory.component(Table.class, (By)By.$((String)"#table_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#table_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_table() {
        try {
            ComponentFactory.component(Table.class, (By)By.$((String)"#caption_table6"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=caption_table6 is not a Table but a Caption"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        Table table_2 = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_2"));
        Language.assertThat((Object)table_2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)table_2.language(), (Matcher)Matchers.is((Object)"ca"));
    }

    @Test
    public void test_coreAttributes() {
        Table table_2 = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_2"));
        Language.assertThat((Object)table_2.id(), (Matcher)Matchers.is((Object)"table_2"));
        Language.assertThat((Object)table_2.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)table_2.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)table_2.title(), (Matcher)Matchers.is((Object)"tableTitle"));
    }

    @Test
    public void test_specificsAttributes() {
        Table table_2 = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_2"));
        Table table_3 = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_3"));
        Table table_4 = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_4"));
        Table table_5 = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_5"));
        Language.assertThat((Object)table_2.summary(), (Matcher)Matchers.is((Object)"tableSummary"));
        Language.assertThat((Object)table_2.width(), (Matcher)Matchers.is((Object)"50%"));
        Language.assertThat((Object)table_2.border(), (Matcher)Matchers.is((Object)0));
        Language.assertThat((Object)table_3.border(), (Matcher)Matchers.is((Object)5));
        Language.assertThat((Object)table_4.border(), (Matcher)Matchers.is((Object)1));
        Language.assertThat((Object)table_2.frame(), (Matcher)Matchers.is((Object)TFrame.box));
        Language.assertThat((Object)table_3.frame(), (Matcher)Matchers.is((Object)TFrame.vsides));
        Language.assertThat((Object)table_2.rules(), (Matcher)Matchers.is((Object)TRules.all));
        Language.assertThat((Object)table_3.rules(), (Matcher)Matchers.is((Object)TRules.cols));
        Language.assertThat((Object)table_2.cellspacing(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)table_4.cellspacing(), (Matcher)Matchers.is((Object)"10"));
        Language.assertThat((Object)table_5.cellspacing(), (Matcher)Matchers.containsString((String)"10"));
        Language.assertThat((Object)table_2.cellpadding(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)table_4.cellpadding(), (Matcher)Matchers.containsString((String)"8"));
        Language.assertThat((Object)table_5.cellpadding(), (Matcher)Matchers.is((Object)"30"));
    }

    @Test
    public void can_obtain_caption() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_5"));
        Language.assertThat((Object)table.caption(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"caption5_title")));
    }

    @Test
    public void can_obtain_thead() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_6"));
        Language.assertThat((Object)table.thead().id(), (Matcher)Matchers.is((Object)"thead_ess1"));
        Language.assertThat((Object)table.thead().title(), (Matcher)Matchers.is((Object)"thead1_Title"));
    }

    @Test
    public void can_obtain_tbody() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_6"));
        Language.assertThat((Object)table.tbody().id(), (Matcher)Matchers.is((Object)"tbody_ess1"));
        Language.assertThat((Object)table.tbody().title(), (Matcher)Matchers.is((Object)"tbody1_Title"));
    }

    @Test
    public void can_obtain_tfoot() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_6"));
        Language.assertThat((Object)table.tfoot().id(), (Matcher)Matchers.is((Object)"tfoot_ess1"));
    }

    @Test
    public void can_obtain_colgroups() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_8"));
        Language.assertThat((Object)table.colgroups(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)2)));
        Language.assertThat((Object)((Colgroup)table.colgroups().get(0)).id(), (Matcher)Matchers.is((Object)"colgroup_ess1"));
        Language.assertThat((Object)((Colgroup)table.colgroups().get(1)).id(), (Matcher)Matchers.is((Object)"colgroup_ess2"));
    }

    @Test
    public void can_obtain_cols() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_6"));
        Language.assertThat((Object)table.cols(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)4)));
        Language.assertThat((Object)table.cols().get(0), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_0")));
        Language.assertThat((Object)table.cols().get(1), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_1")));
        Language.assertThat((Object)table.cols().get(2), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_2")));
        Language.assertThat((Object)table.cols().get(3), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_3")));
    }

    @Test
    public void can_obtain_table_rows() {
        Table table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_5"));
        Language.assertThat((Object)table.tr(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)1)));
        table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_4"));
        Language.assertThat((Object)table.tr(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)4)));
        table = (Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_6"));
        Language.assertThat((Object)table.tr(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)8)));
    }

    @Test
    public void test_table_toString() {
        Language.assertThat((Object)((Table)ComponentFactory.component(Table.class, (By)By.$((String)"#table_2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Table with state : enabled:true, visible:true, column(s):0, row(s):1"));
    }

    @Test
    public void can_find_caption_by_id() {
        ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_table5"));
        try {
            ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#caption_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_caption() {
        try {
            ComponentFactory.component(Caption.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a Caption but a Table"));
        }
    }

    @Test
    public void test_caption_coreAttributes() {
        Caption caption_table5 = (Caption)ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_table5"));
        Language.assertThat((Object)caption_table5.title(), (Matcher)Matchers.is((Object)"caption5_title"));
        Language.assertThat((Object)caption_table5.id(), (Matcher)Matchers.is((Object)"caption_table5"));
        Language.assertThat((Object)caption_table5.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)caption_table5.classname(), (Matcher)Matchers.is((Object)"MyCAPTIONClass"));
    }

    @Test
    public void test_caption_i18nAttributes() {
        Caption caption_table6 = (Caption)ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_table6"));
        Caption caption_table5 = (Caption)ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_table5"));
        Language.assertThat((Object)caption_table6.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)caption_table6.language(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)caption_table5.language(), (Matcher)Matchers.is((Object)"ar"));
        Language.assertThat((Object)caption_table5.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_caption_content() {
        Caption caption_table5 = (Caption)ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_table5"));
        Language.assertThat((Object)caption_table5.content(), (Matcher)Matchers.is((Object)"A test table with cellspacing and cellpadding"));
    }

    @Test
    public void test_caption_toString() {
        Language.assertThat((Object)((Caption)ComponentFactory.component(Caption.class, (By)By.$((String)"#caption_table6"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Caption with state : enabled:true, visible:true, content:The XHTML Playoffs"));
    }

    @Test
    public void can_find_thead_by_id() {
        ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess1"));
        try {
            ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#thead_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_thead() {
        try {
            ComponentFactory.component(THead.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a THead but a Table"));
        }
    }

    @Test
    public void test_thead_coreAttributes() {
        THead thead_ess1 = (THead)ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess1"));
        Language.assertThat((Object)thead_ess1.title(), (Matcher)Matchers.is((Object)"thead1_Title"));
        Language.assertThat((Object)thead_ess1.id(), (Matcher)Matchers.is((Object)"thead_ess1"));
        Language.assertThat((Object)thead_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)thead_ess1.classname(), (Matcher)Matchers.is((Object)"MyTHEADClass"));
    }

    @Test
    public void test_thead_i18nAttributes() {
        THead thead_ess1 = (THead)ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess1"));
        THead thead_ess2 = (THead)ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess2"));
        Language.assertThat((Object)thead_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)thead_ess1.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)thead_ess2.language(), (Matcher)Matchers.is((Object)"ar"));
        Language.assertThat((Object)thead_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_thead_specificsAttributes() {
        THead thead = (THead)ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess2"));
        Language.assertThat((Object)thead.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.right));
        Language.assertThat((Object)thead.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.top));
    }

    @Test
    public void can_obtain_thead_tr() {
        THead thead = (THead)ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess1"));
        Language.assertThat((Object)thead.tr().size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void test_thead_toString() {
        Language.assertThat((Object)((THead)ComponentFactory.component(THead.class, (By)By.$((String)"#thead_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.THead with state : enabled:true, visible:true, title:thead1_Title"));
    }

    @Test
    public void can_find_tfoot_by_id() {
        ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess1"));
        try {
            ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#tfoot_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_tfoot() {
        try {
            ComponentFactory.component(TFoot.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a TFoot but a Table"));
        }
    }

    @Test
    public void test_tfoot_coreAttributes() {
        TFoot tfoot_ess1 = (TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess1"));
        TFoot tfoot_ess2 = (TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess2"));
        Language.assertThat((Object)tfoot_ess1.title(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)tfoot_ess2.id(), (Matcher)Matchers.is((Object)"tfoot_ess2"));
        Language.assertThat((Object)tfoot_ess2.style(), (Matcher)Matchers.containsString((String)"background-color:pink"));
        Language.assertThat((Object)tfoot_ess2.classname(), (Matcher)Matchers.is((Object)"MyTFOOTClass"));
    }

    @Test
    public void test_tfoot_i18nAttributes() {
        TFoot tfoot_ess1 = (TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess1"));
        TFoot tfoot_ess2 = (TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess2"));
        Language.assertThat((Object)tfoot_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)tfoot_ess1.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)tfoot_ess2.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)tfoot_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_tfoot_specificsAttributes() {
        TFoot tfoot = (TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess2"));
        Language.assertThat((Object)tfoot.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.left));
        Language.assertThat((Object)tfoot.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.bottom));
    }

    @Test
    public void can_obtain_tfoot_tr() {
        TFoot tfoot = (TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess2"));
        Language.assertThat((Object)tfoot.tr(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)1)));
        Language.assertThat((Object)((Tr)tfoot.tr().get(0)).id(), (Matcher)Matchers.is((Object)"tfoot_tr"));
    }

    @Test
    public void test_tfoot_toString() {
        Language.assertThat((Object)((TFoot)ComponentFactory.component(TFoot.class, (By)By.$((String)"#tfoot_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.TFoot with state : enabled:true, visible:true, title:tfoot_title2"));
    }

    @Test
    public void can_find_tbody_by_id() {
        ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess1"));
        try {
            ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#tbody_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_tbody() {
        try {
            ComponentFactory.component(TBody.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a TBody but a Table"));
        }
    }

    @Test
    public void test_tbody_coreAttributes() {
        TBody tbody_ess1 = (TBody)ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess1"));
        Language.assertThat((Object)tbody_ess1.title(), (Matcher)Matchers.is((Object)"tbody1_Title"));
        Language.assertThat((Object)tbody_ess1.id(), (Matcher)Matchers.is((Object)"tbody_ess1"));
        Language.assertThat((Object)tbody_ess1.style(), (Matcher)Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)tbody_ess1.classname(), (Matcher)Matchers.is((Object)"MyTBODYClass"));
    }

    @Test
    public void test_tbody_i18nAttributes() {
        TBody tbody_ess1 = (TBody)ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess1"));
        TBody tbody_ess2 = (TBody)ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess2"));
        Language.assertThat((Object)tbody_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)tbody_ess1.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)tbody_ess2.language(), (Matcher)Matchers.is((Object)"ar"));
        Language.assertThat((Object)tbody_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_tbody_specificsAttributes() {
        TBody tbody_ess2 = (TBody)ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess2"));
        Language.assertThat((Object)tbody_ess2.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.center));
        Language.assertThat((Object)tbody_ess2.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.baseline));
    }

    @Test
    public void can_obtain_tbody_tr() {
        TBody tbody = (TBody)ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess1"));
        Language.assertThat((Object)tbody.tr(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)5)));
    }

    @Test
    public void test_tbody_toString() {
        Language.assertThat((Object)((TBody)ComponentFactory.component(TBody.class, (By)By.$((String)"#tbody_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.TBody with state : enabled:true, visible:true, title:tbody1_Title"));
    }

    @Test
    public void can_find_colgroup_by_id() {
        ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess1"));
        try {
            ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#colgroup_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_colgroup() {
        try {
            ComponentFactory.component(Colgroup.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a Colgroup but a Table"));
        }
    }

    @Test
    public void test_colgroup_coreAttributes() {
        Colgroup colgroup_ess1 = (Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess1"));
        Language.assertThat((Object)colgroup_ess1.title(), (Matcher)Matchers.is((Object)"colgroup1_Title"));
        Language.assertThat((Object)colgroup_ess1.id(), (Matcher)Matchers.is((Object)"colgroup_ess1"));
        Language.assertThat((Object)colgroup_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)colgroup_ess1.classname(), (Matcher)Matchers.is((Object)"MyCOLGROUPClass"));
    }

    @Test
    public void test_colgroup_i18nAttributes() {
        Colgroup colgroup_ess1 = (Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess1"));
        Colgroup colgroup_ess2 = (Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess2"));
        Language.assertThat((Object)colgroup_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)colgroup_ess1.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)colgroup_ess2.language(), (Matcher)Matchers.is((Object)"ar"));
        Language.assertThat((Object)colgroup_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_colgroup_specificsAttributes() {
        Colgroup colgroup_ess1 = (Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess1"));
        Colgroup colgroup_ess2 = (Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess2"));
        Language.assertThat((Object)colgroup_ess2.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.right));
        Language.assertThat((Object)colgroup_ess2.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.top));
        Language.assertThat((Object)colgroup_ess1.span(), (Matcher)Matchers.is((Object)2));
        Language.assertThat((Object)colgroup_ess2.width(), (Matcher)Matchers.is((Object)"20%"));
    }

    @Test
    public void can_obtain_cols_associated() {
        Colgroup colgroup = (Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup"));
        Language.assertThat((Object)colgroup.cols(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)3)));
        Language.assertThat((Object)colgroup.cols().get(0), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_1")));
        Language.assertThat((Object)colgroup.cols().get(1), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_2")));
        Language.assertThat((Object)colgroup.cols().get(2), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"col_3")));
    }

    @Test
    public void test_colgroup_toString() {
        Language.assertThat((Object)((Colgroup)ComponentFactory.component(Colgroup.class, (By)By.$((String)"#colgroup_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Colgroup with state : enabled:true, visible:false, title:colgroup1_Title"));
    }

    @Test
    public void can_find_col_by_id() {
        ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess1"));
        try {
            ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#col_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_col() {
        try {
            ComponentFactory.component(Col.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a Col but a Table"));
        }
    }

    @Test
    public void test_col_coreAttributes() {
        Col col_ess1 = (Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess1"));
        Language.assertThat((Object)col_ess1.title(), (Matcher)Matchers.is((Object)"col1_Title"));
        Language.assertThat((Object)col_ess1.id(), (Matcher)Matchers.is((Object)"col_ess1"));
        Language.assertThat((Object)col_ess1.style(), (Matcher)Matchers.containsString((String)"width:7.6em"));
        Language.assertThat((Object)col_ess1.classname(), (Matcher)Matchers.is((Object)"MyCOLClass"));
    }

    @Test
    public void test_col_i18nAttributes() {
        Col col_ess1 = (Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess1"));
        Col col_ess2 = (Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess2"));
        Language.assertThat((Object)col_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)col_ess1.language(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)col_ess2.language(), (Matcher)Matchers.is((Object)"su"));
        Language.assertThat((Object)col_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_col_specificsAttributes() {
        Col col_ess1 = (Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess1"));
        Col col_ess2 = (Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess2"));
        Col col_ess3 = (Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess3"));
        Language.assertThat((Object)col_ess3.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.right));
        Language.assertThat((Object)col_ess3.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.top));
        Language.assertThat((Object)col_ess1.span(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)col_ess2.width(), (Matcher)Matchers.is((Object)"40%"));
    }

    @Test
    public void test_col_toString() {
        Language.assertThat((Object)((Col)ComponentFactory.component(Col.class, (By)By.$((String)"#col_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Col with state : enabled:true, visible:true, title:col1_Title"));
    }

    @Test
    public void can_find_tr_by_id() {
        ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess1"));
        try {
            ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#tr_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_tr() {
        try {
            ComponentFactory.component(Tr.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a Tr but a Table"));
        }
    }

    @Test
    public void test_tr_coreAttributes() {
        Tr tr_ess1 = (Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess1"));
        Language.assertThat((Object)tr_ess1.title(), (Matcher)Matchers.is((Object)"tr1_Title"));
        Language.assertThat((Object)tr_ess1.id(), (Matcher)Matchers.is((Object)"tr_ess1"));
        Language.assertThat((Object)tr_ess1.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)tr_ess1.classname(), (Matcher)Matchers.is((Object)"MyTRClass"));
    }

    @Test
    public void test_tr_i18nAttributes() {
        Tr tr_ess1 = (Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess1"));
        Tr tr_ess2 = (Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess2"));
        Language.assertThat((Object)tr_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)tr_ess1.language(), (Matcher)Matchers.is((Object)"ca"));
        Language.assertThat((Object)tr_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)tr_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_tr_specificsAttributes() {
        Tr tr = (Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess3"));
        Language.assertThat((Object)tr.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.left));
        Language.assertThat((Object)tr.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.top));
    }

    @Test
    public void test_can_obtain_td() {
        Tr tr = (Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess3"));
        Language.assertThat((Object)tr.td(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)3)));
        tr = (Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#female"));
        Language.assertThat((Object)tr.td(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)3)));
        Language.assertThat((Object)((Td)tr.td().get(0)).content(), (Matcher)Matchers.is((Object)"1.7"));
        Language.assertThat((Object)((Td)tr.td().get(1)).content(), (Matcher)Matchers.is((Object)"0.002"));
        Language.assertThat((Object)((Td)tr.td().get(2)).content(), (Matcher)Matchers.is((Object)"43%"));
        Language.assertThat((Object)tr.th(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.size((int)1)));
        Language.assertThat((Object)((Th)tr.th().get(0)).content(), (Matcher)Matchers.is((Object)"Females"));
    }

    @Test
    public void test_tr_toString() {
        Language.assertThat((Object)((Tr)ComponentFactory.component(Tr.class, (By)By.$((String)"#tr_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Tr with state : enabled:true, visible:true, title:tr1_Title"));
    }

    @Test
    public void can_find_th_by_id() {
        ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess1"));
        try {
            ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#th_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_th() {
        try {
            ComponentFactory.component(Th.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a Th but a Table"));
        }
    }

    @Test
    public void test_th_coreAttributes() {
        Th th_ess1 = (Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess1"));
        Language.assertThat((Object)th_ess1.title(), (Matcher)Matchers.is((Object)"th1_Title"));
        Language.assertThat((Object)th_ess1.id(), (Matcher)Matchers.is((Object)"th_ess1"));
        Language.assertThat((Object)th_ess1.style(), (Matcher)Matchers.containsString((String)"color:brown"));
        Language.assertThat((Object)th_ess1.classname(), (Matcher)Matchers.is((Object)"MyTHClass"));
    }

    @Test
    public void test_th_i18nAttributes() {
        Th th_ess1 = (Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess1"));
        Th th_ess2 = (Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess2"));
        Language.assertThat((Object)th_ess1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)th_ess1.language(), (Matcher)Matchers.is((Object)"ca"));
        Language.assertThat((Object)th_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)th_ess2.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void test_th_specificsAttributes() {
        Th th_ess2 = (Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess2"));
        Th th_ess3 = (Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess3"));
        Th th_ess4 = (Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess4"));
        Language.assertThat((Object)th_ess3.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.left));
        Language.assertThat((Object)th_ess3.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.top));
        Language.assertThat((Object)th_ess3.abbr(), (Matcher)Matchers.is((Object)"abbr tests for th"));
        Language.assertThat((Object)th_ess2.rowspan(), (Matcher)Matchers.is((Object)2));
        Language.assertThat((Object)th_ess3.colspan(), (Matcher)Matchers.is((Object)2));
        Language.assertThat((Object)th_ess4.axis(), (Matcher)Matchers.is((Object)"cat1, cat2, cat3"));
        Language.assertThat((Object)th_ess4.headers(), (Matcher)Matchers.is((Object)"id_cell1,id_cell2,id_cell3"));
        Language.assertThat((Object)th_ess4.scope(), (Matcher)Matchers.is((Object)Scope.col));
    }

    @Test
    public void test_th_toString() {
        Language.assertThat((Object)((Th)ComponentFactory.component(Th.class, (By)By.$((String)"#th_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Th with state : enabled:true, visible:true, title:th1_Title"));
    }

    @Test
    public void can_find_td_by_id() {
        ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess1"));
        try {
            ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#td_ess0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_td() {
        try {
            ComponentFactory.component(Td.class, (By)By.$((String)"#table_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=table_2 is not a Td but a Table"));
        }
    }

    @Test
    public void test_td_coreAttributes() {
        Td td_ess1 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess1"));
        Td td_ess3 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess3"));
        Language.assertThat((Object)td_ess1.title(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)td_ess1.id(), (Matcher)Matchers.is((Object)"td_ess1"));
        Language.assertThat((Object)td_ess1.style(), (Matcher)Matchers.containsString((String)"color:yellow"));
        Language.assertThat((Object)td_ess3.classname(), (Matcher)Matchers.is((Object)"MyTDClass"));
    }

    @Test
    public void test_td_i18nAttributes() {
        Td td_ess1 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess1"));
        Td td_ess2 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess2"));
        Language.assertThat((Object)td_ess1.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)td_ess1.language(), (Matcher)Matchers.is((Object)"ca"));
        Language.assertThat((Object)td_ess2.language(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)td_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
    }

    @Test
    public void test_td_specificsAttributes() {
        Td td_ess1 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess1"));
        Td td_ess2 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess2"));
        Td td_ess3 = (Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess3"));
        Language.assertThat((Object)td_ess2.cellhalign(), (Matcher)Matchers.is((Object)Cellhalign.left));
        Language.assertThat((Object)td_ess3.cellvalign(), (Matcher)Matchers.is((Object)Cellvalign.top));
        Language.assertThat((Object)td_ess1.abbr(), (Matcher)Matchers.is((Object)"abbreviation tests for td"));
        Language.assertThat((Object)td_ess2.rowspan(), (Matcher)Matchers.is((Object)3));
        Language.assertThat((Object)td_ess2.colspan(), (Matcher)Matchers.is((Object)4));
        Language.assertThat((Object)td_ess1.axis(), (Matcher)Matchers.is((Object)"cat4, cat5, cat6"));
        Language.assertThat((Object)td_ess2.headers(), (Matcher)Matchers.is((Object)"cell3, cell4, cell5"));
        Language.assertThat((Object)td_ess3.scope(), (Matcher)Matchers.is((Object)Scope.rowgroup));
    }

    @Test
    public void test_td_toString() {
        Language.assertThat((Object)((Td)ComponentFactory.component(Td.class, (By)By.$((String)"#td_ess1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Td with state : enabled:true, visible:true, title:, content:Sean"));
    }
}

