/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Button;

public class ButtonTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Button.html");
    }

    @Test
    public void can_find_button_by_id() {
        ComponentFactory.component(Button.class, (String)"button_1");
        try {
            ComponentFactory.component(Button.class, (String)"button_10");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=button_10"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_button() {
        try {
            ComponentFactory.component(Button.class, (String)"radio");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a Button but a Radio"));
        }
    }

    @Test
    public void can_obtain_button_text() {
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (String)"button_1")).text(), (Matcher)Matchers.is((Object)"buttonValue"));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (String)"button")).text(), (Matcher)Matchers.is((Object)"MyButtonText"));
    }

    @Test
    public void can_get_the_icon() {
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (String)"submitImage_1")).icon(), (Matcher)Matchers.containsString((String)"images/forward.png"));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (String)"submit_1")).icon(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (String)"button")).icon(), (Matcher)Matchers.containsString((String)"images/forward.png"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (String)"button")).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.core.component.Button with state : enabled:true, visible:true, text:MyButtonText, icon:images/forward.png"));
    }
}

