/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.CheckBox;
import org.testatoo.core.component.Component;
import org.testatoo.core.matcher.Matchers;
import org.testatoo.core.nature.Checkable;

public class CheckBoxTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("CheckBox.html");
    }

    @Test
    public void can_find_checkbox_by_id() {
        ComponentFactory.component(CheckBox.class, (String)"firstChoice");
        try {
            ComponentFactory.component(CheckBox.class, (String)"otherChoice");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by id=otherChoice"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_checkbox() {
        try {
            ComponentFactory.component(CheckBox.class, (String)"text_1");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=text_1 is not a CheckBox but a TextField"));
        }
    }

    @Test
    public void can_check() {
        CheckBox firstchoice = (CheckBox)ComponentFactory.component(CheckBox.class, (String)"firstChoice");
        Language.assertThat((Object)firstchoice, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        Language.clickOn((Component)firstchoice);
        Language.assertThat((Object)firstchoice, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Language.clickOn((Component)firstchoice);
        Language.assertThat((Object)firstchoice, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        CheckBox secondchoice = (CheckBox)ComponentFactory.component(CheckBox.class, (String)"secondChoice");
        Language.assertThat((Object)secondchoice, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        Language.check((Checkable)secondchoice);
        Language.assertThat((Object)secondchoice, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Language.unCheck((CheckBox)secondchoice);
        Language.assertThat((Object)secondchoice, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(CheckBox.class, (String)"checkbox"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Checkbox Label")));
        Language.assertThat((Object)ComponentFactory.component(CheckBox.class, (String)"checkbox2"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Checkbox into label")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((CheckBox)ComponentFactory.component(CheckBox.class, (String)"checkbox")).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.core.component.CheckBox with state : enabled:true, visible:true, label:Checkbox Label, checked:false"));
    }
}

