/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.input;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.element.Div;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.AbstractTextField;
import org.testatoo.core.input.KeyModifier;
import org.testatoo.core.input.Keyboard;

public class KeyboardTest
extends WebTest {
    @Test
    public void can_type_data() {
        ComponentFactory.page().open("InputText.html");
        InputText inputLanguage = (InputText)ComponentFactory.component(InputText.class, (String)"input_language");
        Language.assertThat((Object)inputLanguage.value(), (Matcher)Matchers.is((Object)"french"));
        Language.type((String)" AS language", (AbstractTextField)((AbstractTextField)Language.into((Object)inputLanguage)));
        Language.assertThat((Object)inputLanguage.value(), (Matcher)Matchers.is((Object)"french AS language"));
    }

    @Test
    public void can_test_key_modifier() {
        ComponentFactory.page().open("KeyboardTest.html");
        Keyboard.keyDown((KeyModifier)KeyModifier.CONTROL);
        Keyboard.keyDown((KeyModifier)KeyModifier.SHIFT);
        Language.assertThat((Object)((Div)ComponentFactory.component(Div.class, (String)"_Ctrl_Shift_a")).classname(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"dirty")));
        Keyboard.type((String)"a");
        Language.assertThat((Object)((Div)ComponentFactory.component(Div.class, (String)"_Ctrl_Shift_a")).classname(), (Matcher)Matchers.containsString((String)"dirty"));
        Keyboard.release((KeyModifier)KeyModifier.CONTROL);
        Language.assertThat((Object)((Div)ComponentFactory.component(Div.class, (String)"_Shift_a")).classname(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"dirty")));
        Keyboard.type((String)"a");
        Language.assertThat((Object)((Div)ComponentFactory.component(Div.class, (String)"_Shift_a")).classname(), (Matcher)Matchers.containsString((String)"dirty"));
        Keyboard.release((KeyModifier)KeyModifier.SHIFT);
        Keyboard.release();
        Language.assertThat((Object)((Div)ComponentFactory.component(Div.class, (String)"_a")).classname(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"dirty")));
        Keyboard.type((String)"a");
        Language.assertThat((Object)((Div)ComponentFactory.component(Div.class, (String)"_a")).classname(), (Matcher)Matchers.containsString((String)"dirty"));
    }
}

