/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.cartridge.html4.element.Attribute;
import org.testatoo.cartridge.html4.element.Cellhalign;
import org.testatoo.cartridge.html4.element.Cellvalign;
import org.testatoo.cartridge.html4.element.Form;
import org.testatoo.cartridge.html4.element.Frame;
import org.testatoo.cartridge.html4.element.FrameSet;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.cartridge.html4.element.InputType;
import org.testatoo.cartridge.html4.element.Label;
import org.testatoo.cartridge.html4.element.Link;
import org.testatoo.cartridge.html4.element.Method;
import org.testatoo.cartridge.html4.element.Object;
import org.testatoo.cartridge.html4.element.Param;
import org.testatoo.cartridge.html4.element.Scope;
import org.testatoo.cartridge.html4.element.Scrolling;
import org.testatoo.cartridge.html4.element.Shape;
import org.testatoo.cartridge.html4.element.TFrame;
import org.testatoo.cartridge.html4.element.TRules;
import org.testatoo.cartridge.html4.element.Table;
import org.testatoo.cartridge.html4.element.ValueType;
import org.testatoo.core.component.Component;

public final class AttributeSupport {
    private HtmlEvaluator evaluator;

    AttributeSupport(HtmlEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    String value(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.value);
    }

    String alt(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.alt);
    }

    Integer tabindex(Component component) {
        String tabIndex = this.evaluator.attribute(component.id(), Attribute.tabindex);
        if (tabIndex.isEmpty()) {
            return 0;
        }
        return Integer.valueOf(tabIndex);
    }

    String accesskey(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.accesskey);
    }

    Integer size(Component component) {
        String size = this.evaluator.attribute(component.id(), Attribute.size);
        if (size.isEmpty()) {
            return 0;
        }
        return Integer.valueOf(size);
    }

    String name(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.name);
    }

    String longdesc(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.longdesc);
    }

    String usemap(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.usemap);
    }

    String charset(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.charset);
    }

    String href(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.href);
    }

    String hreflang(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.hreflang);
    }

    String rel(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.rel);
    }

    String rev(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.rev);
    }

    Shape shape(Component component) {
        return Shape.valueOf(this.evaluator.attribute(component.id(), Attribute.shape).toLowerCase());
    }

    String coords(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.coords);
    }

    InputType inputType(InputText inputText) {
        return InputType.valueOf(this.evaluator.attribute(inputText.id(), Attribute.type).toLowerCase());
    }

    String type(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.type);
    }

    Method method(Form form) {
        String method = this.evaluator.attribute(form.id(), Attribute.method).toLowerCase();
        if (method.equals("")) {
            return Method.get;
        }
        return Method.valueOf(method);
    }

    String action(Form form) {
        return this.evaluator.attribute(form.id(), Attribute.action);
    }

    String enctype(Form form) {
        String enctype = this.evaluator.attribute(form.id(), Attribute.enctype);
        if (enctype.equals("")) {
            return "application/x-www-form-urlencoded";
        }
        return enctype;
    }

    String accept(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.accept);
    }

    String acceptCharset(Form form) {
        String acceptCharset = this.evaluator.attribute(form.id(), Attribute.acceptcharset);
        if (acceptCharset.equals("")) {
            return "UNKNOWN";
        }
        return acceptCharset;
    }

    String summary(Table table) {
        return this.evaluator.attribute(table.id(), Attribute.summary);
    }

    String width(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.width);
    }

    Integer border(Component component) {
        String border = this.evaluator.attribute(component.id(), Attribute.border);
        if (border.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(border);
    }

    TFrame frame(Table table) {
        return TFrame.valueOf(this.evaluator.attribute(table.id(), Attribute.frame));
    }

    TRules rules(Table table) {
        return TRules.valueOf(this.evaluator.attribute(table.id(), Attribute.rules));
    }

    String cellspacing(Table table) {
        return this.evaluator.attribute(table.id(), Attribute.cellspacing);
    }

    String cellpadding(Table table) {
        return this.evaluator.attribute(table.id(), Attribute.cellpadding);
    }

    Cellhalign cellhalign(Component component) {
        return Cellhalign.valueOf(this.evaluator.attribute(component.id(), Attribute.cellhalign));
    }

    Cellvalign cellvalign(Component component) {
        return Cellvalign.valueOf(this.evaluator.attribute(component.id(), Attribute.cellvalign));
    }

    Integer span(Component component) {
        String span = this.evaluator.attribute(component.id(), Attribute.span);
        if (span.isEmpty()) {
            return 1;
        }
        return Integer.parseInt(span);
    }

    String abbr(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.abbr);
    }

    Integer rowspan(Component component) {
        String rowspan = this.evaluator.attribute(component.id(), Attribute.rowspan);
        if (rowspan.isEmpty()) {
            return 1;
        }
        return Integer.parseInt(rowspan);
    }

    Integer colspan(Component component) {
        String colspan = this.evaluator.attribute(component.id(), Attribute.colspan);
        if (colspan.isEmpty()) {
            return 1;
        }
        return Integer.parseInt(colspan);
    }

    String axis(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.axis);
    }

    String headers(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.headers);
    }

    Scope scope(Component component) {
        return Scope.valueOf(this.evaluator.attribute(component.id(), Attribute.scope));
    }

    String media(Link link) {
        return this.evaluator.attribute(link.id(), Attribute.media);
    }

    Integer rows(Component component) {
        return Integer.parseInt(this.evaluator.attribute(component.id(), Attribute.rows));
    }

    Integer cols(Component component) {
        return Integer.parseInt(this.evaluator.attribute(component.id(), Attribute.cols));
    }

    String _for(Label label) {
        return this.evaluator.attribute(label.id(), Attribute._for);
    }

    String src(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.src);
    }

    Integer frameborder(Component component) {
        String frameborder = this.evaluator.attribute(component.id(), Attribute.frameborder);
        if (frameborder.isEmpty()) {
            return 1;
        }
        return Integer.parseInt(frameborder);
    }

    Integer marginwidth(Component component) {
        String marginwidth = this.evaluator.attribute(component.id(), Attribute.marginwidth);
        if (marginwidth.isEmpty()) {
            return 1;
        }
        return Integer.parseInt(marginwidth);
    }

    Integer marginheight(Component component) {
        String marginheight = this.evaluator.attribute(component.id(), Attribute.marginheight);
        if (marginheight.isEmpty()) {
            return 1;
        }
        return Integer.parseInt(marginheight);
    }

    Boolean noresize(Frame frame) {
        return this.evaluator.exist(frame.id(), Attribute.noresize);
    }

    Scrolling scrolling(Component component) {
        String value = this.evaluator.attribute(component.id(), Attribute.scrolling);
        if (value.isEmpty()) {
            return Scrolling.auto;
        }
        return Scrolling.valueOf(value);
    }

    String classid(Object object) {
        return this.evaluator.attribute(object.id(), Attribute.classid);
    }

    String codebase(Object object) {
        return this.evaluator.attribute(object.id(), Attribute.codebase);
    }

    String data(Object object) {
        return this.evaluator.attribute(object.id(), Attribute.data);
    }

    String codetype(Object object) {
        return this.evaluator.attribute(object.id(), Attribute.codetype);
    }

    String archive(Object object) {
        return this.evaluator.attribute(object.id(), Attribute.archive);
    }

    String standby(Object object) {
        return this.evaluator.attribute(object.id(), Attribute.standby);
    }

    String height(Component component) {
        return this.evaluator.attribute(component.id(), Attribute.height);
    }

    ValueType valuetype(Param param) {
        if (this.evaluator.attribute(param.id(), Attribute.valuetype).equals("")) {
            return ValueType.data;
        }
        return ValueType.valueOf(this.evaluator.attribute(param.id(), Attribute.valuetype));
    }

    String framesetCols(FrameSet frameset) {
        return this.evaluator.attribute(frameset.id(), Attribute.cols);
    }

    String framesetRows(FrameSet frameset) {
        return this.evaluator.attribute(frameset.id(), Attribute.rows);
    }
}

