/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.EvaluatorHolder;
import org.testatoo.core.Language;
import org.testatoo.core.component.Button;
import org.testatoo.core.component.Panel;
import org.testatoo.core.matcher.Matchers;

public class FinderTest
extends WebTest {
    @Test
    public void can_find_element_by_id_with_points() {
        ComponentFactory.page().open("ElementIdWithPoints.html");
        Language.assertThat((Object)ComponentFactory.component(Button.class, (By)By.$((String)"#my\\\\.button\\\\.id")), (Matcher)Matchers.exist());
        Language.assertThat((Object)new Panel(EvaluatorHolder.get(), "my.panel.id"), (Matcher)Matchers.exist());
    }

    @Test
    public void can_find_one_component_with_jQuery_expression() {
        ComponentFactory.page().open("Button.html");
        Language.assertThat((Object)ComponentFactory.component(Button.class, (By)By.$((String)":submit:first")), (Matcher)Matchers.exist());
    }

    @Test
    public void can_find_elements_with_multiple_search() {
        ComponentFactory.page().open("MultipleElements.html");
        Language.assertThat((Object)ComponentFactory.components(Panel.class, (By)By.$((String)".classp")), (Matcher)Matchers.has((Matcher)Matchers.size((int)3)));
    }

    @Test
    public void can_see_explicit_exception_when_no_element_is_found_on_simple_search() {
        ComponentFactory.page().open("MultipleElements.html");
        try {
            ComponentFactory.component(Panel.class, (By)By.$((String)".classUnknow"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('.classUnknow')"));
        }
    }

    @Test
    public void can_see_explicit_exception_when_no_element_is_found_on_multiple_search() {
        ComponentFactory.page().open("MultipleElements.html");
        try {
            ComponentFactory.components(Panel.class, (By)By.$((String)".classUnknow"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('.classUnknow')"));
        }
    }

    @Test
    public void can_see_explicit_exception_when_there_is_any_elements_found_on_simple_search() {
        ComponentFactory.page().open("MultipleElements.html");
        try {
            ComponentFactory.component(Panel.class, (By)By.$((String)".classp"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Find more than one component defined by jQueryExpression=$('.classp')"));
        }
    }
}

