/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Button;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.InputType;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class ButtonTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Button.html");
    }

    @Test
    public void exception_thrown_if_component_not_a_html_button() {
        try {
            ComponentFactory.component(Button.class, (By)By.$((String)"#country"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=country is not a Button but a DropDown"));
        }
    }

    @Test
    public void exception_thrown_if_component_is_a_radio_button() {
        try {
            ComponentFactory.component(Button.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a Button but a Radio"));
        }
    }

    @Test
    public void can_get_button_type() {
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage_1"))).type(), (Matcher)Matchers.is((Object)InputType.image));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submit_1"))).type(), (Matcher)Matchers.is((Object)InputType.submit));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#reset_1"))).type(), (Matcher)Matchers.is((Object)InputType.reset));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage_1"))).type(), (Matcher)Matchers.is((Object)InputType.image));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button"))).type(), (Matcher)Matchers.is((Object)InputType.submit));
    }

    @Test
    public void can_get_the_icon() {
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage_1"))).icon(), (Matcher)Matchers.containsString((String)"images/forward.png"));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submit_1"))).icon(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button"))).icon(), (Matcher)Matchers.containsString((String)"images/forward.png"));
    }

    @Test
    public void test_i18nAttributes() {
        Button button = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button_2"));
        Language.assertThat((Object)button.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)button.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Button button = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button_2"));
        Language.assertThat((Object)button.id(), (Matcher)Matchers.is((Object)"button_2"));
        Language.assertThat((Object)button.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)button.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)button.title(), (Matcher)Matchers.is((Object)"buttonTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        Button button = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button"));
        Language.assertThat((Object)button.name(), (Matcher)Matchers.is((Object)"myButtonName"));
        Language.assertThat((Object)button.value(), (Matcher)Matchers.is((Object)"myButtonValue"));
        Language.assertThat((Object)button.alt(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)button.tabindex(), (Matcher)Matchers.is((Object)0));
        Language.assertThat((Object)button.accesskey(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)button.type(), (Matcher)Matchers.is((Object)InputType.submit));
        Button button2 = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button_2"));
        Language.assertThat((Object)button2.name(), (Matcher)Matchers.is((Object)"myButton"));
        Language.assertThat((Object)button2.value(), (Matcher)Matchers.is((Object)"buttonValue"));
        Language.assertThat((Object)button2.alt(), (Matcher)Matchers.is((Object)"short description"));
        Language.assertThat((Object)button2.tabindex(), (Matcher)Matchers.is((Object)5));
        Language.assertThat((Object)button2.accesskey(), (Matcher)Matchers.is((Object)"C"));
    }

    @Test
    public void test_is_enabled() {
        Button button1 = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button"));
        Language.assertThat((Object)button1.isEnabled(), (Matcher)Matchers.is((Object)true));
        Language.assertThat((Object)button1.isDisabled(), (Matcher)Matchers.is((Object)false));
        Button disabledButton = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#disabledButton"));
        Language.assertThat((Object)disabledButton.isEnabled(), (Matcher)Matchers.is((Object)false));
        Language.assertThat((Object)disabledButton.isDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Button with state : enabled:true, visible:true, text:MyButtonText, icon:images/forward.png"));
        Language.assertThat((Object)((Button)ComponentFactory.component(Button.class, (By)By.$((String)"#button_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Button with state : enabled:true, visible:true, text:buttonValue, icon:"));
    }
}

