/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.CheckBox;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class CheckBoxTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("CheckBox.html");
    }

    @Test
    public void exception_thrown_if_component_not_a_html_checkbox() {
        try {
            ComponentFactory.component(CheckBox.class, (By)By.$((String)"#hidden_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=hidden_1 is not a CheckBox but a Hidden"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        CheckBox checkbox = (CheckBox)ComponentFactory.component(CheckBox.class, (By)By.$((String)"#checkbox"));
        Language.assertThat((Object)checkbox.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)checkbox.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        CheckBox checkbox = (CheckBox)ComponentFactory.component(CheckBox.class, (By)By.$((String)"#checkbox"));
        Language.assertThat((Object)checkbox.id(), (Matcher)Matchers.is((Object)"checkbox"));
        Language.assertThat((Object)checkbox.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)checkbox.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)checkbox.title(), (Matcher)Matchers.is((Object)"checkboxTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        CheckBox checkbox = (CheckBox)ComponentFactory.component(CheckBox.class, (By)By.$((String)"#checkbox"));
        Language.assertThat((Object)checkbox.name(), (Matcher)Matchers.is((Object)"myCheckbox"));
        Language.assertThat((Object)checkbox.value(), (Matcher)Matchers.is((Object)"checkboxValue"));
        Language.assertThat((Object)checkbox.alt(), (Matcher)Matchers.is((Object)"short description"));
        Language.assertThat((Object)checkbox.tabindex(), (Matcher)Matchers.is((Object)5));
        Language.assertThat((Object)checkbox.accesskey(), (Matcher)Matchers.is((Object)"C"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((CheckBox)ComponentFactory.component(CheckBox.class, (By)By.$((String)"#checkbox2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.CheckBox with state : enabled:true, visible:true, label:Checkbox into label, checked:false"));
    }
}

