/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Button;
import org.testatoo.cartridge.html4.element.CheckBox;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Form;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.cartridge.html4.element.Method;
import org.testatoo.cartridge.html4.element.Radio;
import org.testatoo.cartridge.html4.element.Select;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.AbstractTextField;
import org.testatoo.core.component.Component;
import org.testatoo.core.nature.Checkable;

public class FormTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("Form.html");
    }

    @Test
    public void can_find_form_by_id() {
        ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        try {
            ComponentFactory.component(Form.class, (By)By.$((String)"#otherForm"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#otherForm')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_form() {
        try {
            ComponentFactory.component(Form.class, (By)By.$((String)"#email"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=email is not a Form but a InputText"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Language.assertThat((Object)myForm.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)myForm.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Language.assertThat((Object)myForm.id(), (Matcher)Matchers.is((Object)"myForm"));
        Language.assertThat((Object)myForm.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)myForm.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)myForm.title(), (Matcher)Matchers.is((Object)"formTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Language.assertThat((Object)myForm.method(), (Matcher)Matchers.is((Object)Method.post));
        Language.assertThat((Object)myForm.action(), (Matcher)Matchers.is((Object)"Exit.html"));
        Language.assertThat((Object)myForm.enctype(), (Matcher)Matchers.is((Object)"application/x-www-form-urlencoded"));
        Language.assertThat((Object)myForm.accept(), (Matcher)Matchers.is((Object)"all"));
        Language.assertThat((Object)myForm.name(), (Matcher)Matchers.is((Object)"formName"));
    }

    @Test
    public void if_attribute_are_not_defined_then_return_default_values() {
        Form myForm3 = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm3"));
        Language.assertThat((Object)myForm3.method(), (Matcher)Matchers.is((Object)Method.get));
        Language.assertThat((Object)myForm3.enctype(), (Matcher)Matchers.is((Object)"application/x-www-form-urlencoded"));
        Language.assertThat((Object)myForm3.accept(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)myForm3.name(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)myForm3.acceptCharset(), (Matcher)Matchers.is((Object)"UNKNOWN"));
    }

    @Test
    public void test_contains() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Select citiesList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#cities"));
        Language.assertThat((Object)myForm.contains(new Component[]{citiesList}), (Matcher)Matchers.is((Object)true));
        InputText inputText = (InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#lastname"));
        Language.assertThat((Object)myForm.contains(new Component[]{inputText}), (Matcher)Matchers.is((Object)true));
        Radio radio = (Radio)ComponentFactory.component(Radio.class, (By)By.$((String)"#male"));
        Language.assertThat((Object)myForm.contains(new Component[]{radio}), (Matcher)Matchers.is((Object)true));
        CheckBox checkBox = (CheckBox)ComponentFactory.component(CheckBox.class, (By)By.$((String)"[name=yes]"));
        Language.assertThat((Object)myForm.contains(new Component[]{checkBox}), (Matcher)Matchers.is((Object)true));
        Button button = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage"));
        Language.assertThat((Object)myForm.contains(new Component[]{button}), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void can_reset_a_form() {
        Language.type((String)"Joe", (AbstractTextField)((AbstractTextField)Language.on((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#firstname")))));
        Language.type((String)"Blow", (AbstractTextField)((AbstractTextField)Language.into((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#lastname")))));
        Language.enter((String)"email@noname.com", (AbstractTextField)((AbstractTextField)Language.into((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#email")))));
        Language.check((Checkable)((Checkable)ComponentFactory.component(Radio.class, (By)By.$((String)"#male"))));
        Language.check((Checkable)((Checkable)ComponentFactory.component(CheckBox.class, (By)By.$((String)"[name=yes]"))));
        ((Select)Language.on((Object)ComponentFactory.component(Select.class, (By)By.$((String)"#cities")))).select("Casablanca");
        ((Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"))).reset();
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#firstname")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.value((String)"")));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#lastname")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.value((String)"")));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#email")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.value((String)"")));
        Language.assertThat((Object)ComponentFactory.component(Radio.class, (By)By.$((String)"#male")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)org.testatoo.core.matcher.Matchers.checked())));
        Language.assertThat((Object)ComponentFactory.component(CheckBox.class, (By)By.$((String)"[name=yes]")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)org.testatoo.core.matcher.Matchers.checked())));
        Language.assertThat((Object)ComponentFactory.component(Select.class, (By)By.$((String)"#cities")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.selectedValues((String[])new String[]{"New York"})));
        Language.type((String)"Joe", (AbstractTextField)((AbstractTextField)Language.on((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#firstname")))));
        Language.type((String)"Blow", (AbstractTextField)((AbstractTextField)Language.into((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#lastname")))));
        Language.enter((String)"email@noname.com", (AbstractTextField)((AbstractTextField)Language.into((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#email")))));
        Language.check((Checkable)((Checkable)ComponentFactory.component(Radio.class, (By)By.$((String)"#male"))));
        Language.check((Checkable)((Checkable)ComponentFactory.component(CheckBox.class, (By)By.$((String)"[name=yes]"))));
        ((Select)Language.on((Object)ComponentFactory.component(Select.class, (By)By.$((String)"#cities")))).select("Casablanca");
        ((Form)Language.on((Object)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm")))).reset();
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#firstname")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.value((String)"")));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#lastname")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.value((String)"")));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#email")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.value((String)"")));
        Language.assertThat((Object)ComponentFactory.component(Radio.class, (By)By.$((String)"#male")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)org.testatoo.core.matcher.Matchers.checked())));
        Language.assertThat((Object)ComponentFactory.component(CheckBox.class, (By)By.$((String)"[name=yes]")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)org.testatoo.core.matcher.Matchers.checked())));
        Language.assertThat((Object)ComponentFactory.component(Select.class, (By)By.$((String)"#cities")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.selectedValues((String[])new String[]{"New York"})));
    }

    @Test
    public void can_submit_a_form() {
        Language.assertThat((Object)ComponentFactory.page().title(), (Matcher)Matchers.is((Object)"Form tests"));
        Button submitButton = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage"));
        Language.clickOn((Component)submitButton);
        Language.waitUntil((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Exit page")));
        ComponentFactory.page().open("Form.html");
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Form tests")));
        Language.clickOn((Component)submitButton);
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Exit page")));
        ComponentFactory.page().open("Form.html");
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Form tests")));
        ((Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"))).submit();
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Exit page")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Form with state : enabled:true, visible:true, action:Exit.html"));
    }
}

