/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Frame;
import org.testatoo.cartridge.html4.element.FrameSet;
import org.testatoo.cartridge.html4.element.NoFrames;
import org.testatoo.cartridge.html4.element.Scrolling;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class FrameTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Frame.html");
    }

    @Test
    public void can_find_frameSet_by_id() {
        ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frameset_1"));
        try {
            ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frameset_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#frameset_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_frameset() {
        try {
            ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frame_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=frame_1 is not a FrameSet but a Frame"));
        }
    }

    @Test
    public void test_frameSet_coreAttributes() {
        FrameSet frameset_1 = (FrameSet)ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frameset_1"));
        Language.assertThat((Object)frameset_1.id(), (Matcher)Matchers.is((Object)"frameset_1"));
        Language.assertThat((Object)frameset_1.classname(), (Matcher)Matchers.is((Object)"MyFRAMESETClass"));
        Language.assertThat((Object)frameset_1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)frameset_1.title(), (Matcher)Matchers.is((Object)"framesetTitle1"));
    }

    @Test
    public void test_frameSet_specifics_attributes() {
        FrameSet frameset_1 = (FrameSet)ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frameset_1"));
        FrameSet frameset_2 = (FrameSet)ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frameset_2"));
        Language.assertThat((Object)frameset_1.cols(), (Matcher)Matchers.is((Object)"20%, 80%"));
        Language.assertThat((Object)frameset_1.rows(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)frameset_2.cols(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)frameset_2.rows(), (Matcher)Matchers.is((Object)"100, 200"));
    }

    @Test
    public void test_frameset_toString() {
        Language.assertThat((Object)((FrameSet)ComponentFactory.component(FrameSet.class, (By)By.$((String)"#frameset_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.FrameSet with state : enabled:true, visible:true, title:framesetTitle1"));
    }

    @Test
    public void can_find_frame_by_id() {
        ComponentFactory.component(Frame.class, (By)By.$((String)"#frame_1"));
        try {
            ComponentFactory.component(Frame.class, (By)By.$((String)"#frame_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#frame_0')"));
        }
    }

    @Test
    @Ignore
    public void exception_thrown_if_component_not_a_html_frame() {
        try {
            ComponentFactory.component(Frame.class, (By)By.$((String)"#myDiv"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=noFrames_1 is not a Frame but a NoFrames"));
        }
    }

    @Test
    public void test_frame_coreAttributes() {
        Frame frame_1 = (Frame)ComponentFactory.component(Frame.class, (By)By.$((String)"#frame_1"));
        Language.assertThat((Object)frame_1.id(), (Matcher)Matchers.is((Object)"frame_1"));
        Language.assertThat((Object)frame_1.classname(), (Matcher)Matchers.is((Object)"MyFRAMEClass"));
        Language.assertThat((Object)frame_1.style(), (Matcher)Matchers.containsString((String)"color:brown"));
        Language.assertThat((Object)frame_1.title(), (Matcher)Matchers.is((Object)"frameTitle1"));
    }

    @Test
    public void test_frame_specifics_attributes() {
        Frame frame_1 = (Frame)ComponentFactory.component(Frame.class, (By)By.$((String)"#frame_1"));
        Frame frame_2 = (Frame)ComponentFactory.component(Frame.class, (By)By.$((String)"#frame_2"));
        Language.assertThat((Object)frame_1.name(), (Matcher)Matchers.is((Object)"frameName1"));
        Language.assertThat((Object)frame_1.frameborder(), (Matcher)Matchers.is((Object)1));
        Language.assertThat((Object)frame_2.frameborder(), (Matcher)Matchers.is((Object)0));
        Language.assertThat((Object)frame_2.longdesc(), (Matcher)Matchers.is((Object)"Label.html"));
        Language.assertThat((Object)frame_2.marginheight(), (Matcher)Matchers.is((Object)30));
        Language.assertThat((Object)frame_2.marginwidth(), (Matcher)Matchers.is((Object)40));
        Language.assertThat((Object)frame_1.scrolling(), (Matcher)Matchers.is((Object)Scrolling.no));
        Language.assertThat((Object)frame_1.src(), (Matcher)Matchers.is((Object)"Button.html"));
        Language.assertThat((Object)frame_1.noresize(), (Matcher)Matchers.is((Object)false));
        Language.assertThat((Object)frame_2.noresize(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void test_frame_toString() {
        Language.assertThat((Object)((Frame)ComponentFactory.component(Frame.class, (By)By.$((String)"#frame_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Frame with state : enabled:true, visible:true, title:frameTitle1"));
    }

    @Test
    @Ignore
    public void can_find_noFrames_by_id() {
        ComponentFactory.component(NoFrames.class, (By)By.$((String)"#noFrames_1"));
        try {
            ComponentFactory.component(NoFrames.class, (By)By.$((String)"#noFrames_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=noFrames_0"));
        }
    }

    @Test
    @Ignore
    public void exception_thrown_if_component_not_a_html_noframes() {
        try {
            ComponentFactory.component(NoFrames.class, (By)By.$((String)"#frameset_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=frameset_2 is not a NoFrames but a FrameSet"));
        }
    }

    @Test
    @Ignore
    public void test_noFrames_coreAttributes() {
        NoFrames noFrames_1 = (NoFrames)ComponentFactory.component(NoFrames.class, (By)By.$((String)"#noFrames_1"));
        Language.assertThat((Object)noFrames_1.title(), (Matcher)Matchers.is((Object)"noFramesTitle1"));
        Language.assertThat((Object)noFrames_1.id(), (Matcher)Matchers.is((Object)"noFrames_1"));
        Language.assertThat((Object)noFrames_1.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)noFrames_1.classname(), (Matcher)Matchers.is((Object)"MyNOFRAMESClass"));
    }

    @Test
    @Ignore
    public void test_noFrames_i18nAttributes() {
        NoFrames noFrames_1 = (NoFrames)ComponentFactory.component(NoFrames.class, (By)By.$((String)"#noFrames_1"));
        Language.assertThat((Object)noFrames_1.language(), (Matcher)Matchers.is((Object)"ar"));
        Language.assertThat((Object)noFrames_1.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    @Ignore
    public void test_noframes_toString() {
        Language.assertThat((Object)((NoFrames)ComponentFactory.component(NoFrames.class, (By)By.$((String)"#noFrames_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.NoFrames with state : enabled:true, visible:false, title:noFramesTitle1"));
    }
}

