/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.InputPassword;
import org.testatoo.cartridge.html4.element.InputType;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class InputPasswordTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("InputPassword.html");
    }

    @Test
    public void can_find_inputText_by_id() {
        ComponentFactory.component(InputPassword.class, (By)By.$((String)"#input_1"));
        try {
            ComponentFactory.component(InputPassword.class, (By)By.$((String)"#input_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#input_2')"));
        }
        try {
            ComponentFactory.component(InputPassword.class, (By)By.$((String)"#inputPasswordError"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=inputPasswordError is not a PasswordField but a CheckBox"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_inputPassword() {
        try {
            ComponentFactory.component(InputPassword.class, (By)By.$((String)"#image_3"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=image_3 is not a PasswordField but a Image"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        InputPassword myInputPwd = (InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password"));
        Language.assertThat((Object)myInputPwd.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)myInputPwd.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        InputPassword myInputPwd = (InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password"));
        Language.assertThat((Object)myInputPwd.id(), (Matcher)org.hamcrest.Matchers.is((Object)"password"));
        Language.assertThat((Object)myInputPwd.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)myInputPwd.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)myInputPwd.title(), (Matcher)org.hamcrest.Matchers.is((Object)"passwordTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        InputPassword myInputPwd = (InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password"));
        Language.assertThat((Object)myInputPwd.name(), (Matcher)org.hamcrest.Matchers.is((Object)"myPassword"));
        Language.assertThat((Object)myInputPwd.value(), (Matcher)org.hamcrest.Matchers.is((Object)"passwordValue"));
        Language.assertThat((Object)myInputPwd.alt(), (Matcher)org.hamcrest.Matchers.is((Object)"short description"));
        Language.assertThat((Object)myInputPwd.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)5));
        Language.assertThat((Object)myInputPwd.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)"C"));
        Language.assertThat((Object)myInputPwd.size(), (Matcher)org.hamcrest.Matchers.is((Object)15));
        Language.assertThat((Object)myInputPwd.type(), (Matcher)org.hamcrest.Matchers.is((Object)InputType.password));
        InputPassword myInputPwdDef = (InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password_def"));
        Language.assertThat((Object)myInputPwdDef.name(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myInputPwdDef.value(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myInputPwdDef.alt(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myInputPwdDef.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)0));
        Language.assertThat((Object)myInputPwdDef.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myInputPwdDef.size(), (Matcher)org.hamcrest.Matchers.is((Object)8));
        Language.assertThat((Object)myInputPwdDef.type(), (Matcher)org.hamcrest.Matchers.is((Object)InputType.password));
    }

    @Test
    public void can_test_if_readonly() {
        Assert.assertTrue((boolean)((InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password"))).isReadOnly());
        Language.assertThat((Object)((InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password_1"))).isReadOnly(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void can_test_max_length() {
        Language.assertThat((Object)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#input_1")), (Matcher)Matchers.has((Matcher)Matchers.maxLength((int)10)));
        Language.assertThat((Object)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password_1")), (Matcher)Matchers.has((Matcher)Matchers.maxLength((int)20)));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((InputPassword)ComponentFactory.component(InputPassword.class, (By)By.$((String)"#password"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.InputPassword with state : enabled:false, visible:true, value:passwordValue, label:Password label, maxLength:8"));
    }
}

