/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Legend;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class LegendTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("FieldSet.html");
    }

    @Test
    public void can_find_legend_by_id() {
        ComponentFactory.component(Legend.class, (By)By.$((String)"#legend_1"));
        try {
            ComponentFactory.component(Legend.class, (By)By.$((String)"#legend_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#legend_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_legend() {
        try {
            ComponentFactory.component(Legend.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a Legend but a Radio"));
        }
    }

    @Test
    public void test_legend_i18nAttributes() {
        Legend legend = (Legend)ComponentFactory.component(Legend.class, (By)By.$((String)"#legend_1"));
        Language.assertThat((Object)legend.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)legend.language(), (Matcher)Matchers.is((Object)"es"));
    }

    @Test
    public void test_legend_coreAttributes() {
        Legend legend = (Legend)ComponentFactory.component(Legend.class, (By)By.$((String)"#legend_1"));
        Language.assertThat((Object)legend.id(), (Matcher)Matchers.is((Object)"legend_1"));
        Language.assertThat((Object)legend.classname(), (Matcher)Matchers.is((Object)"MyLEGENDClass"));
        Language.assertThat((Object)legend.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)legend.title(), (Matcher)Matchers.is((Object)"legendTitle"));
    }

    @Test
    public void test_legend_specifics_attributes() {
        Legend legend = (Legend)ComponentFactory.component(Legend.class, (By)By.$((String)"#legend_2"));
        Language.assertThat((Object)legend.accesskey(), (Matcher)Matchers.is((Object)"M"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Legend)ComponentFactory.component(Legend.class, (By)By.$((String)"#legend_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Legend with state : enabled:true, visible:true, title:legendTitle, content:Personal information"));
    }
}

