/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.A;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Link;
import org.testatoo.cartridge.html4.element.P;
import org.testatoo.cartridge.html4.element.Shape;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Duration;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;
import org.testatoo.core.input.Mouse;
import org.testatoo.core.matcher.Matchers;

public class LinkTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("Link.html");
    }

    @Test
    public void can_find_a_by_id() {
        ComponentFactory.component(A.class, (By)By.$((String)"#a_1"));
        try {
            ComponentFactory.component(A.class, (By)By.$((String)"#a_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#a_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_a() {
        try {
            ComponentFactory.component(A.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=radio is not a Link but a Radio"));
        }
    }

    @Test
    public void test_a_i18nAttributes() {
        A a = (A)ComponentFactory.component(A.class, (By)By.$((String)"#a_1"));
        Language.assertThat((Object)a.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)a.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_a_coreAttributes() {
        A a = (A)ComponentFactory.component(A.class, (By)By.$((String)"#a_1"));
        Language.assertThat((Object)a.id(), (Matcher)org.hamcrest.Matchers.is((Object)"a_1"));
        Language.assertThat((Object)a.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myAClass"));
        Language.assertThat((Object)a.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)a.title(), (Matcher)org.hamcrest.Matchers.is((Object)"aTitle"));
    }

    @Test
    public void test_a_specifics_attributes() {
        A a = (A)ComponentFactory.component(A.class, (By)By.$((String)"#a_1"));
        Language.assertThat((Object)a.type(), (Matcher)org.hamcrest.Matchers.is((Object)"text/html"));
        Language.assertThat((Object)a.name(), (Matcher)org.hamcrest.Matchers.is((Object)"aName"));
        Language.assertThat((Object)a.charset(), (Matcher)org.hamcrest.Matchers.is((Object)"utf-8"));
        Language.assertThat((Object)a.href(), (Matcher)org.hamcrest.Matchers.is((Object)"Exit.html"));
        Language.assertThat((Object)a.hreflang(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
        Language.assertThat((Object)a.rel(), (Matcher)org.hamcrest.Matchers.is((Object)"foo"));
        Language.assertThat((Object)a.rev(), (Matcher)org.hamcrest.Matchers.is((Object)"bar"));
        Language.assertThat((Object)a.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)"C"));
        Language.assertThat((Object)a.shape(), (Matcher)org.hamcrest.Matchers.is((Object)Shape.rect));
        Language.assertThat((Object)a.coords(), (Matcher)org.hamcrest.Matchers.is((Object)"rect:10,10,10,10"));
        Language.assertThat((Object)a.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)1));
    }

    @Test
    public void click_on_A_change_page() {
        A a_link = (A)ComponentFactory.component(A.class, (By)By.$((String)"#a_1"));
        Language.assertThat((Object)ComponentFactory.page().title(), (Matcher)org.hamcrest.Matchers.is((Object)"Link tests"));
        Mouse.clickOn((Component)a_link);
        Language.waitUntil((Object)ComponentFactory.page(), (Matcher)Matchers.has((Matcher)Matchers.title((String)"Exit page")));
    }

    @Test
    public void can_click_on_link() {
        ComponentFactory.page().open("Link.html");
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)Matchers.has((Matcher)Matchers.title((String)"Link tests")));
        Mouse.clickOn((Component)ComponentFactory.component(A.class, (By)By.$((String)"#a_1")));
        Language.waitUntil((Object)ComponentFactory.page(), (Matcher)Matchers.has((Matcher)Matchers.title((String)"Exit page")));
        ComponentFactory.page().open("Link.html");
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)Matchers.has((Matcher)Matchers.title((String)"Link tests")));
        Mouse.clickOn((Component)ComponentFactory.component(A.class, (By)By.$((String)"#jsLink")));
        Language.waitUntil((Object)ComponentFactory.page(), (Matcher)Matchers.has((Matcher)Matchers.title((String)"Exit page")));
        ComponentFactory.page().open("Link.html");
        Language.assertThat((Object)ComponentFactory.component(P.class, (By)By.$((String)"#message")), (Matcher)Matchers.has((Matcher)Matchers.text((String)"")));
        Mouse.clickOn((Component)ComponentFactory.component(A.class, (By)By.$((String)"#jsHookedLink")));
        Language.waitUntil((Object)ComponentFactory.component(P.class, (By)By.$((String)"#message")), (Matcher)Matchers.has((Matcher)Matchers.text((String)"Success")), (Duration)Language.max((long)2L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Test
    public void testA_toString() {
        Language.assertThat((Object)((A)ComponentFactory.component(A.class, (By)By.$((String)"#a_1"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.A with state : enabled:true, visible:true, text:Link 1 - a type, reference:Exit.html"));
    }

    @Test
    public void can_find_link_by_id() {
        ComponentFactory.component(Link.class, (By)By.$((String)"#link_1"));
        try {
            ComponentFactory.component(A.class, (By)By.$((String)"#link_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#link_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_link() {
        try {
            ComponentFactory.component(Link.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=radio is not a Link but a Radio"));
        }
    }

    @Test
    public void test_link_i18nAttributes() {
        Link link = (Link)ComponentFactory.component(Link.class, (By)By.$((String)"#link_1"));
        Language.assertThat((Object)link.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)link.language(), (Matcher)org.hamcrest.Matchers.is((Object)"en"));
    }

    @Test
    public void test_link_coreAttributes() {
        Link link = (Link)ComponentFactory.component(Link.class, (By)By.$((String)"#link_1"));
        Language.assertThat((Object)link.id(), (Matcher)org.hamcrest.Matchers.is((Object)"link_1"));
        Language.assertThat((Object)link.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myLINKClass"));
        Language.assertThat((Object)link.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:orange"));
        Language.assertThat((Object)link.title(), (Matcher)org.hamcrest.Matchers.is((Object)"linkTitle"));
    }

    @Test
    public void test_link_specifics_attributes() {
        Link link = (Link)ComponentFactory.component(Link.class, (By)By.$((String)"#link_1"));
        Language.assertThat((Object)link.type(), (Matcher)org.hamcrest.Matchers.is((Object)"text/html"));
        Language.assertThat((Object)link.charset(), (Matcher)org.hamcrest.Matchers.is((Object)"utf-8"));
        Language.assertThat((Object)link.href(), (Matcher)org.hamcrest.Matchers.is((Object)"Exit.html"));
        Language.assertThat((Object)link.hreflang(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
        Language.assertThat((Object)link.rel(), (Matcher)org.hamcrest.Matchers.is((Object)"next, index"));
        Language.assertThat((Object)link.rev(), (Matcher)org.hamcrest.Matchers.is((Object)"prev, chapter"));
    }

    @Test
    public void test_is_enabled() {
        Link link = (Link)ComponentFactory.component(Link.class, (By)By.$((String)"#link_1"));
        Language.assertThat((Object)link.isVisible(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void testLink_toString() {
        Link link = (Link)ComponentFactory.component(Link.class, (By)By.$((String)"#link_1"));
        Language.assertThat((Object)link.toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Link with state : enabled:true, visible:false, text:, reference:Exit.html"));
    }
}

