/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Object;
import org.testatoo.cartridge.html4.element.Param;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.Selection;

public class ObjectTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Object.html");
    }

    @Test
    public void can_find_object_by_id() {
        ComponentFactory.component(Object.class, (By)By.$((String)"#object_1"));
        try {
            ComponentFactory.component(Object.class, (By)By.$((String)"#object_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((java.lang.Object)e.getMessage(), (Matcher)Matchers.is((java.lang.Object)"Cannot find component defined by jQueryExpression=$('#object_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_object() {
        try {
            ComponentFactory.component(Object.class, (By)By.$((String)"#var_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((java.lang.Object)e.getMessage(), (Matcher)Matchers.is((java.lang.Object)"The component with id=var_ess1 is not a Object but a Var"));
        }
    }

    @Test
    public void test_object_coreAttributes() {
        Object object_1 = (Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_1"));
        Language.assertThat((java.lang.Object)object_1.id(), (Matcher)Matchers.is((java.lang.Object)"object_1"));
        Language.assertThat((java.lang.Object)object_1.classname(), (Matcher)Matchers.is((java.lang.Object)"MyOBJECTClass"));
        Language.assertThat((java.lang.Object)object_1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((java.lang.Object)object_1.title(), (Matcher)Matchers.is((java.lang.Object)"objectTitle1"));
    }

    @Test
    public void test_object_i18nAttributes() {
        Object object_1 = (Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_1"));
        Language.assertThat((java.lang.Object)object_1.direction(), (Matcher)Matchers.is((java.lang.Object)Direction.lefttoright));
        Language.assertThat((java.lang.Object)object_1.language(), (Matcher)Matchers.is((java.lang.Object)"es"));
    }

    @Test
    public void test_object_specifics_attributes() {
        Object object_1 = (Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_1"));
        Object object_2 = (Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_2"));
        Object object_4 = (Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_4"));
        Language.assertThat((java.lang.Object)object_1.data(), (Matcher)Matchers.containsString((String)"images/forward.png"));
        Language.assertThat((java.lang.Object)object_1.type(), (Matcher)Matchers.is((java.lang.Object)"image/jpg"));
        Language.assertThat((java.lang.Object)object_2.classid(), (Matcher)Matchers.is((java.lang.Object)"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"));
        Language.assertThat((java.lang.Object)object_2.codebase(), (Matcher)Matchers.is((java.lang.Object)"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4,0,0,0"));
        Language.assertThat((java.lang.Object)object_2.name(), (Matcher)Matchers.is((java.lang.Object)"object_name2"));
        Language.assertThat((java.lang.Object)object_4.codetype(), (Matcher)Matchers.is((java.lang.Object)"application/octet-stream"));
    }

    @Test
    public void can_obtain_params_associated() {
        Object object_1 = (Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_2"));
        Selection params = object_1.params();
        Language.assertThat((java.lang.Object)params.size(), (Matcher)Matchers.is((java.lang.Object)3));
        Language.assertThat((java.lang.Object)((Param)params.get(0)).name(), (Matcher)Matchers.is((java.lang.Object)"movie"));
        Language.assertThat((java.lang.Object)((Param)params.get(1)).name(), (Matcher)Matchers.is((java.lang.Object)"quality"));
        Language.assertThat((java.lang.Object)((Param)params.get(2)).name(), (Matcher)Matchers.is((java.lang.Object)"bgcolor"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((java.lang.Object)((Object)ComponentFactory.component(Object.class, (By)By.$((String)"#object_2"))).toString(), (Matcher)Matchers.is((java.lang.Object)"class org.testatoo.cartridge.html4.element.Object with state : enabled:true, visible:true"));
    }
}

