/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Param;
import org.testatoo.cartridge.html4.element.ValueType;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class ParamTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Object.html");
    }

    @Test
    public void can_find_param_by_id() {
        ComponentFactory.component(Param.class, (By)By.$((String)"#param_1"));
        try {
            ComponentFactory.component(Param.class, (By)By.$((String)"#param_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#param_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_param() {
        try {
            ComponentFactory.component(Param.class, (By)By.$((String)"#var_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=var_ess1 is not a Param but a Var"));
        }
    }

    @Test
    public void test_param_specifics_attributes() {
        Param param_1 = (Param)ComponentFactory.component(Param.class, (By)By.$((String)"#param_1"));
        Param param_2 = (Param)ComponentFactory.component(Param.class, (By)By.$((String)"#param_2"));
        Param param_3 = (Param)ComponentFactory.component(Param.class, (By)By.$((String)"#param_3"));
        Language.assertThat((Object)param_1.valuetype(), (Matcher)Matchers.is((Object)ValueType.data));
        Language.assertThat((Object)param_1.name(), (Matcher)Matchers.is((Object)"movie"));
        Language.assertThat((Object)param_1.type(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)param_2.value(), (Matcher)Matchers.is((Object)"high"));
        Language.assertThat((Object)param_3.name(), (Matcher)Matchers.is((Object)"IMAGE1"));
        Language.assertThat((Object)param_3.value(), (Matcher)Matchers.is((Object)"flash/camera.swf"));
        Language.assertThat((Object)param_3.valuetype(), (Matcher)Matchers.is((Object)ValueType.ref));
        Language.assertThat((Object)param_3.type(), (Matcher)Matchers.is((Object)"image/gif"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Param)ComponentFactory.component(Param.class, (By)By.$((String)"#param_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Param with state : enabled:true, visible:false, name:movie, value:images/dropdown.swf"));
    }
}

