/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Span;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class SpanTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Span.html");
    }

    @Test
    public void can_find_span_by_id() {
        ComponentFactory.component(Span.class, (By)By.$((String)"#spanId"));
        try {
            ComponentFactory.component(Span.class, (By)By.$((String)"#otherElement"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#otherElement')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_span() {
        try {
            ComponentFactory.component(Span.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=radio is not a Span but a Radio"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        Span span = (Span)ComponentFactory.component(Span.class, (By)By.$((String)"#spanId"));
        Language.assertThat((Object)span.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)span.language(), (Matcher)org.hamcrest.Matchers.is((Object)"en"));
    }

    @Test
    public void test_coreAttributes() {
        Span span = (Span)ComponentFactory.component(Span.class, (By)By.$((String)"#spanId"));
        Language.assertThat((Object)span.id(), (Matcher)org.hamcrest.Matchers.is((Object)"spanId"));
        Language.assertThat((Object)span.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)span.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"background-color:red"));
        Language.assertThat((Object)span.title(), (Matcher)org.hamcrest.Matchers.is((Object)"spanTitle"));
    }

    @Test
    public void test_span_text() {
        Span span = (Span)ComponentFactory.component(Span.class, (By)By.$((String)"#myId"));
        Language.assertThat((Object)span, (Matcher)Matchers.has((Matcher)Matchers.text((String)"A simple text")));
    }

    @Test
    public void test_toString() {
        Span span = (Span)ComponentFactory.component(Span.class, (By)By.$((String)"#spanId"));
        Language.assertThat((Object)span.toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Span with state : enabled:true, visible:true, title:spanTitle"));
    }
}

