/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Image;

public class ImageTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Img.html");
    }

    @Test
    public void can_find_image_by_id() {
        ComponentFactory.component(Image.class, (String)"image_1");
        try {
            ComponentFactory.component(Image.class, (String)"image_0");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=image_0"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_image() {
        try {
            ComponentFactory.component(Image.class, (String)"div_1");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=div_1 is not a Image but a Panel"));
        }
    }

    @Test
    public void can_find_image_source() {
        Language.assertThat((Object)((Image)ComponentFactory.component(Image.class, (String)"image_1")).source(), (Matcher)Matchers.containsString((String)"images/Montpellier.jpg"));
    }

    @Test
    public void test_image_toString() {
        Language.assertThat((Object)((Image)ComponentFactory.component(Image.class, (String)"image_1")).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.core.component.Image with state : enabled:true, visible:true, source:images/Montpellier.jpg"));
    }
}

