/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Link;

public class LinkTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Link.html");
    }

    @Test
    public void can_find_link_by_id() {
        ComponentFactory.component(Link.class, (String)"a_1");
        try {
            ComponentFactory.component(Link.class, (String)"a_2");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=a_2"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_link() {
        try {
            ComponentFactory.component(Link.class, (String)"radio");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a Link but a Radio"));
        }
    }

    @Test
    public void can_obtain_content() {
        Language.assertThat((Object)((Link)ComponentFactory.component(Link.class, (String)"a_1")).text(), (Matcher)Matchers.is((Object)"Link 1 - a type"));
    }

    @Test
    public void can_obtain_reference() {
        Language.assertThat((Object)((Link)ComponentFactory.component(Link.class, (String)"a_1")).reference(), (Matcher)Matchers.containsString((String)"Exit.html"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Link)ComponentFactory.component(Link.class, (String)"a_1")).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.core.component.Link with state : enabled:true, visible:true, text:Link 1 - a type, reference:Exit.html"));
    }
}

