/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.Selection;
import org.testatoo.core.component.ListBox;
import org.testatoo.core.component.TextField;
import org.testatoo.core.matcher.Matchers;

public class ListBoxTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("Select.html");
    }

    @Test
    public void can_find_listbox_by_id() {
        ComponentFactory.component(ListBox.class, (String)"cities");
        try {
            ComponentFactory.component(ListBox.class, (String)"otherListbox");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by id=otherListbox"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_listBox() {
        try {
            ComponentFactory.component(ListBox.class, (String)"elements");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=elements is not a ListBox but a DropDown"));
        }
    }

    @Test
    public void test_list_values() {
        Selection values = ((ListBox)ComponentFactory.component(ListBox.class, (String)"cities")).values();
        Language.assertThat((Object)values.containsAll(Arrays.asList("Montreal", "Quebec", "Montpellier", "New York", "Casablanca", "Munich")), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void can_obtain_selected_values() {
        Language.assertThat((Object)((ListBox)ComponentFactory.component(ListBox.class, (String)"cities")).selectedValues().containsAll(Arrays.asList("New York", "Munich")), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void test_can_select_multiple_value() {
        ListBox cities = (ListBox)ComponentFactory.component(ListBox.class, (String)"cities");
        Language.assertThat((Object)((TextField)ComponentFactory.component(TextField.class, (String)"onChangeTest")).value(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)cities.selectedValues().containsAll(Arrays.asList("New York", "Munich")), (Matcher)org.hamcrest.Matchers.is((Object)true));
        cities.select("Montpellier");
        Language.assertThat((Object)cities.selectedValues().containsAll(Arrays.asList("New York", "Munich", "Montpellier")), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Language.assertThat((Object)((TextField)ComponentFactory.component(TextField.class, (String)"onChangeTest")).value(), (Matcher)org.hamcrest.Matchers.is((Object)"OnChange Event Fired"));
    }

    @Test
    public void can_unselect_value() {
        ListBox cities = (ListBox)ComponentFactory.component(ListBox.class, (String)"cities");
        Language.assertThat((Object)cities.selectedValues().containsAll(Arrays.asList("New York", "Munich")), (Matcher)org.hamcrest.Matchers.is((Object)true));
        cities.unSelect("Munich");
        Language.assertThat((Object)cities.selectedValues().containsAll(Arrays.asList("New York")), (Matcher)org.hamcrest.Matchers.is((Object)true));
        cities.unSelect("New York");
        Language.assertThat((Object)cities.selectedValues().isEmpty(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(ListBox.class, (String)"cities"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Cities list")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((ListBox)ComponentFactory.component(ListBox.class, (String)"cities")).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.component.ListBox with state : enabled:true, visible:true, values:[Montreal, Quebec, Montpellier, New York, Casablanca, Munich], selectedValues:[New York, Munich], label:Cities list"));
    }
}

