/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.Radio;
import org.testatoo.core.input.Mouse;
import org.testatoo.core.matcher.Matchers;

public class RadioTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Radio.html");
    }

    @Test
    public void can_find_radio_by_id() {
        ComponentFactory.component(Radio.class, (String)"male");
        try {
            ComponentFactory.component(Radio.class, (String)"otherRadio");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by id=otherRadio"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_radio() {
        try {
            ComponentFactory.component(Radio.class, (String)"radiobuttonError");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=radiobuttonError is not a Radio but a TextField"));
        }
    }

    @Test
    public void can_check() {
        Radio male = (Radio)ComponentFactory.component(Radio.class, (String)"male");
        Language.assertThat((Object)male, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        Mouse.clickOn((Component)male);
        Language.assertThat((Object)male, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Radio female = (Radio)ComponentFactory.component(Radio.class, (String)"female");
        Language.assertThat((Object)female, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        female.check();
        Language.assertThat((Object)female, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Language.assertThat((Object)male, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Radio yes = (Radio)ComponentFactory.component(Radio.class, (String)"yes");
        Radio no = (Radio)ComponentFactory.component(Radio.class, (String)"no");
        Language.assertThat((Object)yes, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        Language.clickOn((Component)yes);
        Language.assertThat((Object)yes, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Language.assertThat((Object)no, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
        no.check();
        Language.assertThat((Object)no, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.checked()));
        Language.assertThat((Object)yes, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.checked())));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(Radio.class, (String)"male"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Male")));
        Language.assertThat((Object)ComponentFactory.component(Radio.class, (String)"female"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Female")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Radio)ComponentFactory.component(Radio.class, (String)"radio")).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.core.component.Radio with state : enabled:true, visible:true, label:Radio label, checked:false"));
    }
}

