/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.input;

import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.Image;
import org.testatoo.core.component.Panel;
import org.testatoo.core.component.TextField;
import org.testatoo.core.input.Mouse;
import org.testatoo.core.matcher.Matchers;

public class MouseTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Mouse.html");
    }

    @Test
    public void can_test_focus_on_component() {
        TextField component = (TextField)ComponentFactory.component(TextField.class, (String)"textFocus");
        Language.assertThat((Object)component.hasFocus(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Mouse.clickOn((Component)component);
        Language.assertThat((Object)component.hasFocus(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void can_click_on_component() {
        TextField textField = (TextField)ComponentFactory.component(TextField.class, (String)"element_1");
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 1"));
        Mouse.clickOn((Component)textField);
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 1 clicked"));
    }

    @Test
    public void can_doubleClick_on_component() {
        TextField textField = (TextField)ComponentFactory.component(TextField.class, (String)"element_2");
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 2"));
        Mouse.doubleClickOn((Component)textField);
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 2 double clicked"));
    }

    @Test
    public void can_rightclick_on_component() {
        TextField textField = (TextField)ComponentFactory.component(TextField.class, (String)"element_5");
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 5"));
        Mouse.rightClickOn((Component)textField);
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 5 right click"));
    }

    @Test
    public void can_mouseOver_component() {
        TextField textField = (TextField)ComponentFactory.component(TextField.class, (String)"element_3");
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 3"));
        Mouse.mouseOverOn((Component)textField);
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 3 mouse over"));
    }

    @Test
    public void can_mouseOut_component() {
        TextField textField = (TextField)ComponentFactory.component(TextField.class, (String)"element_4");
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 4"));
        Mouse.mouseOutOf((Component)textField);
        Language.assertThat((Object)textField.value(), (Matcher)org.hamcrest.Matchers.is((Object)"Element 4 mouse out"));
    }

    @Test
    public void test_component_drag_and_drop() throws Exception {
        Language.assertThat((Object)((Image)ComponentFactory.component(Image.class, (String)"image")).isVisible(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Panel draggablePanel = (Panel)ComponentFactory.component(Panel.class, (String)"draggable");
        Panel droppablePanel = (Panel)ComponentFactory.component(Panel.class, (String)"droppable");
        Mouse.drag((Component)draggablePanel).on((Component)droppablePanel);
        Language.assertThat((Object)ComponentFactory.component(Image.class, (String)"image"), (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.visible()));
    }
}

