/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import java.util.ArrayList;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.cartridge.html4.element.Attribute;
import org.testatoo.cartridge.html4.element.AttributeSupport;
import org.testatoo.cartridge.html4.element.CoreAttributeSupport;
import org.testatoo.cartridge.html4.element.Coreattrs;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.I18n;
import org.testatoo.cartridge.html4.element.I18nAttributeSupport;
import org.testatoo.cartridge.html4.element.Option;
import org.testatoo.cartridge.html4.element.OptionGroup;
import org.testatoo.core.ComponentException;
import org.testatoo.core.Evaluator;
import org.testatoo.core.ListSelection;
import org.testatoo.core.Selection;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.ListModel;
import org.testatoo.core.nature.LabelSupport;
import org.testatoo.core.nature.MultiSelectable;

public final class Select
extends ListModel
implements MultiSelectable,
LabelSupport,
Coreattrs,
I18n {
    private HtmlEvaluator evaluator;
    private CoreAttributeSupport coreAttributeSupport;
    private I18nAttributeSupport i18nAttributeSupport;
    private AttributeSupport attributeSupport;

    public Select(HtmlEvaluator evaluator, String id) {
        super((Evaluator)evaluator, id);
        this.evaluator = evaluator;
        this.coreAttributeSupport = new CoreAttributeSupport(evaluator);
        this.i18nAttributeSupport = new I18nAttributeSupport(evaluator);
        this.attributeSupport = new AttributeSupport(evaluator);
    }

    public String label() {
        return this.evaluator.label(this);
    }

    @Override
    public String classname() {
        return this.coreAttributeSupport.classname((Component)this);
    }

    @Override
    public String style() {
        return this.coreAttributeSupport.style((Component)this);
    }

    @Override
    public String title() {
        return this.coreAttributeSupport.title((Component)this);
    }

    @Override
    public String language() {
        return this.i18nAttributeSupport.language((Component)this);
    }

    @Override
    public Direction direction() {
        return this.i18nAttributeSupport.direction((Component)this);
    }

    public Selection<String> selectedValues() {
        return this.lstSelectedValues();
    }

    protected Selection<String> listSelectedValues() {
        return this.lstSelectedValues();
    }

    public void select(String value) {
        this.evaluator.select(value, this);
    }

    public void unselect(String value) {
        if (!this.isMultiple()) {
            throw new ComponentException("Unable to unselect a value : Select is no a multi select.");
        }
        this.evaluator.unselect(value, this);
    }

    public Selection<String> values() {
        ArrayList<String> optionsValue = new ArrayList<String>();
        for (Option option : this.options()) {
            optionsValue.add(option.content());
        }
        return ListSelection.from(optionsValue);
    }

    public void unselectAll() {
        if (!this.isMultiple()) {
            throw new ComponentException("Unable to unselect all values : Select is no a multi select.");
        }
        this.evaluator.unselectAll(this);
    }

    public boolean isMultiple() {
        return Boolean.valueOf(this.evaluator.attribute(this.id(), Attribute.multiple));
    }

    public Selection<Option> options() {
        return this.evaluator.options(this);
    }

    public Selection<OptionGroup> optionGroups() {
        return this.evaluator.optionGroups(this);
    }

    public Selection<Option> selectedOptions() {
        return this.evaluator.selectedOptions(this);
    }

    public int visibleRows() {
        return this.size();
    }

    public String name() {
        return this.attributeSupport.name((Component)this);
    }

    public int tabindex() {
        return this.attributeSupport.tabindex((Component)this);
    }

    public int size() {
        String size = this.evaluator.attribute(this.id(), Attribute.size);
        if (size.isEmpty()) {
            return 0;
        }
        return Integer.valueOf(size);
    }

    public String toString() {
        return super.toString() + ", visibleRows:" + this.visibleRows();
    }

    private Selection<String> lstSelectedValues() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (Option option : this.selectedOptions()) {
            selectedValues.add(option.content());
        }
        return ListSelection.from(selectedValues);
    }
}

