/*!
 * jQuery JavaScript Library v1.5
 * http://jquery.com/
 *
 * Copyright 2011, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 * Copyright 2011, The Dojo Foundation
 * Released under the MIT, BSD, and GPL Licenses.
 *
 * Date: Mon Jan 31 08:31:29 2011 -0500
 */
(function(window,undefined){var document=window.document;var tQuery=(function(){var tQuery=function(selector,context){return new tQuery.fn.init(selector,context,roottQuery);},_tQuery=window.tQuery,roottQuery,quickExpr=/^(?:[^<]*(<[\w\W]+>)[^>]*$|#([\w\-]+)$)/,rnotwhite=/\S/,trimLeft=/^\s+/,trimRight=/\s+$/,rdigit=/\d/,rsingleTag=/^<(\w+)\s*\/?>(?:<\/\1>)?$/,rvalidchars=/^[\],:{}\s]*$/,rvalidescape=/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,rvalidtokens=/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,rvalidbraces=/(?:^|:|,)(?:\s*\[)+/g,rwebkit=/(webkit)[ \/]([\w.]+)/,ropera=/(opera)(?:.*version)?[ \/]([\w.]+)/,rmsie=/(msie) ([\w.]+)/,rmozilla=/(mozilla)(?:.*? rv:([\w.]+))?/,userAgent=navigator.userAgent,browserMatch,readyBound=false,readyList,promiseMethods="then done fail isResolved isRejected promise".split(" "),DOMContentLoaded,toString=Object.prototype.toString,hasOwn=Object.prototype.hasOwnProperty,push=Array.prototype.push,slice=Array.prototype.slice,trim=String.prototype.trim,indexOf=Array.prototype.indexOf,class2type={};tQuery.fn=tQuery.prototype={constructor:tQuery,init:function(selector,context,roottQuery){var match,elem,ret,doc;if(!selector){return this;}if(selector.nodeType){this.context=this[0]=selector;this.length=1;return this;}if(selector==="body"&&!context&&document.body){this.context=document;this[0]=document.body;this.selector="body";this.length=1;return this;}if(typeof selector==="string"){match=quickExpr.exec(selector);if(match&&(match[1]||!context)){if(match[1]){context=context instanceof tQuery?context[0]:context;doc=(context?context.ownerDocument||context:document);ret=rsingleTag.exec(selector);if(ret){if(tQuery.isPlainObject(context)){selector=[document.createElement(ret[1])];tQuery.fn.attr.call(selector,context,true);}else{selector=[doc.createElement(ret[1])];}}else{ret=tQuery.buildFragment([match[1]],[doc]);selector=(ret.cacheable?tQuery.clone(ret.fragment):ret.fragment).childNodes;}return tQuery.merge(this,selector);}else{elem=document.getElementById(match[2]);if(elem&&elem.parentNode){if(elem.id!==match[2]){return roottQuery.find(selector);}this.length=1;this[0]=elem;}this.context=document;this.selector=selector;return this;}}else{if(!context||context.tQuery){return(context||roottQuery).find(selector);}else{return this.constructor(context).find(selector);}}}else{if(tQuery.isFunction(selector)){return roottQuery.ready(selector);}}if(selector.selector!==undefined){this.selector=selector.selector;this.context=selector.context;}return tQuery.makeArray(selector,this);},selector:"",tQuery:"1.5",length:0,size:function(){return this.length;},toArray:function(){return slice.call(this,0);},get:function(num){return num==null?this.toArray():(num<0?this[this.length+num]:this[num]);},pushStack:function(elems,name,selector){var ret=this.constructor();if(tQuery.isArray(elems)){push.apply(ret,elems);}else{tQuery.merge(ret,elems);}ret.prevObject=this;ret.context=this.context;if(name==="find"){ret.selector=this.selector+(this.selector?" ":"")+selector;}else{if(name){ret.selector=this.selector+"."+name+"("+selector+")";}}return ret;},each:function(callback,args){return tQuery.each(this,callback,args);},ready:function(fn){tQuery.bindReady();readyList.done(fn);return this;},eq:function(i){return i===-1?this.slice(i):this.slice(i,+i+1);},first:function(){return this.eq(0);},last:function(){return this.eq(-1);},slice:function(){return this.pushStack(slice.apply(this,arguments),"slice",slice.call(arguments).join(","));},map:function(callback){return this.pushStack(tQuery.map(this,function(elem,i){return callback.call(elem,i,elem);}));},end:function(){return this.prevObject||this.constructor(null);},push:push,sort:[].sort,splice:[].splice};tQuery.fn.init.prototype=tQuery.fn;tQuery.extend=tQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=false;if(typeof target==="boolean"){deep=target;target=arguments[1]||{};i=2;}if(typeof target!=="object"&&!tQuery.isFunction(target)){target={};}if(length===i){target=this;--i;}for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){src=target[name];copy=options[name];if(target===copy){continue;}if(deep&&copy&&(tQuery.isPlainObject(copy)||(copyIsArray=tQuery.isArray(copy)))){if(copyIsArray){copyIsArray=false;clone=src&&tQuery.isArray(src)?src:[];}else{clone=src&&tQuery.isPlainObject(src)?src:{};}target[name]=tQuery.extend(deep,clone,copy);}else{if(copy!==undefined){target[name]=copy;}}}}}return target;};tQuery.extend({noConflict:function(deep){window.$=_$;if(deep){window.tQuery=_tQuery;}return tQuery;},isReady:false,readyWait:1,ready:function(wait){if(wait===true){tQuery.readyWait--;}if(!tQuery.readyWait||(wait!==true&&!tQuery.isReady)){if(!document.body){return setTimeout(tQuery.ready,1);}tQuery.isReady=true;if(wait!==true&&--tQuery.readyWait>0){return;}readyList.resolveWith(document,[tQuery]);if(tQuery.fn.trigger){tQuery(document).trigger("ready").unbind("ready");}}},bindReady:function(){if(readyBound){return;}readyBound=true;if(document.readyState==="complete"){return setTimeout(tQuery.ready,1);}if(document.addEventListener){document.addEventListener("DOMContentLoaded",DOMContentLoaded,false);window.addEventListener("load",tQuery.ready,false);}else{if(document.attachEvent){document.attachEvent("onreadystatechange",DOMContentLoaded);window.attachEvent("onload",tQuery.ready);var toplevel=false;try{toplevel=window.frameElement==null;}catch(e){}if(document.documentElement.doScroll&&toplevel){doScrollCheck();}}}},isFunction:function(obj){return tQuery.type(obj)==="function";},isArray:Array.isArray||function(obj){return tQuery.type(obj)==="array";},isWindow:function(obj){return obj&&typeof obj==="object"&&"setInterval" in obj;},isNaN:function(obj){return obj==null||!rdigit.test(obj)||isNaN(obj);},type:function(obj){return obj==null?String(obj):class2type[toString.call(obj)]||"object";},isPlainObject:function(obj){if(!obj||tQuery.type(obj)!=="object"||obj.nodeType||tQuery.isWindow(obj)){return false;}if(obj.constructor&&!hasOwn.call(obj,"constructor")&&!hasOwn.call(obj.constructor.prototype,"isPrototypeOf")){return false;}var key;for(key in obj){}return key===undefined||hasOwn.call(obj,key);},isEmptyObject:function(obj){for(var name in obj){return false;}return true;},error:function(msg){throw msg;},parseJSON:function(data){if(typeof data!=="string"||!data){return null;}data=tQuery.trim(data);if(rvalidchars.test(data.replace(rvalidescape,"@").replace(rvalidtokens,"]").replace(rvalidbraces,""))){return window.JSON&&window.JSON.parse?window.JSON.parse(data):(new Function("return "+data))();}else{tQuery.error("Invalid JSON: "+data);}},parseXML:function(data,xml,tmp){if(window.DOMParser){tmp=new DOMParser();xml=tmp.parseFromString(data,"text/xml");}else{xml=new ActiveXObject("Microsoft.XMLDOM");xml.async="false";xml.loadXML(data);}tmp=xml.documentElement;if(!tmp||!tmp.nodeName||tmp.nodeName==="parsererror"){tQuery.error("Invalid XML: "+data);}return xml;},noop:function(){},globalEval:function(data){if(data&&rnotwhite.test(data)){var head=document.getElementsByTagName("head")[0]||document.documentElement,script=document.createElement("script");script.type="text/javascript";if(tQuery.support.scriptEval()){script.appendChild(document.createTextNode(data));}else{script.text=data;}head.insertBefore(script,head.firstChild);head.removeChild(script);}},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()===name.toUpperCase();},each:function(object,callback,args){var name,i=0,length=object.length,isObj=length===undefined||tQuery.isFunction(object);if(args){if(isObj){for(name in object){if(callback.apply(object[name],args)===false){break;}}}else{for(;i<length;){if(callback.apply(object[i++],args)===false){break;}}}}else{if(isObj){for(name in object){if(callback.call(object[name],name,object[name])===false){break;}}}else{for(var value=object[0];i<length&&callback.call(value,i,value)!==false;value=object[++i]){}}}return object;},trim:trim?function(text){return text==null?"":trim.call(text);}:function(text){return text==null?"":text.toString().replace(trimLeft,"").replace(trimRight,"");},makeArray:function(array,results){var ret=results||[];if(array!=null){var type=tQuery.type(array);if(array.length==null||type==="string"||type==="function"||type==="regexp"||tQuery.isWindow(array)){push.call(ret,array);}else{tQuery.merge(ret,array);}}return ret;},inArray:function(elem,array){if(array.indexOf){return array.indexOf(elem);}for(var i=0,length=array.length;i<length;i++){if(array[i]===elem){return i;}}return -1;},merge:function(first,second){var i=first.length,j=0;if(typeof second.length==="number"){for(var l=second.length;j<l;j++){first[i++]=second[j];}}else{while(second[j]!==undefined){first[i++]=second[j++];}}first.length=i;return first;},grep:function(elems,callback,inv){var ret=[],retVal;inv=!!inv;for(var i=0,length=elems.length;i<length;i++){retVal=!!callback(elems[i],i);if(inv!==retVal){ret.push(elems[i]);}}return ret;},map:function(elems,callback,arg){var ret=[],value;for(var i=0,length=elems.length;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret[ret.length]=value;}}return ret.concat.apply([],ret);},guid:1,proxy:function(fn,proxy,thisObject){if(arguments.length===2){if(typeof proxy==="string"){thisObject=fn;fn=thisObject[proxy];proxy=undefined;}else{if(proxy&&!tQuery.isFunction(proxy)){thisObject=proxy;proxy=undefined;}}}if(!proxy&&fn){proxy=function(){return fn.apply(thisObject||this,arguments);};}if(fn){proxy.guid=fn.guid=fn.guid||proxy.guid||tQuery.guid++;}return proxy;},access:function(elems,key,value,exec,fn,pass){var length=elems.length;if(typeof key==="object"){for(var k in key){tQuery.access(elems,k,key[k],exec,fn,value);}return elems;}if(value!==undefined){exec=!pass&&exec&&tQuery.isFunction(value);for(var i=0;i<length;i++){fn(elems[i],key,exec?value.call(elems[i],i,fn(elems[i],key)):value,pass);}return elems;}return length?fn(elems[0],key):undefined;},now:function(){return(new Date()).getTime();},_Deferred:function(){var callbacks=[],fired,firing,cancelled,deferred={done:function(){if(!cancelled){var args=arguments,i,length,elem,type,_fired;if(fired){_fired=fired;fired=0;}for(i=0,length=args.length;i<length;i++){elem=args[i];type=tQuery.type(elem);if(type==="array"){deferred.done.apply(deferred,elem);}else{if(type==="function"){callbacks.push(elem);}}}if(_fired){deferred.resolveWith(_fired[0],_fired[1]);}}return this;},resolveWith:function(context,args){if(!cancelled&&!fired&&!firing){firing=1;try{while(callbacks[0]){callbacks.shift().apply(context,args);}}finally{fired=[context,args];firing=0;}}return this;},resolve:function(){deferred.resolveWith(tQuery.isFunction(this.promise)?this.promise():this,arguments);return this;},isResolved:function(){return !!(firing||fired);},cancel:function(){cancelled=1;callbacks=[];return this;}};return deferred;},Deferred:function(func){var deferred=tQuery._Deferred(),failDeferred=tQuery._Deferred(),promise;tQuery.extend(deferred,{then:function(doneCallbacks,failCallbacks){deferred.done(doneCallbacks).fail(failCallbacks);return this;},fail:failDeferred.done,rejectWith:failDeferred.resolveWith,reject:failDeferred.resolve,isRejected:failDeferred.isResolved,promise:function(obj,i){if(obj==null){if(promise){return promise;}promise=obj={};}i=promiseMethods.length;while(i--){obj[promiseMethods[i]]=deferred[promiseMethods[i]];}return obj;}});deferred.then(failDeferred.cancel,deferred.cancel);delete deferred.cancel;if(func){func.call(deferred,deferred);}return deferred;},when:function(object){var args=arguments,length=args.length,deferred=length<=1&&object&&tQuery.isFunction(object.promise)?object:tQuery.Deferred(),promise=deferred.promise(),resolveArray;if(length>1){resolveArray=new Array(length);tQuery.each(args,function(index,element){tQuery.when(element).then(function(value){resolveArray[index]=arguments.length>1?slice.call(arguments,0):value;if(!--length){deferred.resolveWith(promise,resolveArray);}},deferred.reject);});}else{if(deferred!==object){deferred.resolve(object);}}return promise;},uaMatch:function(ua){ua=ua.toLowerCase();var match=rwebkit.exec(ua)||ropera.exec(ua)||rmsie.exec(ua)||ua.indexOf("compatible")<0&&rmozilla.exec(ua)||[];return{browser:match[1]||"",version:match[2]||"0"};},sub:function(){function tQuerySubclass(selector,context){return new tQuerySubclass.fn.init(selector,context);}tQuery.extend(true,tQuerySubclass,this);tQuerySubclass.superclass=this;tQuerySubclass.fn=tQuerySubclass.prototype=this();tQuerySubclass.fn.constructor=tQuerySubclass;tQuerySubclass.subclass=this.subclass;tQuerySubclass.fn.init=function init(selector,context){if(context&&context instanceof tQuery&&!(context instanceof tQuerySubclass)){context=tQuerySubclass(context);}return tQuery.fn.init.call(this,selector,context,roottQuerySubclass);};tQuerySubclass.fn.init.prototype=tQuerySubclass.fn;var roottQuerySubclass=tQuerySubclass(document);return tQuerySubclass;},browser:{}});readyList=tQuery._Deferred();tQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "),function(i,name){class2type["[object "+name+"]"]=name.toLowerCase();});browserMatch=tQuery.uaMatch(userAgent);if(browserMatch.browser){tQuery.browser[browserMatch.browser]=true;tQuery.browser.version=browserMatch.version;}if(tQuery.browser.webkit){tQuery.browser.safari=true;}if(indexOf){tQuery.inArray=function(elem,array){return indexOf.call(array,elem);};}if(rnotwhite.test("\xA0")){trimLeft=/^[\s\xA0]+/;trimRight=/[\s\xA0]+$/;}roottQuery=tQuery(document);if(document.addEventListener){DOMContentLoaded=function(){document.removeEventListener("DOMContentLoaded",DOMContentLoaded,false);tQuery.ready();};}else{if(document.attachEvent){DOMContentLoaded=function(){if(document.readyState==="complete"){document.detachEvent("onreadystatechange",DOMContentLoaded);tQuery.ready();}};}}function doScrollCheck(){if(tQuery.isReady){return;}try{document.documentElement.doScroll("left");}catch(e){setTimeout(doScrollCheck,1);return;}tQuery.ready();}return(window.tQuery=window.$=tQuery);})();(function(){tQuery.support={};var div=document.createElement("div");div.style.display="none";div.innerHTML="   <link/><table></table><a href='/a' style='color:red;float:left;opacity:.55;'>a</a><input type='checkbox'/>";var all=div.getElementsByTagName("*"),a=div.getElementsByTagName("a")[0],select=document.createElement("select"),opt=select.appendChild(document.createElement("option"));if(!all||!all.length||!a){return;}tQuery.support={leadingWhitespace:div.firstChild.nodeType===3,tbody:!div.getElementsByTagName("tbody").length,htmlSerialize:!!div.getElementsByTagName("link").length,style:/red/.test(a.getAttribute("style")),hrefNormalized:a.getAttribute("href")==="/a",opacity:/^0.55$/.test(a.style.opacity),cssFloat:!!a.style.cssFloat,checkOn:div.getElementsByTagName("input")[0].value==="on",optSelected:opt.selected,deleteExpando:true,optDisabled:false,checkClone:false,_scriptEval:null,noCloneEvent:true,boxModel:null,inlineBlockNeedsLayout:false,shrinkWrapBlocks:false,reliableHiddenOffsets:true};select.disabled=true;tQuery.support.optDisabled=!opt.disabled;tQuery.support.scriptEval=function(){if(tQuery.support._scriptEval===null){var root=document.documentElement,script=document.createElement("script"),id="script"+tQuery.now();script.type="text/javascript";try{script.appendChild(document.createTextNode("window."+id+"=1;"));}catch(e){}root.insertBefore(script,root.firstChild);if(window[id]){tQuery.support._scriptEval=true;delete window[id];}else{tQuery.support._scriptEval=false;}root.removeChild(script);root=script=id=null;}return tQuery.support._scriptEval;};try{delete div.test;}catch(e){tQuery.support.deleteExpando=false;}if(div.attachEvent&&div.fireEvent){div.attachEvent("onclick",function click(){tQuery.support.noCloneEvent=false;div.detachEvent("onclick",click);});div.cloneNode(true).fireEvent("onclick");}div=document.createElement("div");div.innerHTML="<input type='radio' name='radiotest' checked='checked'/>";var fragment=document.createDocumentFragment();fragment.appendChild(div.firstChild);tQuery.support.checkClone=fragment.cloneNode(true).cloneNode(true).lastChild.checked;tQuery(function(){var div=document.createElement("div"),body=document.getElementsByTagName("body")[0];if(!body){return;}div.style.width=div.style.paddingLeft="1px";body.appendChild(div);tQuery.boxModel=tQuery.support.boxModel=div.offsetWidth===2;if("zoom" in div.style){div.style.display="inline";div.style.zoom=1;tQuery.support.inlineBlockNeedsLayout=div.offsetWidth===2;div.style.display="";div.innerHTML="<div style='width:4px;'></div>";tQuery.support.shrinkWrapBlocks=div.offsetWidth!==2;}div.innerHTML="<table><tr><td style='padding:0;border:0;display:none'></td><td>t</td></tr></table>";var tds=div.getElementsByTagName("td");tQuery.support.reliableHiddenOffsets=tds[0].offsetHeight===0;tds[0].style.display="";tds[1].style.display="none";tQuery.support.reliableHiddenOffsets=tQuery.support.reliableHiddenOffsets&&tds[0].offsetHeight===0;div.innerHTML="";body.removeChild(div).style.display="none";div=tds=null;});var eventSupported=function(eventName){var el=document.createElement("div");eventName="on"+eventName;if(!el.attachEvent){return true;}var isSupported=(eventName in el);if(!isSupported){el.setAttribute(eventName,"return;");isSupported=typeof el[eventName]==="function";}el=null;return isSupported;};tQuery.support.submitBubbles=eventSupported("submit");tQuery.support.changeBubbles=eventSupported("change");div=all=a=null;})();var rbrace=/^(?:\{.*\}|\[.*\])$/;tQuery.extend({cache:{},uuid:0,expando:"tQuery"+(tQuery.fn.tQuery+Math.random()).replace(/\D/g,""),noData:{"embed":true,"object":"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000","applet":true},hasData:function(elem){elem=elem.nodeType?tQuery.cache[elem[tQuery.expando]]:elem[tQuery.expando];return !!elem&&!tQuery.isEmptyObject(elem);},data:function(elem,name,data,pvt){if(!tQuery.acceptData(elem)){return;}var internalKey=tQuery.expando,getByName=typeof name==="string",thisCache,isNode=elem.nodeType,cache=isNode?tQuery.cache:elem,id=isNode?elem[tQuery.expando]:elem[tQuery.expando]&&tQuery.expando;if((!id||(pvt&&id&&!cache[id][internalKey]))&&getByName&&data===undefined){return;}if(!id){if(isNode){elem[tQuery.expando]=id=++tQuery.uuid;}else{id=tQuery.expando;}}if(!cache[id]){cache[id]={};}if(typeof name==="object"){if(pvt){cache[id][internalKey]=tQuery.extend(cache[id][internalKey],name);}else{cache[id]=tQuery.extend(cache[id],name);}}thisCache=cache[id];if(pvt){if(!thisCache[internalKey]){thisCache[internalKey]={};}thisCache=thisCache[internalKey];}if(data!==undefined){thisCache[name]=data;}if(name==="events"&&!thisCache[name]){return thisCache[internalKey]&&thisCache[internalKey].events;}return getByName?thisCache[name]:thisCache;},removeData:function(elem,name,pvt){if(!tQuery.acceptData(elem)){return;}var internalKey=tQuery.expando,isNode=elem.nodeType,cache=isNode?tQuery.cache:elem,id=isNode?elem[tQuery.expando]:tQuery.expando;if(!cache[id]){return;}if(name){var thisCache=pvt?cache[id][internalKey]:cache[id];if(thisCache){delete thisCache[name];if(!tQuery.isEmptyObject(thisCache)){return;}}}if(pvt){delete cache[id][internalKey];if(!tQuery.isEmptyObject(cache[id])){return;}}var internalCache=cache[id][internalKey];if(tQuery.support.deleteExpando||cache!=window){delete cache[id];}else{cache[id]=null;}if(internalCache){cache[id]={};cache[id][internalKey]=internalCache;}else{if(isNode){if(tQuery.support.deleteExpando){delete elem[tQuery.expando];}else{if(elem.removeAttribute){elem.removeAttribute(tQuery.expando);}else{elem[tQuery.expando]=null;}}}}},_data:function(elem,name,data){return tQuery.data(elem,name,data,true);},acceptData:function(elem){if(elem.nodeName){var match=tQuery.noData[elem.nodeName.toLowerCase()];if(match){return !(match===true||elem.getAttribute("classid")!==match);}}return true;}});tQuery.fn.extend({data:function(key,value){var data=null;if(typeof key==="undefined"){if(this.length){data=tQuery.data(this[0]);if(this[0].nodeType===1){var attr=this[0].attributes,name;for(var i=0,l=attr.length;i<l;i++){name=attr[i].name;if(name.indexOf("data-")===0){name=name.substr(5);dataAttr(this[0],name,data[name]);}}}}return data;}else{if(typeof key==="object"){return this.each(function(){tQuery.data(this,key);});}}var parts=key.split(".");parts[1]=parts[1]?"."+parts[1]:"";if(value===undefined){data=this.triggerHandler("getData"+parts[1]+"!",[parts[0]]);if(data===undefined&&this.length){data=tQuery.data(this[0],key);data=dataAttr(this[0],key,data);}return data===undefined&&parts[1]?this.data(parts[0]):data;}else{return this.each(function(){var $this=tQuery(this),args=[parts[0],value];$this.triggerHandler("setData"+parts[1]+"!",args);tQuery.data(this,key,value);$this.triggerHandler("changeData"+parts[1]+"!",args);});}},removeData:function(key){return this.each(function(){tQuery.removeData(this,key);});}});function dataAttr(elem,key,data){if(data===undefined&&elem.nodeType===1){data=elem.getAttribute("data-"+key);if(typeof data==="string"){try{data=data==="true"?true:data==="false"?false:data==="null"?null:!tQuery.isNaN(data)?parseFloat(data):rbrace.test(data)?tQuery.parseJSON(data):data;}catch(e){}tQuery.data(elem,key,data);}else{data=undefined;}}return data;}tQuery.extend({queue:function(elem,type,data){if(!elem){return;}type=(type||"fx")+"queue";var q=tQuery._data(elem,type);if(!data){return q||[];}if(!q||tQuery.isArray(data)){q=tQuery._data(elem,type,tQuery.makeArray(data));}else{q.push(data);}return q;},dequeue:function(elem,type){type=type||"fx";var queue=tQuery.queue(elem,type),fn=queue.shift();if(fn==="inprogress"){fn=queue.shift();}if(fn){if(type==="fx"){queue.unshift("inprogress");}fn.call(elem,function(){tQuery.dequeue(elem,type);});}if(!queue.length){tQuery.removeData(elem,type+"queue",true);}}});tQuery.fn.extend({queue:function(type,data){if(typeof type!=="string"){data=type;type="fx";}if(data===undefined){return tQuery.queue(this[0],type);}return this.each(function(i){var queue=tQuery.queue(this,type,data);if(type==="fx"&&queue[0]!=="inprogress"){tQuery.dequeue(this,type);}});},dequeue:function(type){return this.each(function(){tQuery.dequeue(this,type);});},delay:function(time,type){time=tQuery.fx?tQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,function(){var elem=this;setTimeout(function(){tQuery.dequeue(elem,type);},time);});},clearQueue:function(type){return this.queue(type||"fx",[]);}});var rclass=/[\n\t\r]/g,rspaces=/\s+/,rreturn=/\r/g,rspecialurl=/^(?:href|src|style)$/,rtype=/^(?:button|input)$/i,rfocusable=/^(?:button|input|object|select|textarea)$/i,rclickable=/^a(?:rea)?$/i,rradiocheck=/^(?:radio|checkbox)$/i;tQuery.props={"for":"htmlFor","class":"className",readonly:"readOnly",maxlength:"maxLength",cellspacing:"cellSpacing",rowspan:"rowSpan",colspan:"colSpan",tabindex:"tabIndex",usemap:"useMap",frameborder:"frameBorder"};tQuery.fn.extend({attr:function(name,value){return tQuery.access(this,name,value,true,tQuery.attr);},removeAttr:function(name,fn){return this.each(function(){tQuery.attr(this,name,"");if(this.nodeType===1){this.removeAttribute(name);}});},addClass:function(value){if(tQuery.isFunction(value)){return this.each(function(i){var self=tQuery(this);self.addClass(value.call(this,i,self.attr("class")));});}if(value&&typeof value==="string"){var classNames=(value||"").split(rspaces);for(var i=0,l=this.length;i<l;i++){var elem=this[i];if(elem.nodeType===1){if(!elem.className){elem.className=value;}else{var className=" "+elem.className+" ",setClass=elem.className;for(var c=0,cl=classNames.length;c<cl;c++){if(className.indexOf(" "+classNames[c]+" ")<0){setClass+=" "+classNames[c];}}elem.className=tQuery.trim(setClass);}}}}return this;},removeClass:function(value){if(tQuery.isFunction(value)){return this.each(function(i){var self=tQuery(this);self.removeClass(value.call(this,i,self.attr("class")));});}if((value&&typeof value==="string")||value===undefined){var classNames=(value||"").split(rspaces);for(var i=0,l=this.length;i<l;i++){var elem=this[i];if(elem.nodeType===1&&elem.className){if(value){var className=(" "+elem.className+" ").replace(rclass," ");for(var c=0,cl=classNames.length;c<cl;c++){className=className.replace(" "+classNames[c]+" "," ");}elem.className=tQuery.trim(className);}else{elem.className="";}}}}return this;},toggleClass:function(value,stateVal){var type=typeof value,isBool=typeof stateVal==="boolean";if(tQuery.isFunction(value)){return this.each(function(i){var self=tQuery(this);self.toggleClass(value.call(this,i,self.attr("class"),stateVal),stateVal);});}return this.each(function(){if(type==="string"){var className,i=0,self=tQuery(this),state=stateVal,classNames=value.split(rspaces);while((className=classNames[i++])){state=isBool?state:!self.hasClass(className);self[state?"addClass":"removeClass"](className);}}else{if(type==="undefined"||type==="boolean"){if(this.className){tQuery._data(this,"__className__",this.className);}this.className=this.className||value===false?"":tQuery._data(this,"__className__")||"";}}});},hasClass:function(selector){var className=" "+selector+" ";for(var i=0,l=this.length;i<l;i++){if((" "+this[i].className+" ").replace(rclass," ").indexOf(className)>-1){return true;}}return false;},val:function(value){if(!arguments.length){var elem=this[0];if(elem){if(tQuery.nodeName(elem,"option")){var val=elem.attributes.value;return !val||val.specified?elem.value:elem.text;}if(tQuery.nodeName(elem,"select")){var index=elem.selectedIndex,values=[],options=elem.options,one=elem.type==="select-one";if(index<0){return null;}for(var i=one?index:0,max=one?index+1:options.length;i<max;i++){var option=options[i];if(option.selected&&(tQuery.support.optDisabled?!option.disabled:option.getAttribute("disabled")===null)&&(!option.parentNode.disabled||!tQuery.nodeName(option.parentNode,"optgroup"))){value=tQuery(option).val();if(one){return value;}values.push(value);}}return values;}if(rradiocheck.test(elem.type)&&!tQuery.support.checkOn){return elem.getAttribute("value")===null?"on":elem.value;}return(elem.value||"").replace(rreturn,"");}return undefined;}var isFunction=tQuery.isFunction(value);return this.each(function(i){var self=tQuery(this),val=value;if(this.nodeType!==1){return;}if(isFunction){val=value.call(this,i,self.val());}if(val==null){val="";}else{if(typeof val==="number"){val+="";}else{if(tQuery.isArray(val)){val=tQuery.map(val,function(value){return value==null?"":value+"";});}}}if(tQuery.isArray(val)&&rradiocheck.test(this.type)){this.checked=tQuery.inArray(self.val(),val)>=0;}else{if(tQuery.nodeName(this,"select")){var values=tQuery.makeArray(val);tQuery("option",this).each(function(){this.selected=tQuery.inArray(tQuery(this).val(),values)>=0;});if(!values.length){this.selectedIndex=-1;}}else{this.value=val;}}});}});tQuery.extend({attrFn:{val:true,css:true,html:true,text:true,data:true,width:true,height:true,offset:true},attr:function(elem,name,value,pass){if(!elem||elem.nodeType===3||elem.nodeType===8||elem.nodeType===2){return undefined;}if(pass&&name in tQuery.attrFn){return tQuery(elem)[name](value);}var notxml=elem.nodeType!==1||!tQuery.isXMLDoc(elem),set=value!==undefined;name=notxml&&tQuery.props[name]||name;if(elem.nodeType===1){var special=rspecialurl.test(name);if(name==="selected"&&!tQuery.support.optSelected){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex;}}}if((name in elem||elem[name]!==undefined)&&notxml&&!special){if(set){if(name==="type"&&rtype.test(elem.nodeName)&&elem.parentNode){tQuery.error("type property can't be changed");}if(value===null){if(elem.nodeType===1){elem.removeAttribute(name);}}else{elem[name]=value;}}if(tQuery.nodeName(elem,"form")&&elem.getAttributeNode(name)){return elem.getAttributeNode(name).nodeValue;}if(name==="tabIndex"){var attributeNode=elem.getAttributeNode("tabIndex");return attributeNode&&attributeNode.specified?attributeNode.value:rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href?0:undefined;}return elem[name];}if(!tQuery.support.style&&notxml&&name==="style"){if(set){elem.style.cssText=""+value;}return elem.style.cssText;}if(set){elem.setAttribute(name,""+value);}if(!elem.attributes[name]&&(elem.hasAttribute&&!elem.hasAttribute(name))){return undefined;}var attr=!tQuery.support.hrefNormalized&&notxml&&special?elem.getAttribute(name,2):elem.getAttribute(name);return attr===null?undefined:attr;}if(set){elem[name]=value;}return elem[name];}});var rnamespaces=/\.(.*)$/,rformElems=/^(?:textarea|input|select)$/i,rperiod=/\./g,rspace=/ /g,rescape=/[^\w\s.|`]/g,fcleanup=function(nm){return nm.replace(rescape,"\\$&");},eventKey="events";tQuery.event={add:function(elem,types,handler,data){if(elem.nodeType===3||elem.nodeType===8){return;}if(tQuery.isWindow(elem)&&(elem!==window&&!elem.frameElement)){elem=window;}if(handler===false){handler=returnFalse;}else{if(!handler){return;}}var handleObjIn,handleObj;if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;}if(!handler.guid){handler.guid=tQuery.guid++;}var elemData=tQuery._data(elem);if(!elemData){return;}var events=elemData[eventKey],eventHandle=elemData.handle;if(typeof events==="function"){eventHandle=events.handle;events=events.events;}else{if(!events){if(!elem.nodeType){elemData[eventKey]=elemData=function(){};}elemData.events=events={};}}if(!eventHandle){elemData.handle=eventHandle=function(){return typeof tQuery!=="undefined"&&!tQuery.event.triggered?tQuery.event.handle.apply(eventHandle.elem,arguments):undefined;};}eventHandle.elem=elem;types=types.split(" ");var type,i=0,namespaces;while((type=types[i++])){handleObj=handleObjIn?tQuery.extend({},handleObjIn):{handler:handler,data:data};if(type.indexOf(".")>-1){namespaces=type.split(".");type=namespaces.shift();handleObj.namespace=namespaces.slice(0).sort().join(".");}else{namespaces=[];handleObj.namespace="";}handleObj.type=type;if(!handleObj.guid){handleObj.guid=handler.guid;}var handlers=events[type],special=tQuery.event.special[type]||{};if(!handlers){handlers=events[type]=[];if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===false){if(elem.addEventListener){elem.addEventListener(type,eventHandle,false);}else{if(elem.attachEvent){elem.attachEvent("on"+type,eventHandle);}}}}if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid;}}handlers.push(handleObj);tQuery.event.global[type]=true;}elem=null;},global:{},remove:function(elem,types,handler,pos){if(elem.nodeType===3||elem.nodeType===8){return;}if(handler===false){handler=returnFalse;}var ret,type,fn,j,i=0,all,namespaces,namespace,special,eventType,handleObj,origType,elemData=tQuery.hasData(elem)&&tQuery._data(elem),events=elemData&&elemData[eventKey];if(!elemData||!events){return;}if(typeof events==="function"){elemData=events;events=events.events;}if(types&&types.type){handler=types.handler;types=types.type;}if(!types||typeof types==="string"&&types.charAt(0)==="."){types=types||"";for(type in events){tQuery.event.remove(elem,type+types);}return;}types=types.split(" ");while((type=types[i++])){origType=type;handleObj=null;all=type.indexOf(".")<0;namespaces=[];if(!all){namespaces=type.split(".");type=namespaces.shift();namespace=new RegExp("(^|\\.)"+tQuery.map(namespaces.slice(0).sort(),fcleanup).join("\\.(?:.*\\.)?")+"(\\.|$)");}eventType=events[type];if(!eventType){continue;}if(!handler){for(j=0;j<eventType.length;j++){handleObj=eventType[j];if(all||namespace.test(handleObj.namespace)){tQuery.event.remove(elem,origType,handleObj.handler,j);eventType.splice(j--,1);}}continue;}special=tQuery.event.special[type]||{};for(j=pos||0;j<eventType.length;j++){handleObj=eventType[j];if(handler.guid===handleObj.guid){if(all||namespace.test(handleObj.namespace)){if(pos==null){eventType.splice(j--,1);}if(special.remove){special.remove.call(elem,handleObj);}}if(pos!=null){break;}}}if(eventType.length===0||pos!=null&&eventType.length===1){if(!special.teardown||special.teardown.call(elem,namespaces)===false){tQuery.removeEvent(elem,type,elemData.handle);}ret=null;delete events[type];}}if(tQuery.isEmptyObject(events)){var handle=elemData.handle;if(handle){handle.elem=null;}delete elemData.events;delete elemData.handle;if(typeof elemData==="function"){tQuery.removeData(elem,eventKey,true);}else{if(tQuery.isEmptyObject(elemData)){tQuery.removeData(elem,undefined,true);}}}},trigger:function(event,data,elem){var type=event.type||event,bubbling=arguments[3];if(!bubbling){event=typeof event==="object"?event[tQuery.expando]?event:tQuery.extend(tQuery.Event(type),event):tQuery.Event(type);if(type.indexOf("!")>=0){event.type=type=type.slice(0,-1);event.exclusive=true;}if(!elem){event.stopPropagation();if(tQuery.event.global[type]){tQuery.each(tQuery.cache,function(){var internalKey=tQuery.expando,internalCache=this[internalKey];if(internalCache&&internalCache.events&&internalCache.events[type]){tQuery.event.trigger(event,data,internalCache.handle.elem);}});}}if(!elem||elem.nodeType===3||elem.nodeType===8){return undefined;}event.result=undefined;event.target=elem;data=tQuery.makeArray(data);data.unshift(event);}event.currentTarget=elem;var handle=elem.nodeType?tQuery._data(elem,"handle"):(tQuery._data(elem,eventKey)||{}).handle;if(handle){handle.apply(elem,data);}var parent=elem.parentNode||elem.ownerDocument;try{if(!(elem&&elem.nodeName&&tQuery.noData[elem.nodeName.toLowerCase()])){if(elem["on"+type]&&elem["on"+type].apply(elem,data)===false){event.result=false;event.preventDefault();}}}catch(inlineError){}if(!event.isPropagationStopped()&&parent){tQuery.event.trigger(event,data,parent,true);}else{if(!event.isDefaultPrevented()){var old,target=event.target,targetType=type.replace(rnamespaces,""),isClick=tQuery.nodeName(target,"a")&&targetType==="click",special=tQuery.event.special[targetType]||{};if((!special._default||special._default.call(elem,event)===false)&&!isClick&&!(target&&target.nodeName&&tQuery.noData[target.nodeName.toLowerCase()])){try{if(target[targetType]){old=target["on"+targetType];if(old){target["on"+targetType]=null;}tQuery.event.triggered=true;target[targetType]();}}catch(triggerError){}if(old){target["on"+targetType]=old;}tQuery.event.triggered=false;}}}},handle:function(event){var all,handlers,namespaces,namespace_re,events,namespace_sort=[],args=tQuery.makeArray(arguments);event=args[0]=tQuery.event.fix(event||window.event);event.currentTarget=this;all=event.type.indexOf(".")<0&&!event.exclusive;if(!all){namespaces=event.type.split(".");event.type=namespaces.shift();namespace_sort=namespaces.slice(0).sort();namespace_re=new RegExp("(^|\\.)"+namespace_sort.join("\\.(?:.*\\.)?")+"(\\.|$)");}event.namespace=event.namespace||namespace_sort.join(".");events=tQuery._data(this,eventKey);if(typeof events==="function"){events=events.events;}handlers=(events||{})[event.type];if(events&&handlers){handlers=handlers.slice(0);for(var j=0,l=handlers.length;j<l;j++){var handleObj=handlers[j];if(all||namespace_re.test(handleObj.namespace)){event.handler=handleObj.handler;event.data=handleObj.data;event.handleObj=handleObj;var ret=handleObj.handler.apply(this,args);if(ret!==undefined){event.result=ret;if(ret===false){event.preventDefault();event.stopPropagation();}}if(event.isImmediatePropagationStopped()){break;}}}}return event.result;},props:"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode layerX layerY metaKey newValue offsetX offsetY pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" "),fix:function(event){if(event[tQuery.expando]){return event;}var originalEvent=event;event=tQuery.Event(originalEvent);for(var i=this.props.length,prop;i;){prop=this.props[--i];event[prop]=originalEvent[prop];}if(!event.target){event.target=event.srcElement||document;}if(event.target.nodeType===3){event.target=event.target.parentNode;}if(!event.relatedTarget&&event.fromElement){event.relatedTarget=event.fromElement===event.target?event.toElement:event.fromElement;}if(event.pageX==null&&event.clientX!=null){var doc=document.documentElement,body=document.body;event.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc&&doc.clientLeft||body&&body.clientLeft||0);event.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc&&doc.clientTop||body&&body.clientTop||0);}if(event.which==null&&(event.charCode!=null||event.keyCode!=null)){event.which=event.charCode!=null?event.charCode:event.keyCode;}if(!event.metaKey&&event.ctrlKey){event.metaKey=event.ctrlKey;}if(!event.which&&event.button!==undefined){event.which=(event.button&1?1:(event.button&2?3:(event.button&4?2:0)));}return event;},guid:100000000,proxy:tQuery.proxy,special:{ready:{setup:tQuery.bindReady,teardown:tQuery.noop},live:{add:function(handleObj){tQuery.event.add(this,liveConvert(handleObj.origType,handleObj.selector),tQuery.extend({},handleObj,{handler:liveHandler,guid:handleObj.handler.guid}));},remove:function(handleObj){tQuery.event.remove(this,liveConvert(handleObj.origType,handleObj.selector),handleObj);}},beforeunload:{setup:function(data,namespaces,eventHandle){if(tQuery.isWindow(this)){this.onbeforeunload=eventHandle;}},teardown:function(namespaces,eventHandle){if(this.onbeforeunload===eventHandle){this.onbeforeunload=null;}}}}};tQuery.removeEvent=document.removeEventListener?function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle,false);}}:function(elem,type,handle){if(elem.detachEvent){elem.detachEvent("on"+type,handle);}};tQuery.Event=function(src){if(!this.preventDefault){return new tQuery.Event(src);}if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=(src.defaultPrevented||src.returnValue===false||src.getPreventDefault&&src.getPreventDefault())?returnTrue:returnFalse;}else{this.type=src;}this.timeStamp=tQuery.now();this[tQuery.expando]=true;};function returnFalse(){return false;}function returnTrue(){return true;}tQuery.Event.prototype={preventDefault:function(){this.isDefaultPrevented=returnTrue;var e=this.originalEvent;if(!e){return;}if(e.preventDefault){e.preventDefault();}else{e.returnValue=false;}},stopPropagation:function(){this.isPropagationStopped=returnTrue;var e=this.originalEvent;if(!e){return;}if(e.stopPropagation){e.stopPropagation();}e.cancelBubble=true;},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=returnTrue;this.stopPropagation();},isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse};var withinElement=function(event){var parent=event.relatedTarget;try{while(parent&&parent!==this){parent=parent.parentNode;}if(parent!==this){event.type=event.data;tQuery.event.handle.apply(this,arguments);}}catch(e){}},delegate=function(event){event.type=event.data;tQuery.event.handle.apply(this,arguments);};tQuery.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(orig,fix){tQuery.event.special[orig]={setup:function(data){tQuery.event.add(this,fix,data&&data.selector?delegate:withinElement,orig);},teardown:function(data){tQuery.event.remove(this,fix,data&&data.selector?delegate:withinElement);}};});if(!tQuery.support.submitBubbles){tQuery.event.special.submit={setup:function(data,namespaces){if(this.nodeName&&this.nodeName.toLowerCase()!=="form"){tQuery.event.add(this,"click.specialSubmit",function(e){var elem=e.target,type=elem.type;if((type==="submit"||type==="image")&&tQuery(elem).closest("form").length){e.liveFired=undefined;return trigger("submit",this,arguments);}});tQuery.event.add(this,"keypress.specialSubmit",function(e){var elem=e.target,type=elem.type;if((type==="text"||type==="password")&&tQuery(elem).closest("form").length&&e.keyCode===13){e.liveFired=undefined;return trigger("submit",this,arguments);}});}else{return false;}},teardown:function(namespaces){tQuery.event.remove(this,".specialSubmit");}};}if(!tQuery.support.changeBubbles){var changeFilters,getVal=function(elem){var type=elem.type,val=elem.value;if(type==="radio"||type==="checkbox"){val=elem.checked;}else{if(type==="select-multiple"){val=elem.selectedIndex>-1?tQuery.map(elem.options,function(elem){return elem.selected;}).join("-"):"";}else{if(elem.nodeName.toLowerCase()==="select"){val=elem.selectedIndex;}}}return val;},testChange=function testChange(e){var elem=e.target,data,val;if(!rformElems.test(elem.nodeName)||elem.readOnly){return;}data=tQuery._data(elem,"_change_data");val=getVal(elem);if(e.type!=="focusout"||elem.type!=="radio"){tQuery._data(elem,"_change_data",val);}if(data===undefined||val===data){return;}if(data!=null||val){e.type="change";e.liveFired=undefined;return tQuery.event.trigger(e,arguments[1],elem);}};tQuery.event.special.change={filters:{focusout:testChange,beforedeactivate:testChange,click:function(e){var elem=e.target,type=elem.type;if(type==="radio"||type==="checkbox"||elem.nodeName.toLowerCase()==="select"){return testChange.call(this,e);}},keydown:function(e){var elem=e.target,type=elem.type;if((e.keyCode===13&&elem.nodeName.toLowerCase()!=="textarea")||(e.keyCode===32&&(type==="checkbox"||type==="radio"))||type==="select-multiple"){return testChange.call(this,e);}},beforeactivate:function(e){var elem=e.target;tQuery._data(elem,"_change_data",getVal(elem));}},setup:function(data,namespaces){if(this.type==="file"){return false;}for(var type in changeFilters){tQuery.event.add(this,type+".specialChange",changeFilters[type]);}return rformElems.test(this.nodeName);},teardown:function(namespaces){tQuery.event.remove(this,".specialChange");return rformElems.test(this.nodeName);}};changeFilters=tQuery.event.special.change.filters;changeFilters.focus=changeFilters.beforeactivate;}function trigger(type,elem,args){args[0].type=type;return tQuery.event.handle.apply(elem,args);}if(document.addEventListener){tQuery.each({focus:"focusin",blur:"focusout"},function(orig,fix){tQuery.event.special[fix]={setup:function(){this.addEventListener(orig,handler,true);},teardown:function(){this.removeEventListener(orig,handler,true);}};function handler(e){e=tQuery.event.fix(e);e.type=fix;return tQuery.event.handle.call(this,e);}});}tQuery.each(["bind","one"],function(i,name){tQuery.fn[name]=function(type,data,fn){if(typeof type==="object"){for(var key in type){this[name](key,data,type[key],fn);}return this;}if(tQuery.isFunction(data)||data===false){fn=data;data=undefined;}var handler=name==="one"?tQuery.proxy(fn,function(event){tQuery(this).unbind(event,handler);return fn.apply(this,arguments);}):fn;if(type==="unload"&&name!=="one"){this.one(type,data,fn);}else{for(var i=0,l=this.length;i<l;i++){tQuery.event.add(this[i],type,handler,data);}}return this;};});tQuery.fn.extend({unbind:function(type,fn){if(typeof type==="object"&&!type.preventDefault){for(var key in type){this.unbind(key,type[key]);}}else{for(var i=0,l=this.length;i<l;i++){tQuery.event.remove(this[i],type,fn);}}return this;},delegate:function(selector,types,data,fn){return this.live(types,data,fn,selector);},undelegate:function(selector,types,fn){if(arguments.length===0){return this.unbind("live");}else{return this.die(types,null,fn,selector);}},trigger:function(type,data){return this.each(function(){tQuery.event.trigger(type,data,this);});},triggerHandler:function(type,data){if(this[0]){var event=tQuery.Event(type);event.preventDefault();event.stopPropagation();tQuery.event.trigger(event,data,this[0]);return event.result;}},toggle:function(fn){var args=arguments,i=1;while(i<args.length){tQuery.proxy(fn,args[i++]);}return this.click(tQuery.proxy(fn,function(event){var lastToggle=(tQuery._data(this,"lastToggle"+fn.guid)||0)%i;tQuery._data(this,"lastToggle"+fn.guid,lastToggle+1);event.preventDefault();return args[lastToggle].apply(this,arguments)||false;}));},hover:function(fnOver,fnOut){return this.mouseenter(fnOver).mouseleave(fnOut||fnOver);}});var liveMap={focus:"focusin",blur:"focusout",mouseenter:"mouseover",mouseleave:"mouseout"};tQuery.each(["live","die"],function(i,name){tQuery.fn[name]=function(types,data,fn,origSelector){var type,i=0,match,namespaces,preType,selector=origSelector||this.selector,context=origSelector?this:tQuery(this.context);if(typeof types==="object"&&!types.preventDefault){for(var key in types){context[name](key,data,types[key],selector);}return this;}if(tQuery.isFunction(data)){fn=data;data=undefined;}types=(types||"").split(" ");while((type=types[i++])!=null){match=rnamespaces.exec(type);namespaces="";if(match){namespaces=match[0];type=type.replace(rnamespaces,"");}if(type==="hover"){types.push("mouseenter"+namespaces,"mouseleave"+namespaces);continue;}preType=type;if(type==="focus"||type==="blur"){types.push(liveMap[type]+namespaces);type=type+namespaces;}else{type=(liveMap[type]||type)+namespaces;}if(name==="live"){for(var j=0,l=context.length;j<l;j++){tQuery.event.add(context[j],"live."+liveConvert(type,selector),{data:data,selector:selector,handler:fn,origType:type,origHandler:fn,preType:preType});}}else{context.unbind("live."+liveConvert(type,selector),fn);}}return this;};});function liveHandler(event){var stop,maxLevel,related,match,handleObj,elem,j,i,l,data,close,namespace,ret,elems=[],selectors=[],events=tQuery._data(this,eventKey);if(typeof events==="function"){events=events.events;}if(event.liveFired===this||!events||!events.live||event.target.disabled||event.button&&event.type==="click"){return;}if(event.namespace){namespace=new RegExp("(^|\\.)"+event.namespace.split(".").join("\\.(?:.*\\.)?")+"(\\.|$)");}event.liveFired=this;var live=events.live.slice(0);for(j=0;j<live.length;j++){handleObj=live[j];if(handleObj.origType.replace(rnamespaces,"")===event.type){selectors.push(handleObj.selector);}else{live.splice(j--,1);}}match=tQuery(event.target).closest(selectors,event.currentTarget);for(i=0,l=match.length;i<l;i++){close=match[i];for(j=0;j<live.length;j++){handleObj=live[j];if(close.selector===handleObj.selector&&(!namespace||namespace.test(handleObj.namespace))){elem=close.elem;related=null;if(handleObj.preType==="mouseenter"||handleObj.preType==="mouseleave"){event.type=handleObj.preType;related=tQuery(event.relatedTarget).closest(handleObj.selector)[0];}if(!related||related!==elem){elems.push({elem:elem,handleObj:handleObj,level:close.level});}}}}for(i=0,l=elems.length;i<l;i++){match=elems[i];if(maxLevel&&match.level>maxLevel){break;}event.currentTarget=match.elem;event.data=match.handleObj.data;event.handleObj=match.handleObj;ret=match.handleObj.origHandler.apply(match.elem,arguments);if(ret===false||event.isPropagationStopped()){maxLevel=match.level;if(ret===false){stop=false;}if(event.isImmediatePropagationStopped()){break;}}}return stop;}function liveConvert(type,selector){return(type&&type!=="*"?type+".":"")+selector.replace(rperiod,"`").replace(rspace,"&");}tQuery.each(("blur focus focusin focusout load resize scroll unload click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup error").split(" "),function(i,name){tQuery.fn[name]=function(data,fn){if(fn==null){fn=data;data=null;}return arguments.length>0?this.bind(name,data,fn):this.trigger(name);};if(tQuery.attrFn){tQuery.attrFn[name]=true;}});
/*!
 * Sizzle CSS Selector Engine
 *  Copyright 2011, The Dojo Foundation
 *  Released under the MIT, BSD, and GPL Licenses.
 *  More information: http://sizzlejs.com/
 */
(function(){var chunker=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g,done=0,toString=Object.prototype.toString,hasDuplicate=false,baseHasDuplicate=true;[0,0].sort(function(){baseHasDuplicate=false;return 0;});var Sizzle=function(selector,context,results,seed){results=results||[];context=context||document;var origContext=context;if(context.nodeType!==1&&context.nodeType!==9){return[];}if(!selector||typeof selector!=="string"){return results;}var m,set,checkSet,extra,ret,cur,pop,i,prune=true,contextXML=Sizzle.isXML(context),parts=[],soFar=selector;do{chunker.exec("");m=chunker.exec(soFar);if(m){soFar=m[3];parts.push(m[1]);if(m[2]){extra=m[3];break;}}}while(m);if(parts.length>1&&origPOS.exec(selector)){if(parts.length===2&&Expr.relative[parts[0]]){set=posProcess(parts[0]+parts[1],context);}else{set=Expr.relative[parts[0]]?[context]:Sizzle(parts.shift(),context);while(parts.length){selector=parts.shift();if(Expr.relative[selector]){selector+=parts.shift();}set=posProcess(selector,set);}}}else{if(!seed&&parts.length>1&&context.nodeType===9&&!contextXML&&Expr.match.ID.test(parts[0])&&!Expr.match.ID.test(parts[parts.length-1])){ret=Sizzle.find(parts.shift(),context,contextXML);context=ret.expr?Sizzle.filter(ret.expr,ret.set)[0]:ret.set[0];}if(context){ret=seed?{expr:parts.pop(),set:makeArray(seed)}:Sizzle.find(parts.pop(),parts.length===1&&(parts[0]==="~"||parts[0]==="+")&&context.parentNode?context.parentNode:context,contextXML);set=ret.expr?Sizzle.filter(ret.expr,ret.set):ret.set;if(parts.length>0){checkSet=makeArray(set);}else{prune=false;}while(parts.length){cur=parts.pop();pop=cur;if(!Expr.relative[cur]){cur="";}else{pop=parts.pop();}if(pop==null){pop=context;}Expr.relative[cur](checkSet,pop,contextXML);}}else{checkSet=parts=[];}}if(!checkSet){checkSet=set;}if(!checkSet){Sizzle.error(cur||selector);}if(toString.call(checkSet)==="[object Array]"){if(!prune){results.push.apply(results,checkSet);}else{if(context&&context.nodeType===1){for(i=0;checkSet[i]!=null;i++){if(checkSet[i]&&(checkSet[i]===true||checkSet[i].nodeType===1&&Sizzle.contains(context,checkSet[i]))){results.push(set[i]);}}}else{for(i=0;checkSet[i]!=null;i++){if(checkSet[i]&&checkSet[i].nodeType===1){results.push(set[i]);}}}}}else{makeArray(checkSet,results);}if(extra){Sizzle(extra,origContext,results,seed);Sizzle.uniqueSort(results);}return results;};Sizzle.uniqueSort=function(results){if(sortOrder){hasDuplicate=baseHasDuplicate;results.sort(sortOrder);if(hasDuplicate){for(var i=1;i<results.length;i++){if(results[i]===results[i-1]){results.splice(i--,1);}}}}return results;};Sizzle.matches=function(expr,set){return Sizzle(expr,null,null,set);};Sizzle.matchesSelector=function(node,expr){return Sizzle(expr,null,null,[node]).length>0;};Sizzle.find=function(expr,context,isXML){var set;if(!expr){return[];}for(var i=0,l=Expr.order.length;i<l;i++){var match,type=Expr.order[i];if((match=Expr.leftMatch[type].exec(expr))){var left=match[1];match.splice(1,1);if(left.substr(left.length-1)!=="\\"){match[1]=(match[1]||"").replace(/\\/g,"");set=Expr.find[type](match,context,isXML);if(set!=null){expr=expr.replace(Expr.match[type],"");break;}}}}if(!set){set=typeof context.getElementsByTagName!=="undefined"?context.getElementsByTagName("*"):[];}return{set:set,expr:expr};};Sizzle.filter=function(expr,set,inplace,not){var match,anyFound,old=expr,result=[],curLoop=set,isXMLFilter=set&&set[0]&&Sizzle.isXML(set[0]);while(expr&&set.length){for(var type in Expr.filter){if((match=Expr.leftMatch[type].exec(expr))!=null&&match[2]){var found,item,filter=Expr.filter[type],left=match[1];anyFound=false;match.splice(1,1);if(left.substr(left.length-1)==="\\"){continue;}if(curLoop===result){result=[];}if(Expr.preFilter[type]){match=Expr.preFilter[type](match,curLoop,inplace,result,not,isXMLFilter);if(!match){anyFound=found=true;}else{if(match===true){continue;}}}if(match){for(var i=0;(item=curLoop[i])!=null;i++){if(item){found=filter(item,match,i,curLoop);var pass=not^!!found;if(inplace&&found!=null){if(pass){anyFound=true;}else{curLoop[i]=false;}}else{if(pass){result.push(item);anyFound=true;}}}}}if(found!==undefined){if(!inplace){curLoop=result;}expr=expr.replace(Expr.match[type],"");if(!anyFound){return[];}break;}}}if(expr===old){if(anyFound==null){Sizzle.error(expr);}else{break;}}old=expr;}return curLoop;};Sizzle.error=function(msg){throw"Syntax error, unrecognized expression: "+msg;};var Expr=Sizzle.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,CLASS:/\.((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,NAME:/\[name=['"]*((?:[\w\u00c0-\uFFFF\-]|\\.)+)['"]*\]/,ATTR:/\[\s*((?:[\w\u00c0-\uFFFF\-]|\\.)+)\s*(?:(\S?=)\s*(?:(['"])(.*?)\3|(#?(?:[\w\u00c0-\uFFFF\-]|\\.)*)|)|)\s*\]/,TAG:/^((?:[\w\u00c0-\uFFFF\*\-]|\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\(\s*(even|odd|(?:[+\-]?\d+|(?:[+\-]?\d*)?n\s*(?:[+\-]\s*\d+)?))\s*\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^\-]|$)/,PSEUDO:/:((?:[\w\u00c0-\uFFFF\-]|\\.)+)(?:\((['"]?)((?:\([^\)]+\)|[^\(\)]*)+)\2\))?/},leftMatch:{},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(elem){return elem.getAttribute("href");}},relative:{"+":function(checkSet,part){var isPartStr=typeof part==="string",isTag=isPartStr&&!/\W/.test(part),isPartStrNotTag=isPartStr&&!isTag;if(isTag){part=part.toLowerCase();}for(var i=0,l=checkSet.length,elem;i<l;i++){if((elem=checkSet[i])){while((elem=elem.previousSibling)&&elem.nodeType!==1){}checkSet[i]=isPartStrNotTag||elem&&elem.nodeName.toLowerCase()===part?elem||false:elem===part;}}if(isPartStrNotTag){Sizzle.filter(part,checkSet,true);}},">":function(checkSet,part){var elem,isPartStr=typeof part==="string",i=0,l=checkSet.length;if(isPartStr&&!/\W/.test(part)){part=part.toLowerCase();for(;i<l;i++){elem=checkSet[i];if(elem){var parent=elem.parentNode;checkSet[i]=parent.nodeName.toLowerCase()===part?parent:false;}}}else{for(;i<l;i++){elem=checkSet[i];if(elem){checkSet[i]=isPartStr?elem.parentNode:elem.parentNode===part;}}if(isPartStr){Sizzle.filter(part,checkSet,true);}}},"":function(checkSet,part,isXML){var nodeCheck,doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!/\W/.test(part)){part=part.toLowerCase();nodeCheck=part;checkFn=dirNodeCheck;}checkFn("parentNode",part,doneName,checkSet,nodeCheck,isXML);},"~":function(checkSet,part,isXML){var nodeCheck,doneName=done++,checkFn=dirCheck;if(typeof part==="string"&&!/\W/.test(part)){part=part.toLowerCase();nodeCheck=part;checkFn=dirNodeCheck;}checkFn("previousSibling",part,doneName,checkSet,nodeCheck,isXML);}},find:{ID:function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m&&m.parentNode?[m]:[];}},NAME:function(match,context){if(typeof context.getElementsByName!=="undefined"){var ret=[],results=context.getElementsByName(match[1]);for(var i=0,l=results.length;i<l;i++){if(results[i].getAttribute("name")===match[1]){ret.push(results[i]);}}return ret.length===0?null:ret;}},TAG:function(match,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(match[1]);}}},preFilter:{CLASS:function(match,curLoop,inplace,result,not,isXML){match=" "+match[1].replace(/\\/g,"")+" ";if(isXML){return match;}for(var i=0,elem;(elem=curLoop[i])!=null;i++){if(elem){if(not^(elem.className&&(" "+elem.className+" ").replace(/[\t\n\r]/g," ").indexOf(match)>=0)){if(!inplace){result.push(elem);}}else{if(inplace){curLoop[i]=false;}}}}return false;},ID:function(match){return match[1].replace(/\\/g,"");},TAG:function(match,curLoop){return match[1].toLowerCase();},CHILD:function(match){if(match[1]==="nth"){if(!match[2]){Sizzle.error(match[0]);}match[2]=match[2].replace(/^\+|\s*/g,"");var test=/(-?)(\d*)(?:n([+\-]?\d*))?/.exec(match[2]==="even"&&"2n"||match[2]==="odd"&&"2n+1"||!/\D/.test(match[2])&&"0n+"+match[2]||match[2]);match[2]=(test[1]+(test[2]||1))-0;match[3]=test[3]-0;}else{if(match[2]){Sizzle.error(match[0]);}}match[0]=done++;return match;},ATTR:function(match,curLoop,inplace,result,not,isXML){var name=match[1]=match[1].replace(/\\/g,"");if(!isXML&&Expr.attrMap[name]){match[1]=Expr.attrMap[name];}match[4]=(match[4]||match[5]||"").replace(/\\/g,"");if(match[2]==="~="){match[4]=" "+match[4]+" ";}return match;},PSEUDO:function(match,curLoop,inplace,result,not){if(match[1]==="not"){if((chunker.exec(match[3])||"").length>1||/^\w/.test(match[3])){match[3]=Sizzle(match[3],null,null,curLoop);}else{var ret=Sizzle.filter(match[3],curLoop,inplace,true^not);if(!inplace){result.push.apply(result,ret);}return false;}}else{if(Expr.match.POS.test(match[0])||Expr.match.CHILD.test(match[0])){return true;}}return match;},POS:function(match){match.unshift(true);return match;}},filters:{enabled:function(elem){return elem.disabled===false&&elem.type!=="hidden";},disabled:function(elem){return elem.disabled===true;},checked:function(elem){return elem.checked===true;},selected:function(elem){elem.parentNode.selectedIndex;return elem.selected===true;},parent:function(elem){return !!elem.firstChild;},empty:function(elem){return !elem.firstChild;},has:function(elem,i,match){return !!Sizzle(match[3],elem).length;},header:function(elem){return(/h\d/i).test(elem.nodeName);},text:function(elem){return"text"===elem.type;},radio:function(elem){return"radio"===elem.type;},checkbox:function(elem){return"checkbox"===elem.type;},file:function(elem){return"file"===elem.type;},password:function(elem){return"password"===elem.type;},submit:function(elem){return"submit"===elem.type;},image:function(elem){return"image"===elem.type;},reset:function(elem){return"reset"===elem.type;},button:function(elem){return"button"===elem.type||elem.nodeName.toLowerCase()==="button";},input:function(elem){return(/input|select|textarea|button/i).test(elem.nodeName);}},setFilters:{first:function(elem,i){return i===0;},last:function(elem,i,match,array){return i===array.length-1;},even:function(elem,i){return i%2===0;},odd:function(elem,i){return i%2===1;},lt:function(elem,i,match){return i<match[3]-0;},gt:function(elem,i,match){return i>match[3]-0;},nth:function(elem,i,match){return match[3]-0===i;},eq:function(elem,i,match){return match[3]-0===i;}},filter:{PSEUDO:function(elem,match,i,array){var name=match[1],filter=Expr.filters[name];if(filter){return filter(elem,i,match,array);}else{if(name==="contains"){return(elem.textContent||elem.innerText||Sizzle.getText([elem])||"").indexOf(match[3])>=0;}else{if(name==="not"){var not=match[3];for(var j=0,l=not.length;j<l;j++){if(not[j]===elem){return false;}}return true;}else{Sizzle.error(name);}}}},CHILD:function(elem,match){var type=match[1],node=elem;switch(type){case"only":case"first":while((node=node.previousSibling)){if(node.nodeType===1){return false;}}if(type==="first"){return true;}node=elem;case"last":while((node=node.nextSibling)){if(node.nodeType===1){return false;}}return true;case"nth":var first=match[2],last=match[3];if(first===1&&last===0){return true;}var doneName=match[0],parent=elem.parentNode;if(parent&&(parent.sizcache!==doneName||!elem.nodeIndex)){var count=0;for(node=parent.firstChild;node;node=node.nextSibling){if(node.nodeType===1){node.nodeIndex=++count;}}parent.sizcache=doneName;}var diff=elem.nodeIndex-last;if(first===0){return diff===0;}else{return(diff%first===0&&diff/first>=0);}}},ID:function(elem,match){return elem.nodeType===1&&elem.getAttribute("id")===match;},TAG:function(elem,match){return(match==="*"&&elem.nodeType===1)||elem.nodeName.toLowerCase()===match;},CLASS:function(elem,match){return(" "+(elem.className||elem.getAttribute("class"))+" ").indexOf(match)>-1;},ATTR:function(elem,match){var name=match[1],result=Expr.attrHandle[name]?Expr.attrHandle[name](elem):elem[name]!=null?elem[name]:elem.getAttribute(name),value=result+"",type=match[2],check=match[4];return result==null?type==="!=":type==="="?value===check:type==="*="?value.indexOf(check)>=0:type==="~="?(" "+value+" ").indexOf(check)>=0:!check?value&&result!==false:type==="!="?value!==check:type==="^="?value.indexOf(check)===0:type==="$="?value.substr(value.length-check.length)===check:type==="|="?value===check||value.substr(0,check.length+1)===check+"-":false;},POS:function(elem,match,i,array){var name=match[2],filter=Expr.setFilters[name];if(filter){return filter(elem,i,match,array);}}}};var origPOS=Expr.match.POS,fescape=function(all,num){return"\\"+(num-0+1);};for(var type in Expr.match){Expr.match[type]=new RegExp(Expr.match[type].source+(/(?![^\[]*\])(?![^\(]*\))/.source));Expr.leftMatch[type]=new RegExp(/(^(?:.|\r|\n)*?)/.source+Expr.match[type].source.replace(/\\(\d+)/g,fescape));}var makeArray=function(array,results){array=Array.prototype.slice.call(array,0);if(results){results.push.apply(results,array);return results;}return array;};try{Array.prototype.slice.call(document.documentElement.childNodes,0)[0].nodeType;}catch(e){makeArray=function(array,results){var i=0,ret=results||[];if(toString.call(array)==="[object Array]"){Array.prototype.push.apply(ret,array);}else{if(typeof array.length==="number"){for(var l=array.length;i<l;i++){ret.push(array[i]);}}else{for(;array[i];i++){ret.push(array[i]);}}}return ret;};}var sortOrder,siblingCheck;if(document.documentElement.compareDocumentPosition){sortOrder=function(a,b){if(a===b){hasDuplicate=true;return 0;}if(!a.compareDocumentPosition||!b.compareDocumentPosition){return a.compareDocumentPosition?-1:1;}return a.compareDocumentPosition(b)&4?-1:1;};}else{sortOrder=function(a,b){var al,bl,ap=[],bp=[],aup=a.parentNode,bup=b.parentNode,cur=aup;if(a===b){hasDuplicate=true;return 0;}else{if(aup===bup){return siblingCheck(a,b);}else{if(!aup){return -1;}else{if(!bup){return 1;}}}}while(cur){ap.unshift(cur);cur=cur.parentNode;}cur=bup;while(cur){bp.unshift(cur);cur=cur.parentNode;}al=ap.length;bl=bp.length;for(var i=0;i<al&&i<bl;i++){if(ap[i]!==bp[i]){return siblingCheck(ap[i],bp[i]);}}return i===al?siblingCheck(a,bp[i],-1):siblingCheck(ap[i],b,1);};siblingCheck=function(a,b,ret){if(a===b){return ret;}var cur=a.nextSibling;while(cur){if(cur===b){return -1;}cur=cur.nextSibling;}return 1;};}Sizzle.getText=function(elems){var ret="",elem;for(var i=0;elems[i];i++){elem=elems[i];if(elem.nodeType===3||elem.nodeType===4){ret+=elem.nodeValue;}else{if(elem.nodeType!==8){ret+=Sizzle.getText(elem.childNodes);}}}return ret;};(function(){var form=document.createElement("div"),id="script"+(new Date()).getTime(),root=document.documentElement;form.innerHTML="<a name='"+id+"'/>";root.insertBefore(form,root.firstChild);if(document.getElementById(id)){Expr.find.ID=function(match,context,isXML){if(typeof context.getElementById!=="undefined"&&!isXML){var m=context.getElementById(match[1]);return m?m.id===match[1]||typeof m.getAttributeNode!=="undefined"&&m.getAttributeNode("id").nodeValue===match[1]?[m]:undefined:[];}};Expr.filter.ID=function(elem,match){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return elem.nodeType===1&&node&&node.nodeValue===match;};}root.removeChild(form);root=form=null;})();(function(){var div=document.createElement("div");div.appendChild(document.createComment(""));if(div.getElementsByTagName("*").length>0){Expr.find.TAG=function(match,context){var results=context.getElementsByTagName(match[1]);if(match[1]==="*"){var tmp=[];for(var i=0;results[i];i++){if(results[i].nodeType===1){tmp.push(results[i]);}}results=tmp;}return results;};}div.innerHTML="<a href='#'></a>";if(div.firstChild&&typeof div.firstChild.getAttribute!=="undefined"&&div.firstChild.getAttribute("href")!=="#"){Expr.attrHandle.href=function(elem){return elem.getAttribute("href",2);};}div=null;})();if(document.querySelectorAll){(function(){var oldSizzle=Sizzle,div=document.createElement("div"),id="__sizzle__";div.innerHTML="<p class='TEST'></p>";if(div.querySelectorAll&&div.querySelectorAll(".TEST").length===0){return;}Sizzle=function(query,context,extra,seed){context=context||document;if(!seed&&!Sizzle.isXML(context)){var match=/^(\w+$)|^\.([\w\-]+$)|^#([\w\-]+$)/.exec(query);if(match&&(context.nodeType===1||context.nodeType===9)){if(match[1]){return makeArray(context.getElementsByTagName(query),extra);}else{if(match[2]&&Expr.find.CLASS&&context.getElementsByClassName){return makeArray(context.getElementsByClassName(match[2]),extra);}}}if(context.nodeType===9){if(query==="body"&&context.body){return makeArray([context.body],extra);}else{if(match&&match[3]){var elem=context.getElementById(match[3]);if(elem&&elem.parentNode){if(elem.id===match[3]){return makeArray([elem],extra);}}else{return makeArray([],extra);}}}try{return makeArray(context.querySelectorAll(query),extra);}catch(qsaError){}}else{if(context.nodeType===1&&context.nodeName.toLowerCase()!=="object"){var old=context.getAttribute("id"),nid=old||id,hasParent=context.parentNode,relativeHierarchySelector=/^\s*[+~]/.test(query);if(!old){context.setAttribute("id",nid);}else{nid=nid.replace(/'/g,"\\$&");}if(relativeHierarchySelector&&hasParent){context=context.parentNode;}try{if(!relativeHierarchySelector||hasParent){return makeArray(context.querySelectorAll("[id='"+nid+"'] "+query),extra);}}catch(pseudoError){}finally{if(!old){context.removeAttribute("id");}}}}}return oldSizzle(query,context,extra,seed);};for(var prop in oldSizzle){Sizzle[prop]=oldSizzle[prop];}div=null;})();}(function(){var html=document.documentElement,matches=html.matchesSelector||html.mozMatchesSelector||html.webkitMatchesSelector||html.msMatchesSelector,pseudoWorks=false;try{matches.call(document.documentElement,"[test!='']:sizzle");}catch(pseudoError){pseudoWorks=true;}if(matches){Sizzle.matchesSelector=function(node,expr){expr=expr.replace(/\=\s*([^'"\]]*)\s*\]/g,"='$1']");if(!Sizzle.isXML(node)){try{if(pseudoWorks||!Expr.match.PSEUDO.test(expr)&&!/!=/.test(expr)){return matches.call(node,expr);}}catch(e){}}return Sizzle(expr,null,null,[node]).length>0;};}})();(function(){var div=document.createElement("div");div.innerHTML="<div class='test e'></div><div class='test'></div>";if(!div.getElementsByClassName||div.getElementsByClassName("e").length===0){return;}div.lastChild.className="e";if(div.getElementsByClassName("e").length===1){return;}Expr.order.splice(1,0,"CLASS");Expr.find.CLASS=function(match,context,isXML){if(typeof context.getElementsByClassName!=="undefined"&&!isXML){return context.getElementsByClassName(match[1]);}};div=null;})();function dirNodeCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var match=false;elem=elem[dir];while(elem){if(elem.sizcache===doneName){match=checkSet[elem.sizset];break;}if(elem.nodeType===1&&!isXML){elem.sizcache=doneName;elem.sizset=i;}if(elem.nodeName.toLowerCase()===cur){match=elem;break;}elem=elem[dir];}checkSet[i]=match;}}}function dirCheck(dir,cur,doneName,checkSet,nodeCheck,isXML){for(var i=0,l=checkSet.length;i<l;i++){var elem=checkSet[i];if(elem){var match=false;elem=elem[dir];while(elem){if(elem.sizcache===doneName){match=checkSet[elem.sizset];break;}if(elem.nodeType===1){if(!isXML){elem.sizcache=doneName;elem.sizset=i;}if(typeof cur!=="string"){if(elem===cur){match=true;break;}}else{if(Sizzle.filter(cur,[elem]).length>0){match=elem;break;}}}elem=elem[dir];}checkSet[i]=match;}}}if(document.documentElement.contains){Sizzle.contains=function(a,b){return a!==b&&(a.contains?a.contains(b):true);};}else{if(document.documentElement.compareDocumentPosition){Sizzle.contains=function(a,b){return !!(a.compareDocumentPosition(b)&16);};}else{Sizzle.contains=function(){return false;};}}Sizzle.isXML=function(elem){var documentElement=(elem?elem.ownerDocument||elem:0).documentElement;return documentElement?documentElement.nodeName!=="HTML":false;};var posProcess=function(selector,context){var match,tmpSet=[],later="",root=context.nodeType?[context]:context;while((match=Expr.match.PSEUDO.exec(selector))){later+=match[0];selector=selector.replace(Expr.match.PSEUDO,"");}selector=Expr.relative[selector]?selector+"*":selector;for(var i=0,l=root.length;i<l;i++){Sizzle(selector,root[i],tmpSet);}return Sizzle.filter(later,tmpSet);};tQuery.find=Sizzle;tQuery.expr=Sizzle.selectors;tQuery.expr[":"]=tQuery.expr.filters;tQuery.unique=Sizzle.uniqueSort;tQuery.text=Sizzle.getText;tQuery.isXMLDoc=Sizzle.isXML;tQuery.contains=Sizzle.contains;})();var runtil=/Until$/,rparentsprev=/^(?:parents|prevUntil|prevAll)/,rmultiselector=/,/,isSimple=/^.[^:#\[\.,]*$/,slice=Array.prototype.slice,POS=tQuery.expr.match.POS,guaranteedUnique={children:true,contents:true,next:true,prev:true};tQuery.fn.extend({find:function(selector){var ret=this.pushStack("","find",selector),length=0;for(var i=0,l=this.length;i<l;i++){length=ret.length;tQuery.find(selector,this[i],ret);if(i>0){for(var n=length;n<ret.length;n++){for(var r=0;r<length;r++){if(ret[r]===ret[n]){ret.splice(n--,1);break;}}}}}return ret;},has:function(target){var targets=tQuery(target);return this.filter(function(){for(var i=0,l=targets.length;i<l;i++){if(tQuery.contains(this,targets[i])){return true;}}});},not:function(selector){return this.pushStack(winnow(this,selector,false),"not",selector);},filter:function(selector){return this.pushStack(winnow(this,selector,true),"filter",selector);},is:function(selector){return !!selector&&tQuery.filter(selector,this).length>0;},closest:function(selectors,context){var ret=[],i,l,cur=this[0];if(tQuery.isArray(selectors)){var match,selector,matches={},level=1;if(cur&&selectors.length){for(i=0,l=selectors.length;i<l;i++){selector=selectors[i];if(!matches[selector]){matches[selector]=tQuery.expr.match.POS.test(selector)?tQuery(selector,context||this.context):selector;}}while(cur&&cur.ownerDocument&&cur!==context){for(selector in matches){match=matches[selector];if(match.tQuery?match.index(cur)>-1:tQuery(cur).is(match)){ret.push({selector:selector,elem:cur,level:level});}}cur=cur.parentNode;level++;}}return ret;}var pos=POS.test(selectors)?tQuery(selectors,context||this.context):null;for(i=0,l=this.length;i<l;i++){cur=this[i];while(cur){if(pos?pos.index(cur)>-1:tQuery.find.matchesSelector(cur,selectors)){ret.push(cur);break;}else{cur=cur.parentNode;if(!cur||!cur.ownerDocument||cur===context){break;}}}}ret=ret.length>1?tQuery.unique(ret):ret;return this.pushStack(ret,"closest",selectors);},index:function(elem){if(!elem||typeof elem==="string"){return tQuery.inArray(this[0],elem?tQuery(elem):this.parent().children());}return tQuery.inArray(elem.tQuery?elem[0]:elem,this);},add:function(selector,context){var set=typeof selector==="string"?tQuery(selector,context):tQuery.makeArray(selector),all=tQuery.merge(this.get(),set);return this.pushStack(isDisconnected(set[0])||isDisconnected(all[0])?all:tQuery.unique(all));},andSelf:function(){return this.add(this.prevObject);}});function isDisconnected(node){return !node||!node.parentNode||node.parentNode.nodeType===11;}tQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null;},parents:function(elem){return tQuery.dir(elem,"parentNode");},parentsUntil:function(elem,i,until){return tQuery.dir(elem,"parentNode",until);},next:function(elem){return tQuery.nth(elem,2,"nextSibling");},prev:function(elem){return tQuery.nth(elem,2,"previousSibling");},nextAll:function(elem){return tQuery.dir(elem,"nextSibling");},prevAll:function(elem){return tQuery.dir(elem,"previousSibling");},nextUntil:function(elem,i,until){return tQuery.dir(elem,"nextSibling",until);},prevUntil:function(elem,i,until){return tQuery.dir(elem,"previousSibling",until);},siblings:function(elem){return tQuery.sibling(elem.parentNode.firstChild,elem);},children:function(elem){return tQuery.sibling(elem.firstChild);},contents:function(elem){return tQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:tQuery.makeArray(elem.childNodes);}},function(name,fn){tQuery.fn[name]=function(until,selector){var ret=tQuery.map(this,fn,until),args=slice.call(arguments);if(!runtil.test(name)){selector=until;}if(selector&&typeof selector==="string"){ret=tQuery.filter(selector,ret);}ret=this.length>1&&!guaranteedUnique[name]?tQuery.unique(ret):ret;if((this.length>1||rmultiselector.test(selector))&&rparentsprev.test(name)){ret=ret.reverse();}return this.pushStack(ret,name,args.join(","));};});tQuery.extend({filter:function(expr,elems,not){if(not){expr=":not("+expr+")";}return elems.length===1?tQuery.find.matchesSelector(elems[0],expr)?[elems[0]]:[]:tQuery.find.matches(expr,elems);},dir:function(elem,dir,until){var matched=[],cur=elem[dir];while(cur&&cur.nodeType!==9&&(until===undefined||cur.nodeType!==1||!tQuery(cur).is(until))){if(cur.nodeType===1){matched.push(cur);}cur=cur[dir];}return matched;},nth:function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir]){if(cur.nodeType===1&&++num===result){break;}}return cur;},sibling:function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){r.push(n);}}return r;}});function winnow(elements,qualifier,keep){if(tQuery.isFunction(qualifier)){return tQuery.grep(elements,function(elem,i){var retVal=!!qualifier.call(elem,i,elem);return retVal===keep;});}else{if(qualifier.nodeType){return tQuery.grep(elements,function(elem,i){return(elem===qualifier)===keep;});}else{if(typeof qualifier==="string"){var filtered=tQuery.grep(elements,function(elem){return elem.nodeType===1;});if(isSimple.test(qualifier)){return tQuery.filter(qualifier,filtered,!keep);}else{qualifier=tQuery.filter(qualifier,filtered);}}}}return tQuery.grep(elements,function(elem,i){return(tQuery.inArray(elem,qualifier)>=0)===keep;});}var rinlinetQuery=/ tQuery\d+="(?:\d+|null)"/g,rleadingWhitespace=/^\s+/,rxhtmlTag=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/ig,rtagName=/<([\w:]+)/,rtbody=/<tbody/i,rhtml=/<|&#?\w+;/,rnocache=/<(?:script|object|embed|option|style)/i,rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,wrapMap={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],area:[1,"<map>","</map>"],_default:[0,"",""]};wrapMap.optgroup=wrapMap.option;wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!tQuery.support.htmlSerialize){wrapMap._default=[1,"div<div>","</div>"];}tQuery.fn.extend({text:function(text){if(tQuery.isFunction(text)){return this.each(function(i){var self=tQuery(this);self.text(text.call(this,i,self.text()));});}if(typeof text!=="object"&&text!==undefined){return this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(text));}return tQuery.text(this);},wrapAll:function(html){if(tQuery.isFunction(html)){return this.each(function(i){tQuery(this).wrapAll(html.call(this,i));});}if(this[0]){var wrap=tQuery(html,this[0].ownerDocument).eq(0).clone(true);if(this[0].parentNode){wrap.insertBefore(this[0]);}wrap.map(function(){var elem=this;while(elem.firstChild&&elem.firstChild.nodeType===1){elem=elem.firstChild;}return elem;}).append(this);}return this;},wrapInner:function(html){if(tQuery.isFunction(html)){return this.each(function(i){tQuery(this).wrapInner(html.call(this,i));});}return this.each(function(){var self=tQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html);}else{self.append(html);}});},wrap:function(html){return this.each(function(){tQuery(this).wrapAll(html);});},unwrap:function(){return this.parent().each(function(){if(!tQuery.nodeName(this,"body")){tQuery(this).replaceWith(this.childNodes);}}).end();},append:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType===1){this.appendChild(elem);}});},prepend:function(){return this.domManip(arguments,true,function(elem){if(this.nodeType===1){this.insertBefore(elem,this.firstChild);}});},before:function(){if(this[0]&&this[0].parentNode){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this);});}else{if(arguments.length){var set=tQuery(arguments[0]);set.push.apply(set,this.toArray());return this.pushStack(set,"before",arguments);}}},after:function(){if(this[0]&&this[0].parentNode){return this.domManip(arguments,false,function(elem){this.parentNode.insertBefore(elem,this.nextSibling);});}else{if(arguments.length){var set=this.pushStack(this,"after",arguments);set.push.apply(set,tQuery(arguments[0]).toArray());return set;}}},remove:function(selector,keepData){for(var i=0,elem;(elem=this[i])!=null;i++){if(!selector||tQuery.filter(selector,[elem]).length){if(!keepData&&elem.nodeType===1){tQuery.cleanData(elem.getElementsByTagName("*"));tQuery.cleanData([elem]);}if(elem.parentNode){elem.parentNode.removeChild(elem);}}}return this;},empty:function(){for(var i=0,elem;(elem=this[i])!=null;i++){if(elem.nodeType===1){tQuery.cleanData(elem.getElementsByTagName("*"));}while(elem.firstChild){elem.removeChild(elem.firstChild);}}return this;},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?true:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map(function(){return tQuery.clone(this,dataAndEvents,deepDataAndEvents);});},html:function(value){if(value===undefined){return this[0]&&this[0].nodeType===1?this[0].innerHTML.replace(rinlinetQuery,""):null;}else{if(typeof value==="string"&&!rnocache.test(value)&&(tQuery.support.leadingWhitespace||!rleadingWhitespace.test(value))&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=value.replace(rxhtmlTag,"<$1></$2>");try{for(var i=0,l=this.length;i<l;i++){if(this[i].nodeType===1){tQuery.cleanData(this[i].getElementsByTagName("*"));this[i].innerHTML=value;}}}catch(e){this.empty().append(value);}}else{if(tQuery.isFunction(value)){this.each(function(i){var self=tQuery(this);self.html(value.call(this,i,self.html()));});}else{this.empty().append(value);}}}return this;},replaceWith:function(value){if(this[0]&&this[0].parentNode){if(tQuery.isFunction(value)){return this.each(function(i){var self=tQuery(this),old=self.html();self.replaceWith(value.call(this,i,old));});}if(typeof value!=="string"){value=tQuery(value).detach();}return this.each(function(){var next=this.nextSibling,parent=this.parentNode;tQuery(this).remove();if(next){tQuery(next).before(value);}else{tQuery(parent).append(value);}});}else{return this.pushStack(tQuery(tQuery.isFunction(value)?value():value),"replaceWith",value);}},detach:function(selector){return this.remove(selector,true);},domManip:function(args,table,callback){var results,first,fragment,parent,value=args[0],scripts=[];if(!tQuery.support.checkClone&&arguments.length===3&&typeof value==="string"&&rchecked.test(value)){return this.each(function(){tQuery(this).domManip(args,table,callback,true);});}if(tQuery.isFunction(value)){return this.each(function(i){var self=tQuery(this);args[0]=value.call(this,i,table?self.html():undefined);self.domManip(args,table,callback);});}if(this[0]){parent=value&&value.parentNode;if(tQuery.support.parentNode&&parent&&parent.nodeType===11&&parent.childNodes.length===this.length){results={fragment:parent};}else{results=tQuery.buildFragment(args,this,scripts);}fragment=results.fragment;if(fragment.childNodes.length===1){first=fragment=fragment.firstChild;}else{first=fragment.firstChild;}if(first){table=table&&tQuery.nodeName(first,"tr");for(var i=0,l=this.length,lastIndex=l-1;i<l;i++){callback.call(table?root(this[i],first):this[i],results.cacheable||(l>1&&i<lastIndex)?tQuery.clone(fragment,true,true):fragment);}}if(scripts.length){tQuery.each(scripts,evalScript);}}return this;}});function root(elem,cur){return tQuery.nodeName(elem,"table")?(elem.getElementsByTagName("tbody")[0]||elem.appendChild(elem.ownerDocument.createElement("tbody"))):elem;}function cloneCopyEvent(src,dest){if(dest.nodeType!==1||!tQuery.hasData(src)){return;}var internalKey=tQuery.expando,oldData=tQuery.data(src),curData=tQuery.data(dest,oldData);if((oldData=oldData[internalKey])){var events=oldData.events;curData=curData[internalKey]=tQuery.extend({},oldData);if(events){delete curData.handle;curData.events={};for(var type in events){for(var i=0,l=events[type].length;i<l;i++){tQuery.event.add(dest,type,events[type][i],events[type][i].data);}}}}}function cloneFixAttributes(src,dest){if(dest.nodeType!==1){return;}var nodeName=dest.nodeName.toLowerCase();dest.clearAttributes();dest.mergeAttributes(src);if(nodeName==="object"){dest.outerHTML=src.outerHTML;}else{if(nodeName==="input"&&(src.type==="checkbox"||src.type==="radio")){if(src.checked){dest.defaultChecked=dest.checked=src.checked;}if(dest.value!==src.value){dest.value=src.value;}}else{if(nodeName==="option"){dest.selected=src.defaultSelected;}else{if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue;}}}}dest.removeAttribute(tQuery.expando);}tQuery.buildFragment=function(args,nodes,scripts){var fragment,cacheable,cacheresults,doc=(nodes&&nodes[0]?nodes[0].ownerDocument||nodes[0]:document);if(args.length===1&&typeof args[0]==="string"&&args[0].length<512&&doc===document&&args[0].charAt(0)==="<"&&!rnocache.test(args[0])&&(tQuery.support.checkClone||!rchecked.test(args[0]))){cacheable=true;cacheresults=tQuery.fragments[args[0]];if(cacheresults){if(cacheresults!==1){fragment=cacheresults;}}}if(!fragment){fragment=doc.createDocumentFragment();tQuery.clean(args,doc,fragment,scripts);}if(cacheable){tQuery.fragments[args[0]]=cacheresults?fragment:1;}return{fragment:fragment,cacheable:cacheable};};tQuery.fragments={};tQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){tQuery.fn[name]=function(selector){var ret=[],insert=tQuery(selector),parent=this.length===1&&this[0].parentNode;if(parent&&parent.nodeType===11&&parent.childNodes.length===1&&insert.length===1){insert[original](this[0]);return this;}else{for(var i=0,l=insert.length;i<l;i++){var elems=(i>0?this.clone(true):this).get();tQuery(insert[i])[original](elems);ret=ret.concat(elems);}return this.pushStack(ret,name,insert.selector);}};});tQuery.extend({clone:function(elem,dataAndEvents,deepDataAndEvents){var clone=elem.cloneNode(true),srcElements,destElements,i;if(!tQuery.support.noCloneEvent&&(elem.nodeType===1||elem.nodeType===11)&&!tQuery.isXMLDoc(elem)){srcElements=elem.getElementsByTagName("*");destElements=clone.getElementsByTagName("*");for(i=0;srcElements[i];++i){cloneFixAttributes(srcElements[i],destElements[i]);}cloneFixAttributes(elem,clone);}if(dataAndEvents){cloneCopyEvent(elem,clone);if(deepDataAndEvents&&"getElementsByTagName" in elem){srcElements=elem.getElementsByTagName("*");destElements=clone.getElementsByTagName("*");if(srcElements.length){for(i=0;srcElements[i];++i){cloneCopyEvent(srcElements[i],destElements[i]);}}}}return clone;},clean:function(elems,context,fragment,scripts){context=context||document;if(typeof context.createElement==="undefined"){context=context.ownerDocument||context[0]&&context[0].ownerDocument||document;}var ret=[];for(var i=0,elem;(elem=elems[i])!=null;i++){if(typeof elem==="number"){elem+="";}if(!elem){continue;}if(typeof elem==="string"&&!rhtml.test(elem)){elem=context.createTextNode(elem);}else{if(typeof elem==="string"){elem=elem.replace(rxhtmlTag,"<$1></$2>");var tag=(rtagName.exec(elem)||["",""])[1].toLowerCase(),wrap=wrapMap[tag]||wrapMap._default,depth=wrap[0],div=context.createElement("div");div.innerHTML=wrap[1]+elem+wrap[2];while(depth--){div=div.lastChild;}if(!tQuery.support.tbody){var hasBody=rtbody.test(elem),tbody=tag==="table"&&!hasBody?div.firstChild&&div.firstChild.childNodes:wrap[1]==="<table>"&&!hasBody?div.childNodes:[];for(var j=tbody.length-1;j>=0;--j){if(tQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length){tbody[j].parentNode.removeChild(tbody[j]);}}}if(!tQuery.support.leadingWhitespace&&rleadingWhitespace.test(elem)){div.insertBefore(context.createTextNode(rleadingWhitespace.exec(elem)[0]),div.firstChild);}elem=div.childNodes;}}if(elem.nodeType){ret.push(elem);}else{ret=tQuery.merge(ret,elem);}}if(fragment){for(i=0;ret[i];i++){if(scripts&&tQuery.nodeName(ret[i],"script")&&(!ret[i].type||ret[i].type.toLowerCase()==="text/javascript")){scripts.push(ret[i].parentNode?ret[i].parentNode.removeChild(ret[i]):ret[i]);}else{if(ret[i].nodeType===1){ret.splice.apply(ret,[i+1,0].concat(tQuery.makeArray(ret[i].getElementsByTagName("script"))));}fragment.appendChild(ret[i]);}}}return ret;},cleanData:function(elems){var data,id,cache=tQuery.cache,internalKey=tQuery.expando,special=tQuery.event.special,deleteExpando=tQuery.support.deleteExpando;for(var i=0,elem;(elem=elems[i])!=null;i++){if(elem.nodeName&&tQuery.noData[elem.nodeName.toLowerCase()]){continue;}id=elem[tQuery.expando];if(id){data=cache[id]&&cache[id][internalKey];if(data&&data.events){for(var type in data.events){if(special[type]){tQuery.event.remove(elem,type);}else{tQuery.removeEvent(elem,type,data.handle);}}if(data.handle){data.handle.elem=null;}}if(deleteExpando){delete elem[tQuery.expando];}else{if(elem.removeAttribute){elem.removeAttribute(tQuery.expando);}}delete cache[id];}}}});function evalScript(i,elem){if(elem.src){tQuery.ajax({url:elem.src,async:false,dataType:"script"});}else{tQuery.globalEval(elem.text||elem.textContent||elem.innerHTML||"");}if(elem.parentNode){elem.parentNode.removeChild(elem);}}var ralpha=/alpha\([^)]*\)/i,ropacity=/opacity=([^)]*)/,rdashAlpha=/-([a-z])/ig,rupper=/([A-Z])/g,rnumpx=/^-?\d+(?:px)?$/i,rnum=/^-?\d/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssWidth=["Left","Right"],cssHeight=["Top","Bottom"],curCSS,getComputedStyle,currentStyle,fcamelCase=function(all,letter){return letter.toUpperCase();};tQuery.fn.css=function(name,value){if(arguments.length===2&&value===undefined){return this;}return tQuery.access(this,name,value,true,function(elem,name,value){return value!==undefined?tQuery.style(elem,name,value):tQuery.css(elem,name);});};tQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity","opacity");return ret===""?"1":ret;}else{return elem.style.opacity;}}}},cssNumber:{"zIndex":true,"fontWeight":true,"opacity":true,"zoom":true,"lineHeight":true},cssProps:{"float":tQuery.support.cssFloat?"cssFloat":"styleFloat"},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return;}var ret,origName=tQuery.camelCase(name),style=elem.style,hooks=tQuery.cssHooks[origName];name=tQuery.cssProps[origName]||origName;if(value!==undefined){if(typeof value==="number"&&isNaN(value)||value==null){return;}if(typeof value==="number"&&!tQuery.cssNumber[origName]){value+="px";}if(!hooks||!("set" in hooks)||(value=hooks.set(elem,value))!==undefined){try{style[name]=value;}catch(e){}}}else{if(hooks&&"get" in hooks&&(ret=hooks.get(elem,false,extra))!==undefined){return ret;}return style[name];}},css:function(elem,name,extra){var ret,origName=tQuery.camelCase(name),hooks=tQuery.cssHooks[origName];name=tQuery.cssProps[origName]||origName;if(hooks&&"get" in hooks&&(ret=hooks.get(elem,true,extra))!==undefined){return ret;}else{if(curCSS){return curCSS(elem,name,origName);}}},swap:function(elem,options,callback){var old={};for(var name in options){old[name]=elem.style[name];elem.style[name]=options[name];}callback.call(elem);for(name in options){elem.style[name]=old[name];}},camelCase:function(string){return string.replace(rdashAlpha,fcamelCase);}});tQuery.curCSS=tQuery.css;tQuery.each(["height","width"],function(i,name){tQuery.cssHooks[name]={get:function(elem,computed,extra){var val;if(computed){if(elem.offsetWidth!==0){val=getWH(elem,name,extra);}else{tQuery.swap(elem,cssShow,function(){val=getWH(elem,name,extra);});}if(val<=0){val=curCSS(elem,name,name);if(val==="0px"&&currentStyle){val=currentStyle(elem,name,name);}if(val!=null){return val===""||val==="auto"?"0px":val;}}if(val<0||val==null){val=elem.style[name];return val===""||val==="auto"?"0px":val;}return typeof val==="string"?val:val+"px";}},set:function(elem,value){if(rnumpx.test(value)){value=parseFloat(value);if(value>=0){return value+"px";}}else{return value;}}};});if(!tQuery.support.opacity){tQuery.cssHooks.opacity={get:function(elem,computed){return ropacity.test((computed&&elem.currentStyle?elem.currentStyle.filter:elem.style.filter)||"")?(parseFloat(RegExp.$1)/100)+"":computed?"1":"";},set:function(elem,value){var style=elem.style;style.zoom=1;var opacity=tQuery.isNaN(value)?"":"alpha(opacity="+value*100+")",filter=style.filter||"";style.filter=ralpha.test(filter)?filter.replace(ralpha,opacity):style.filter+" "+opacity;}};}if(document.defaultView&&document.defaultView.getComputedStyle){getComputedStyle=function(elem,newName,name){var ret,defaultView,computedStyle;name=name.replace(rupper,"-$1").toLowerCase();if(!(defaultView=elem.ownerDocument.defaultView)){return undefined;}if((computedStyle=defaultView.getComputedStyle(elem,null))){ret=computedStyle.getPropertyValue(name);if(ret===""&&!tQuery.contains(elem.ownerDocument.documentElement,elem)){ret=tQuery.style(elem,name);}}return ret;};}if(document.documentElement.currentStyle){currentStyle=function(elem,name){var left,ret=elem.currentStyle&&elem.currentStyle[name],rsLeft=elem.runtimeStyle&&elem.runtimeStyle[name],style=elem.style;if(!rnumpx.test(ret)&&rnum.test(ret)){left=style.left;if(rsLeft){elem.runtimeStyle.left=elem.currentStyle.left;}style.left=name==="fontSize"?"1em":(ret||0);ret=style.pixelLeft+"px";style.left=left;if(rsLeft){elem.runtimeStyle.left=rsLeft;}}return ret===""?"auto":ret;};}curCSS=getComputedStyle||currentStyle;function getWH(elem,name,extra){var which=name==="width"?cssWidth:cssHeight,val=name==="width"?elem.offsetWidth:elem.offsetHeight;if(extra==="border"){return val;}tQuery.each(which,function(){if(!extra){val-=parseFloat(tQuery.css(elem,"padding"+this))||0;}if(extra==="margin"){val+=parseFloat(tQuery.css(elem,"margin"+this))||0;}else{val-=parseFloat(tQuery.css(elem,"border"+this+"Width"))||0;}});return val;}if(tQuery.expr&&tQuery.expr.filters){tQuery.expr.filters.hidden=function(elem){var width=elem.offsetWidth,height=elem.offsetHeight;return(width===0&&height===0)||(!tQuery.support.reliableHiddenOffsets&&(elem.style.display||tQuery.css(elem,"display"))==="none");};tQuery.expr.filters.visible=function(elem){return !tQuery.expr.filters.hidden(elem);};}var r20=/%20/g,rbracket=/\[\]$/,rCRLF=/\r?\n/g,rhash=/#.*$/,rheaders=/^(.*?):\s*(.*?)\r?$/mg,rinput=/^(?:color|date|datetime|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,rquery=/\?/,rscript=/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,rselectTextarea=/^(?:select|textarea)/i,rspacesAjax=/\s+/,rts=/([?&])_=[^&]*/,rurl=/^(\w+:)\/\/([^\/?#:]+)(?::(\d+))?/,_load=tQuery.fn.load,prefilters={},transports={};function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*";}if(tQuery.isFunction(func)){var dataTypes=dataTypeExpression.toLowerCase().split(rspacesAjax),i=0,length=dataTypes.length,dataType,list,placeBefore;for(;i<length;i++){dataType=dataTypes[i];placeBefore=/^\+/.test(dataType);if(placeBefore){dataType=dataType.substr(1)||"*";}list=structure[dataType]=structure[dataType]||[];list[placeBefore?"unshift":"push"](func);}}};}function inspectPrefiltersOrTransports(structure,options,originalOptions,jXHR,dataType,inspected){dataType=dataType||options.dataTypes[0];inspected=inspected||{};inspected[dataType]=true;var list=structure[dataType],i=0,length=list?list.length:0,executeOnly=(structure===prefilters),selection;for(;i<length&&(executeOnly||!selection);i++){selection=list[i](options,originalOptions,jXHR);if(typeof selection==="string"){if(inspected[selection]){selection=undefined;}else{options.dataTypes.unshift(selection);selection=inspectPrefiltersOrTransports(structure,options,originalOptions,jXHR,selection,inspected);}}}if((executeOnly||!selection)&&!inspected["*"]){selection=inspectPrefiltersOrTransports(structure,options,originalOptions,jXHR,"*",inspected);}return selection;}tQuery.fn.extend({load:function(url,params,callback){if(typeof url!=="string"&&_load){return _load.apply(this,arguments);}else{if(!this.length){return this;}}var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off);}var type="GET";if(params){if(tQuery.isFunction(params)){callback=params;params=null;}else{if(typeof params==="object"){params=tQuery.param(params,tQuery.ajaxSettings.traditional);type="POST";}}}var self=this;tQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(jXHR,status,responseText){responseText=jXHR.responseText;if(jXHR.isResolved()){jXHR.done(function(r){responseText=r;});self.html(selector?tQuery("<div>").append(responseText.replace(rscript,"")).find(selector):responseText);}if(callback){self.each(callback,[responseText,status,jXHR]);}}});return this;},serialize:function(){return tQuery.param(this.serializeArray());},serializeArray:function(){return this.map(function(){return this.elements?tQuery.makeArray(this.elements):this;}).filter(function(){return this.name&&!this.disabled&&(this.checked||rselectTextarea.test(this.nodeName)||rinput.test(this.type));}).map(function(i,elem){var val=tQuery(this).val();return val==null?null:tQuery.isArray(val)?tQuery.map(val,function(val,i){return{name:elem.name,value:val.replace(rCRLF,"\r\n")};}):{name:elem.name,value:val.replace(rCRLF,"\r\n")};}).get();}});tQuery.each("ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split(" "),function(i,o){tQuery.fn[o]=function(f){return this.bind(o,f);};});tQuery.each(["get","post"],function(i,method){tQuery[method]=function(url,data,callback,type){if(tQuery.isFunction(data)){type=type||callback;callback=data;data=null;}return tQuery.ajax({type:method,url:url,data:data,success:callback,dataType:type});};});tQuery.extend({getScript:function(url,callback){return tQuery.get(url,null,callback,"script");},getJSON:function(url,data,callback){return tQuery.get(url,data,callback,"json");},ajaxSetup:function(settings){tQuery.extend(true,tQuery.ajaxSettings,settings);if(settings.context){tQuery.ajaxSettings.context=settings.context;}},ajaxSettings:{url:location.href,global:true,type:"GET",contentType:"application/x-www-form-urlencoded",processData:true,async:true,accepts:{xml:"application/xml, text/xml",html:"text/html",text:"text/plain",json:"application/json, text/javascript","*":"*/*"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText"},converters:{"* text":window.String,"text html":true,"text json":tQuery.parseJSON,"text xml":tQuery.parseXML}},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof options!=="object"){options=url;url=undefined;}options=options||{};var s=tQuery.extend(true,{},tQuery.ajaxSettings,options),callbackContext=(s.context=("context" in options?options:tQuery.ajaxSettings).context)||s,globalEventContext=callbackContext===s?tQuery.event:tQuery(callbackContext),deferred=tQuery.Deferred(),completeDeferred=tQuery._Deferred(),statusCode=s.statusCode||{},requestHeaders={},responseHeadersString,responseHeaders,transport,timeoutTimer,loc=document.location,protocol=loc.protocol||"http:",parts,state=0,i,jXHR={readyState:0,setRequestHeader:function(name,value){if(state===0){requestHeaders[name.toLowerCase()]=value;}return this;},getAllResponseHeaders:function(){return state===2?responseHeadersString:null;},getResponseHeader:function(key){var match;if(state===2){if(!responseHeaders){responseHeaders={};while((match=rheaders.exec(responseHeadersString))){responseHeaders[match[1].toLowerCase()]=match[2];}}match=responseHeaders[key.toLowerCase()];}return match||null;},abort:function(statusText){statusText=statusText||"abort";if(transport){transport.abort(statusText);}done(0,statusText);return this;}};function done(status,statusText,responses,headers){if(state===2){return;}state=2;if(timeoutTimer){clearTimeout(timeoutTimer);}transport=undefined;responseHeadersString=headers||"";jXHR.readyState=status?4:0;var isSuccess,success,error,response=responses?ajaxHandleResponses(s,jXHR,responses):undefined,lastModified,etag;if(status>=200&&status<300||status===304){if(s.ifModified){if((lastModified=jXHR.getResponseHeader("Last-Modified"))){tQuery.lastModified[s.url]=lastModified;}if((etag=jXHR.getResponseHeader("Etag"))){tQuery.etag[s.url]=etag;}}if(status===304){statusText="notmodified";isSuccess=true;}else{try{success=ajaxConvert(s,response);statusText="success";isSuccess=true;}catch(e){statusText="parsererror";error=e;}}}else{error=statusText;if(status){statusText="error";if(status<0){status=0;}}}jXHR.status=status;jXHR.statusText=statusText;if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jXHR]);}else{deferred.rejectWith(callbackContext,[jXHR,statusText,error]);}jXHR.statusCode(statusCode);statusCode=undefined;if(s.global){globalEventContext.trigger("ajax"+(isSuccess?"Success":"Error"),[jXHR,s,isSuccess?success:error]);}completeDeferred.resolveWith(callbackContext,[jXHR,statusText]);if(s.global){globalEventContext.trigger("ajaxComplete",[jXHR,s]);if(!(--tQuery.active)){tQuery.event.trigger("ajaxStop");}}}deferred.promise(jXHR);jXHR.success=jXHR.done;jXHR.error=jXHR.fail;jXHR.complete=completeDeferred.done;jXHR.statusCode=function(map){if(map){var tmp;if(state<2){for(tmp in map){statusCode[tmp]=[statusCode[tmp],map[tmp]];}}else{tmp=map[jXHR.status];jXHR.then(tmp,tmp);}}return this;};s.url=(""+(url||s.url)).replace(rhash,"").replace(rprotocol,protocol+"//");s.dataTypes=tQuery.trim(s.dataType||"*").toLowerCase().split(rspacesAjax);if(!s.crossDomain){parts=rurl.exec(s.url.toLowerCase());s.crossDomain=!!(parts&&(parts[1]!=protocol||parts[2]!=loc.hostname||(parts[3]||(parts[1]==="http:"?80:443))!=(loc.port||(protocol==="http:"?80:443))));}if(s.data&&s.processData&&typeof s.data!=="string"){s.data=tQuery.param(s.data,s.traditional);}inspectPrefiltersOrTransports(prefilters,s,options,jXHR);s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);if(s.global&&tQuery.active++===0){tQuery.event.trigger("ajaxStart");}if(!s.hasContent){if(s.data){s.url+=(rquery.test(s.url)?"&":"?")+s.data;}if(s.cache===false){var ts=tQuery.now(),ret=s.url.replace(rts,"$1_="+ts);s.url=ret+((ret===s.url)?(rquery.test(s.url)?"&":"?")+"_="+ts:"");}}if(s.data&&s.hasContent&&s.contentType!==false||options.contentType){requestHeaders["content-type"]=s.contentType;}if(s.ifModified){if(tQuery.lastModified[s.url]){requestHeaders["if-modified-since"]=tQuery.lastModified[s.url];}if(tQuery.etag[s.url]){requestHeaders["if-none-match"]=tQuery.etag[s.url];}}requestHeaders.accept=s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+(s.dataTypes[0]!=="*"?", */*; q=0.01":""):s.accepts["*"];for(i in s.headers){requestHeaders[i.toLowerCase()]=s.headers[i];}if(s.beforeSend&&(s.beforeSend.call(callbackContext,jXHR,s)===false||state===2)){done(0,"abort");jXHR=false;}else{for(i in {success:1,error:1,complete:1}){jXHR[i](s[i]);}transport=inspectPrefiltersOrTransports(transports,s,options,jXHR);if(!transport){done(-1,"No Transport");}else{state=jXHR.readyState=1;if(s.global){globalEventContext.trigger("ajaxSend",[jXHR,s]);}if(s.async&&s.timeout>0){timeoutTimer=setTimeout(function(){jXHR.abort("timeout");},s.timeout);}try{transport.send(requestHeaders,done);}catch(e){if(status<2){done(-1,e);}else{tQuery.error(e);}}}}return jXHR;},param:function(a,traditional){var s=[],add=function(key,value){value=tQuery.isFunction(value)?value():value;s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value);};if(traditional===undefined){traditional=tQuery.ajaxSettings.traditional;}if(tQuery.isArray(a)||a.tQuery){tQuery.each(a,function(){add(this.name,this.value);});}else{for(var prefix in a){buildParams(prefix,a[prefix],traditional,add);}}return s.join("&").replace(r20,"+");}});function buildParams(prefix,obj,traditional,add){if(tQuery.isArray(obj)&&obj.length){tQuery.each(obj,function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v);}else{buildParams(prefix+"["+(typeof v==="object"||tQuery.isArray(v)?i:"")+"]",v,traditional,add);}});}else{if(!traditional&&obj!=null&&typeof obj==="object"){if(tQuery.isArray(obj)||tQuery.isEmptyObject(obj)){add(prefix,"");}else{tQuery.each(obj,function(k,v){buildParams(prefix+"["+k+"]",v,traditional,add);});}}else{add(prefix,obj);}}}tQuery.extend({active:0,lastModified:{},etag:{}});function ajaxHandleResponses(s,jXHR,responses){var contents=s.contents,dataTypes=s.dataTypes,responseFields=s.responseFields,ct,type,finalDataType,firstDataType;for(type in responseFields){if(type in responses){jXHR[responseFields[type]]=responses[type];}}while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=jXHR.getResponseHeader("content-type");}}if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break;}}}if(dataTypes[0] in responses){finalDataType=dataTypes[0];}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break;}if(!firstDataType){firstDataType=type;}}finalDataType=finalDataType||firstDataType;}if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType);}return responses[finalDataType];}}function ajaxConvert(s,response){if(s.dataFilter){response=s.dataFilter(response,s.dataType);}var dataTypes=s.dataTypes,converters=s.converters,i,length=dataTypes.length,tmp,current=dataTypes[0],prev,conversion,conv,conv1,conv2;for(i=1;i<length;i++){prev=current;current=dataTypes[i];if(current==="*"){current=prev;}else{if(prev!=="*"&&prev!==current){conversion=prev+" "+current;conv=converters[conversion]||converters["* "+current];if(!conv){conv2=undefined;for(conv1 in converters){tmp=conv1.split(" ");if(tmp[0]===prev||tmp[0]==="*"){conv2=converters[tmp[1]+" "+current];if(conv2){conv1=converters[conv1];if(conv1===true){conv=conv2;}else{if(conv2===true){conv=conv1;}}break;}}}}if(!(conv||conv2)){tQuery.error("No conversion from "+conversion.replace(" "," to "));}if(conv!==true){response=conv?conv(response):conv2(conv1(response));}}}}return response;}var jsc=tQuery.now(),jsre=/(\=)\?(&|$)|()\?\?()/i;tQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){return tQuery.expando+"_"+(jsc++);}});tQuery.ajaxPrefilter("json jsonp",function(s,originalSettings,dataIsString){dataIsString=(typeof s.data==="string");if(s.dataTypes[0]==="jsonp"||originalSettings.jsonpCallback||originalSettings.jsonp!=null||s.jsonp!==false&&(jsre.test(s.url)||dataIsString&&jsre.test(s.data))){var responseContainer,jsonpCallback=s.jsonpCallback=tQuery.isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback,previous=window[jsonpCallback],url=s.url,data=s.data,replace="$1"+jsonpCallback+"$2";if(s.jsonp!==false){url=url.replace(jsre,replace);if(s.url===url){if(dataIsString){data=data.replace(jsre,replace);}if(s.data===data){url+=(/\?/.test(url)?"&":"?")+s.jsonp+"="+jsonpCallback;}}}s.url=url;s.data=data;window[jsonpCallback]=function(response){responseContainer=[response];};s.complete=[function(){window[jsonpCallback]=previous;if(previous){if(responseContainer&&tQuery.isFunction(previous)){window[jsonpCallback](responseContainer[0]);}}else{try{delete window[jsonpCallback];}catch(e){}}},s.complete];s.converters["script json"]=function(){if(!responseContainer){tQuery.error(jsonpCallback+" was not called");}return responseContainer[0];};s.dataTypes[0]="json";return"script";}});tQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript"},contents:{script:/javascript/},converters:{"text script":function(text){tQuery.globalEval(text);return text;}}});tQuery.ajaxPrefilter("script",function(s){if(s.cache===undefined){s.cache=false;}if(s.crossDomain){s.type="GET";s.global=false;}});tQuery.ajaxTransport("script",function(s){if(s.crossDomain){var script,head=document.getElementsByTagName("head")[0]||document.documentElement;return{send:function(_,callback){script=document.createElement("script");script.async="async";if(s.scriptCharset){script.charset=s.scriptCharset;}script.src=s.url;script.onload=script.onreadystatechange=function(_,isAbort){if(!script.readyState||/loaded|complete/.test(script.readyState)){script.onload=script.onreadystatechange=null;if(head&&script.parentNode){head.removeChild(script);}script=undefined;if(!isAbort){callback(200,"success");}}};head.insertBefore(script,head.firstChild);},abort:function(){if(script){script.onload(0,1);}}};}});var xhrId=tQuery.now(),xhrs={},xhrUnloadAbortInstalled,testXHR;tQuery.ajaxSettings.xhr=window.ActiveXObject?function(){if(window.location.protocol!=="file:"){try{return new window.XMLHttpRequest();}catch(xhrError){}}try{return new window.ActiveXObject("Microsoft.XMLHTTP");}catch(activeError){}}:function(){return new window.XMLHttpRequest();};try{testXHR=tQuery.ajaxSettings.xhr();}catch(xhrCreationException){}tQuery.support.ajax=!!testXHR;tQuery.support.cors=testXHR&&("withCredentials" in testXHR);testXHR=undefined;if(tQuery.support.ajax){tQuery.ajaxTransport(function(s){if(!s.crossDomain||tQuery.support.cors){var callback;return{send:function(headers,complete){if(!xhrUnloadAbortInstalled){xhrUnloadAbortInstalled=1;tQuery(window).bind("unload",function(){tQuery.each(xhrs,function(_,xhr){if(xhr.onreadystatechange){xhr.onreadystatechange(1);}});});}var xhr=s.xhr(),handle;if(s.username){xhr.open(s.type,s.url,s.async,s.username,s.password);}else{xhr.open(s.type,s.url,s.async);}if(!(s.crossDomain&&!s.hasContent)&&!headers["x-requested-with"]){headers["x-requested-with"]="XMLHttpRequest";}try{tQuery.each(headers,function(key,value){xhr.setRequestHeader(key,value);});}catch(_){}xhr.send((s.hasContent&&s.data)||null);callback=function(_,isAbort){if(callback&&(isAbort||xhr.readyState===4)){callback=0;if(handle){xhr.onreadystatechange=tQuery.noop;delete xhrs[handle];}if(isAbort){if(xhr.readyState!==4){xhr.abort();}}else{var status=xhr.status,statusText,responseHeaders=xhr.getAllResponseHeaders(),responses={},xml=xhr.responseXML;if(xml&&xml.documentElement){responses.xml=xml;}responses.text=xhr.responseText;try{statusText=xhr.statusText;}catch(e){statusText="";}status=status===0?(!s.crossDomain||statusText?(responseHeaders?304:0):302):(status==1223?204:status);complete(status,statusText,responses,responseHeaders);}}};if(!s.async||xhr.readyState===4){callback();}else{handle=xhrId++;xhrs[handle]=xhr;xhr.onreadystatechange=callback;}},abort:function(){if(callback){callback(0,1);}}};}});}var elemdisplay={},rfxtypes=/^(?:toggle|show|hide)$/,rfxnum=/^([+\-]=)?([\d+.\-]+)([a-z%]*)$/i,timerId,fxAttrs=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]];tQuery.fn.extend({show:function(speed,easing,callback){var elem,display;if(speed||speed===0){return this.animate(genFx("show",3),speed,easing,callback);}else{for(var i=0,j=this.length;i<j;i++){elem=this[i];display=elem.style.display;if(!tQuery._data(elem,"olddisplay")&&display==="none"){display=elem.style.display="";}if(display===""&&tQuery.css(elem,"display")==="none"){tQuery._data(elem,"olddisplay",defaultDisplay(elem.nodeName));}}for(i=0;i<j;i++){elem=this[i];display=elem.style.display;if(display===""||display==="none"){elem.style.display=tQuery._data(elem,"olddisplay")||"";}}return this;}},hide:function(speed,easing,callback){if(speed||speed===0){return this.animate(genFx("hide",3),speed,easing,callback);}else{for(var i=0,j=this.length;i<j;i++){var display=tQuery.css(this[i],"display");if(display!=="none"&&!tQuery._data(this[i],"olddisplay")){tQuery._data(this[i],"olddisplay",display);}}for(i=0;i<j;i++){this[i].style.display="none";}return this;}},_toggle:tQuery.fn.toggle,toggle:function(fn,fn2,callback){var bool=typeof fn==="boolean";if(tQuery.isFunction(fn)&&tQuery.isFunction(fn2)){this._toggle.apply(this,arguments);}else{if(fn==null||bool){this.each(function(){var state=bool?fn:tQuery(this).is(":hidden");tQuery(this)[state?"show":"hide"]();});}else{this.animate(genFx("toggle",3),fn,fn2,callback);}}return this;},fadeTo:function(speed,to,easing,callback){return this.filter(":hidden").css("opacity",0).show().end().animate({opacity:to},speed,easing,callback);},animate:function(prop,speed,easing,callback){var optall=tQuery.speed(speed,easing,callback);if(tQuery.isEmptyObject(prop)){return this.each(optall.complete);}return this[optall.queue===false?"each":"queue"](function(){var opt=tQuery.extend({},optall),p,isElement=this.nodeType===1,hidden=isElement&&tQuery(this).is(":hidden"),self=this;for(p in prop){var name=tQuery.camelCase(p);if(p!==name){prop[name]=prop[p];delete prop[p];p=name;}if(prop[p]==="hide"&&hidden||prop[p]==="show"&&!hidden){return opt.complete.call(this);}if(isElement&&(p==="height"||p==="width")){opt.overflow=[this.style.overflow,this.style.overflowX,this.style.overflowY];if(tQuery.css(this,"display")==="inline"&&tQuery.css(this,"float")==="none"){if(!tQuery.support.inlineBlockNeedsLayout){this.style.display="inline-block";}else{var display=defaultDisplay(this.nodeName);if(display==="inline"){this.style.display="inline-block";}else{this.style.display="inline";this.style.zoom=1;}}}}if(tQuery.isArray(prop[p])){(opt.specialEasing=opt.specialEasing||{})[p]=prop[p][1];prop[p]=prop[p][0];}}if(opt.overflow!=null){this.style.overflow="hidden";}opt.curAnim=tQuery.extend({},prop);tQuery.each(prop,function(name,val){var e=new tQuery.fx(self,opt,name);if(rfxtypes.test(val)){e[val==="toggle"?hidden?"show":"hide":val](prop);}else{var parts=rfxnum.exec(val),start=e.cur()||0;if(parts){var end=parseFloat(parts[2]),unit=parts[3]||"px";if(unit!=="px"){tQuery.style(self,name,(end||1)+unit);start=((end||1)/e.cur())*start;tQuery.style(self,name,start+unit);}if(parts[1]){end=((parts[1]==="-="?-1:1)*end)+start;}e.custom(start,end,unit);}else{e.custom(start,val,"");}}});return true;});},stop:function(clearQueue,gotoEnd){var timers=tQuery.timers;if(clearQueue){this.queue([]);}this.each(function(){for(var i=timers.length-1;i>=0;i--){if(timers[i].elem===this){if(gotoEnd){timers[i](true);}timers.splice(i,1);}}});if(!gotoEnd){this.dequeue();}return this;}});function genFx(type,num){var obj={};tQuery.each(fxAttrs.concat.apply([],fxAttrs.slice(0,num)),function(){obj[this]=type;});return obj;}tQuery.each({slideDown:genFx("show",1),slideUp:genFx("hide",1),slideToggle:genFx("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(name,props){tQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback);};});tQuery.extend({speed:function(speed,easing,fn){var opt=speed&&typeof speed==="object"?tQuery.extend({},speed):{complete:fn||!fn&&easing||tQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!tQuery.isFunction(easing)&&easing};opt.duration=tQuery.fx.off?0:typeof opt.duration==="number"?opt.duration:opt.duration in tQuery.fx.speeds?tQuery.fx.speeds[opt.duration]:tQuery.fx.speeds._default;opt.old=opt.complete;opt.complete=function(){if(opt.queue!==false){tQuery(this).dequeue();}if(tQuery.isFunction(opt.old)){opt.old.call(this);}};return opt;},easing:{linear:function(p,n,firstNum,diff){return firstNum+diff*p;},swing:function(p,n,firstNum,diff){return((-Math.cos(p*Math.PI)/2)+0.5)*diff+firstNum;}},timers:[],fx:function(elem,options,prop){this.options=options;this.elem=elem;this.prop=prop;if(!options.orig){options.orig={};}}});tQuery.fx.prototype={update:function(){if(this.options.step){this.options.step.call(this.elem,this.now,this);}(tQuery.fx.step[this.prop]||tQuery.fx.step._default)(this);},cur:function(){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null)){return this.elem[this.prop];}var r=parseFloat(tQuery.css(this.elem,this.prop));return r||0;},custom:function(from,to,unit){var self=this,fx=tQuery.fx;this.startTime=tQuery.now();this.start=from;this.end=to;this.unit=unit||this.unit||"px";this.now=this.start;this.pos=this.state=0;function t(gotoEnd){return self.step(gotoEnd);}t.elem=this.elem;if(t()&&tQuery.timers.push(t)&&!timerId){timerId=setInterval(fx.tick,fx.interval);}},show:function(){this.options.orig[this.prop]=tQuery.style(this.elem,this.prop);this.options.show=true;this.custom(this.prop==="width"||this.prop==="height"?1:0,this.cur());tQuery(this.elem).show();},hide:function(){this.options.orig[this.prop]=tQuery.style(this.elem,this.prop);this.options.hide=true;this.custom(this.cur(),0);},step:function(gotoEnd){var t=tQuery.now(),done=true;if(gotoEnd||t>=this.options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();this.options.curAnim[this.prop]=true;for(var i in this.options.curAnim){if(this.options.curAnim[i]!==true){done=false;}}if(done){if(this.options.overflow!=null&&!tQuery.support.shrinkWrapBlocks){var elem=this.elem,options=this.options;tQuery.each(["","X","Y"],function(index,value){elem.style["overflow"+value]=options.overflow[index];});}if(this.options.hide){tQuery(this.elem).hide();}if(this.options.hide||this.options.show){for(var p in this.options.curAnim){tQuery.style(this.elem,p,this.options.orig[p]);}}this.options.complete.call(this.elem);}return false;}else{var n=t-this.startTime;this.state=n/this.options.duration;var specialEasing=this.options.specialEasing&&this.options.specialEasing[this.prop];var defaultEasing=this.options.easing||(tQuery.easing.swing?"swing":"linear");this.pos=tQuery.easing[specialEasing||defaultEasing](this.state,n,0,1,this.options.duration);this.now=this.start+((this.end-this.start)*this.pos);this.update();}return true;}};tQuery.extend(tQuery.fx,{tick:function(){var timers=tQuery.timers;for(var i=0;i<timers.length;i++){if(!timers[i]()){timers.splice(i--,1);}}if(!timers.length){tQuery.fx.stop();}},interval:13,stop:function(){clearInterval(timerId);timerId=null;},speeds:{slow:600,fast:200,_default:400},step:{opacity:function(fx){tQuery.style(fx.elem,"opacity",fx.now);},_default:function(fx){if(fx.elem.style&&fx.elem.style[fx.prop]!=null){fx.elem.style[fx.prop]=(fx.prop==="width"||fx.prop==="height"?Math.max(0,fx.now):fx.now)+fx.unit;}else{fx.elem[fx.prop]=fx.now;}}}});if(tQuery.expr&&tQuery.expr.filters){tQuery.expr.filters.animated=function(elem){return tQuery.grep(tQuery.timers,function(fn){return elem===fn.elem;}).length;};}function defaultDisplay(nodeName){if(!elemdisplay[nodeName]){var elem=tQuery("<"+nodeName+">").appendTo("body"),display=elem.css("display");elem.remove();if(display==="none"||display===""){display="block";}elemdisplay[nodeName]=display;}return elemdisplay[nodeName];}var rtable=/^t(?:able|d|h)$/i,rroot=/^(?:body|html)$/i;if("getBoundingClientRect" in document.documentElement){tQuery.fn.offset=function(options){var elem=this[0],box;if(options){return this.each(function(i){tQuery.offset.setOffset(this,options,i);});}if(!elem||!elem.ownerDocument){return null;}if(elem===elem.ownerDocument.body){return tQuery.offset.bodyOffset(elem);}try{box=elem.getBoundingClientRect();}catch(e){}var doc=elem.ownerDocument,docElem=doc.documentElement;if(!box||!tQuery.contains(docElem,elem)){return box?{top:box.top,left:box.left}:{top:0,left:0};}var body=doc.body,win=getWindow(doc),clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,scrollTop=(win.pageYOffset||tQuery.support.boxModel&&docElem.scrollTop||body.scrollTop),scrollLeft=(win.pageXOffset||tQuery.support.boxModel&&docElem.scrollLeft||body.scrollLeft),top=box.top+scrollTop-clientTop,left=box.left+scrollLeft-clientLeft;return{top:top,left:left};};}else{tQuery.fn.offset=function(options){var elem=this[0];if(options){return this.each(function(i){tQuery.offset.setOffset(this,options,i);});}if(!elem||!elem.ownerDocument){return null;}if(elem===elem.ownerDocument.body){return tQuery.offset.bodyOffset(elem);}tQuery.offset.initialize();var computedStyle,offsetParent=elem.offsetParent,prevOffsetParent=elem,doc=elem.ownerDocument,docElem=doc.documentElement,body=doc.body,defaultView=doc.defaultView,prevComputedStyle=defaultView?defaultView.getComputedStyle(elem,null):elem.currentStyle,top=elem.offsetTop,left=elem.offsetLeft;while((elem=elem.parentNode)&&elem!==body&&elem!==docElem){if(tQuery.offset.supportsFixedPosition&&prevComputedStyle.position==="fixed"){break;}computedStyle=defaultView?defaultView.getComputedStyle(elem,null):elem.currentStyle;top-=elem.scrollTop;left-=elem.scrollLeft;if(elem===offsetParent){top+=elem.offsetTop;left+=elem.offsetLeft;if(tQuery.offset.doesNotAddBorder&&!(tQuery.offset.doesAddBorderForTableAndCells&&rtable.test(elem.nodeName))){top+=parseFloat(computedStyle.borderTopWidth)||0;left+=parseFloat(computedStyle.borderLeftWidth)||0;}prevOffsetParent=offsetParent;offsetParent=elem.offsetParent;}if(tQuery.offset.subtractsBorderForOverflowNotVisible&&computedStyle.overflow!=="visible"){top+=parseFloat(computedStyle.borderTopWidth)||0;left+=parseFloat(computedStyle.borderLeftWidth)||0;}prevComputedStyle=computedStyle;}if(prevComputedStyle.position==="relative"||prevComputedStyle.position==="static"){top+=body.offsetTop;left+=body.offsetLeft;}if(tQuery.offset.supportsFixedPosition&&prevComputedStyle.position==="fixed"){top+=Math.max(docElem.scrollTop,body.scrollTop);left+=Math.max(docElem.scrollLeft,body.scrollLeft);}return{top:top,left:left};};}tQuery.offset={initialize:function(){var body=document.body,container=document.createElement("div"),innerDiv,checkDiv,table,td,bodyMarginTop=parseFloat(tQuery.css(body,"marginTop"))||0,html="<div style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;'><div></div></div><table style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;' cellpadding='0' cellspacing='0'><tr><td></td></tr></table>";tQuery.extend(container.style,{position:"absolute",top:0,left:0,margin:0,border:0,width:"1px",height:"1px",visibility:"hidden"});container.innerHTML=html;body.insertBefore(container,body.firstChild);innerDiv=container.firstChild;checkDiv=innerDiv.firstChild;td=innerDiv.nextSibling.firstChild.firstChild;this.doesNotAddBorder=(checkDiv.offsetTop!==5);this.doesAddBorderForTableAndCells=(td.offsetTop===5);checkDiv.style.position="fixed";checkDiv.style.top="20px";this.supportsFixedPosition=(checkDiv.offsetTop===20||checkDiv.offsetTop===15);checkDiv.style.position=checkDiv.style.top="";innerDiv.style.overflow="hidden";innerDiv.style.position="relative";this.subtractsBorderForOverflowNotVisible=(checkDiv.offsetTop===-5);this.doesNotIncludeMarginInBodyOffset=(body.offsetTop!==bodyMarginTop);body.removeChild(container);body=container=innerDiv=checkDiv=table=td=null;tQuery.offset.initialize=tQuery.noop;},bodyOffset:function(body){var top=body.offsetTop,left=body.offsetLeft;tQuery.offset.initialize();if(tQuery.offset.doesNotIncludeMarginInBodyOffset){top+=parseFloat(tQuery.css(body,"marginTop"))||0;left+=parseFloat(tQuery.css(body,"marginLeft"))||0;}return{top:top,left:left};},setOffset:function(elem,options,i){var position=tQuery.css(elem,"position");if(position==="static"){elem.style.position="relative";}var curElem=tQuery(elem),curOffset=curElem.offset(),curCSSTop=tQuery.css(elem,"top"),curCSSLeft=tQuery.css(elem,"left"),calculatePosition=(position==="absolute"&&tQuery.inArray("auto",[curCSSTop,curCSSLeft])>-1),props={},curPosition={},curTop,curLeft;if(calculatePosition){curPosition=curElem.position();}curTop=calculatePosition?curPosition.top:parseInt(curCSSTop,10)||0;curLeft=calculatePosition?curPosition.left:parseInt(curCSSLeft,10)||0;if(tQuery.isFunction(options)){options=options.call(elem,i,curOffset);}if(options.top!=null){props.top=(options.top-curOffset.top)+curTop;}if(options.left!=null){props.left=(options.left-curOffset.left)+curLeft;}if("using" in options){options.using.call(elem,props);}else{curElem.css(props);}}};tQuery.fn.extend({position:function(){if(!this[0]){return null;}var elem=this[0],offsetParent=this.offsetParent(),offset=this.offset(),parentOffset=rroot.test(offsetParent[0].nodeName)?{top:0,left:0}:offsetParent.offset();offset.top-=parseFloat(tQuery.css(elem,"marginTop"))||0;offset.left-=parseFloat(tQuery.css(elem,"marginLeft"))||0;parentOffset.top+=parseFloat(tQuery.css(offsetParent[0],"borderTopWidth"))||0;parentOffset.left+=parseFloat(tQuery.css(offsetParent[0],"borderLeftWidth"))||0;return{top:offset.top-parentOffset.top,left:offset.left-parentOffset.left};},offsetParent:function(){return this.map(function(){var offsetParent=this.offsetParent||document.body;while(offsetParent&&(!rroot.test(offsetParent.nodeName)&&tQuery.css(offsetParent,"position")==="static")){offsetParent=offsetParent.offsetParent;}return offsetParent;});}});tQuery.each(["Left","Top"],function(i,name){var method="scroll"+name;tQuery.fn[method]=function(val){var elem=this[0],win;if(!elem){return null;}if(val!==undefined){return this.each(function(){win=getWindow(this);if(win){win.scrollTo(!i?val:tQuery(win).scrollLeft(),i?val:tQuery(win).scrollTop());}else{this[method]=val;}});}else{win=getWindow(elem);return win?("pageXOffset" in win)?win[i?"pageYOffset":"pageXOffset"]:tQuery.support.boxModel&&win.document.documentElement[method]||win.document.body[method]:elem[method];}};});function getWindow(elem){return tQuery.isWindow(elem)?elem:elem.nodeType===9?elem.defaultView||elem.parentWindow:false;}tQuery.each(["Height","Width"],function(i,name){var type=name.toLowerCase();tQuery.fn["inner"+name]=function(){return this[0]?parseFloat(tQuery.css(this[0],type,"padding")):null;};tQuery.fn["outer"+name]=function(margin){return this[0]?parseFloat(tQuery.css(this[0],type,margin?"margin":"border")):null;};tQuery.fn[type]=function(size){var elem=this[0];if(!elem){return size==null?null:this;}if(tQuery.isFunction(size)){return this.each(function(i){var self=tQuery(this);self[type](size.call(this,i,self[type]()));});}if(tQuery.isWindow(elem)){var docElemProp=elem.document.documentElement["client"+name];return elem.document.compatMode==="CSS1Compat"&&docElemProp||elem.document.body["client"+name]||docElemProp;}else{if(elem.nodeType===9){return Math.max(elem.documentElement["client"+name],elem.body["scroll"+name],elem.documentElement["scroll"+name],elem.body["offset"+name],elem.documentElement["offset"+name]);}else{if(size===undefined){var orig=tQuery.css(elem,type),ret=parseFloat(orig);return tQuery.isNaN(ret)?orig:ret;}else{return this.css(type,typeof size==="string"?size:size+"px");}}}};});})(window);