/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.evaluator.selenium;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.Wait;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.testatoo.cartridge.html4.Bootstraper;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.EvaluatorException;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.cartridge.html4.component.ListBox;
import org.testatoo.cartridge.html4.element.Area;
import org.testatoo.cartridge.html4.element.Attribute;
import org.testatoo.cartridge.html4.element.Caption;
import org.testatoo.cartridge.html4.element.Col;
import org.testatoo.cartridge.html4.element.Colgroup;
import org.testatoo.cartridge.html4.element.Form;
import org.testatoo.cartridge.html4.element.HtmlElementType;
import org.testatoo.cartridge.html4.element.Option;
import org.testatoo.cartridge.html4.element.OptionGroup;
import org.testatoo.cartridge.html4.element.Param;
import org.testatoo.cartridge.html4.element.Select;
import org.testatoo.cartridge.html4.element.TBody;
import org.testatoo.cartridge.html4.element.TFoot;
import org.testatoo.cartridge.html4.element.THead;
import org.testatoo.cartridge.html4.element.Table;
import org.testatoo.cartridge.html4.element.Td;
import org.testatoo.cartridge.html4.element.Th;
import org.testatoo.cartridge.html4.element.Tr;
import org.testatoo.core.AbstractEvaluator;
import org.testatoo.core.ComponentType;
import org.testatoo.core.Evaluator;
import org.testatoo.core.ListSelection;
import org.testatoo.core.Selection;
import org.testatoo.core.component.AbstractTextField;
import org.testatoo.core.component.AbstractWindow;
import org.testatoo.core.component.AlertBox;
import org.testatoo.core.component.Button;
import org.testatoo.core.component.CheckBox;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.DialogBox;
import org.testatoo.core.component.FileDialog;
import org.testatoo.core.component.Image;
import org.testatoo.core.component.Link;
import org.testatoo.core.component.ListModel;
import org.testatoo.core.component.Page;
import org.testatoo.core.component.Prompt;
import org.testatoo.core.component.datagrid.Cell;
import org.testatoo.core.component.datagrid.CellContainer;
import org.testatoo.core.component.datagrid.Column;
import org.testatoo.core.component.datagrid.DataGrid;
import org.testatoo.core.component.datagrid.Row;
import org.testatoo.core.input.Click;
import org.testatoo.core.input.Key;
import org.testatoo.core.input.KeyModifier;
import org.testatoo.core.nature.Checkable;
import org.testatoo.core.nature.Container;
import org.testatoo.core.nature.IconSupport;
import org.testatoo.core.nature.LabelSupport;
import org.testatoo.core.nature.TextSupport;
import org.testatoo.core.nature.TitleSupport;
import org.testatoo.core.nature.ValueSupport;

public final class SeleniumHtmlEvaluator
extends AbstractEvaluator<Selenium>
implements HtmlEvaluator {
    private final Selenium selenium;
    private final String name;
    private Component currentFocusedComponent;
    private Map<String, String> alertBoxMessage = new HashMap<String, String>();
    private static final String PAGE_ID = "_PAGE_ID_";

    public SeleniumHtmlEvaluator(String name, Selenium selenium) {
        this.name = name;
        this.selenium = selenium;
    }

    public SeleniumHtmlEvaluator(Selenium selenium) {
        this(DEFAULT_NAME, selenium);
    }

    public Selenium implementation() {
        return this.selenium;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String pageId() {
        return PAGE_ID;
    }

    public Boolean existComponent(String id) {
        if (id.equals(PAGE_ID)) {
            return true;
        }
        if (id.startsWith(org.testatoo.cartridge.html4.element.AlertBox.ID)) {
            this.alertBoxMessage.clear();
            return this.selenium.isAlertPresent();
        }
        return this.selenium.isElementPresent("id=" + id);
    }

    public String text(TextSupport textSupport) {
        Component component = (Component)textSupport;
        String nodeName = this.nodename(component);
        if (nodeName.equalsIgnoreCase("input")) {
            return this.attribute(component.id(), Attribute.value);
        }
        return this.nodeTextContent(component);
    }

    public String icon(IconSupport iconSupport) {
        Component component = (Component)iconSupport;
        String nodeName = this.nodename(component);
        if (nodeName.equalsIgnoreCase("input")) {
            return this.attribute(component.id(), Attribute.src);
        }
        if (nodeName.equalsIgnoreCase("button")) {
            try {
                return this.attribute(this.elementId("jquery:$('#" + component.id() + " img')"), Attribute.src);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public Boolean isVisible(Component component) {
        return component instanceof AbstractWindow || this.selenium.isVisible(component.id());
    }

    public Boolean isEnabled(Component component) {
        return Boolean.valueOf(this.evaluate(this.jQueryExpression("result = $('#" + component.id() + "').is(':disabled');"))) == false && Boolean.valueOf(this.evaluate(this.jQueryExpression("result = $('#" + component.id() + "').attr('readonly') == true;"))) == false;
    }

    public void check(Checkable checkable) {
        if (!checkable.isChecked().booleanValue()) {
            this.click((Component)checkable, Click.left);
        }
    }

    public Boolean isChecked(Checkable checkable) {
        return Boolean.valueOf(this.evaluate(this.jQueryExpression("result = $('#" + ((Component)checkable).id() + "').is(':checked')")));
    }

    public void unCheck(CheckBox checkbox) {
        if (checkbox.isChecked().booleanValue()) {
            this.click((Component)checkbox, Click.left);
        }
    }

    public String value(ValueSupport valueSupport) {
        if (valueSupport instanceof AbstractTextField) {
            return this.selenium.getValue(((Component)valueSupport).id());
        }
        if (valueSupport instanceof Cell) {
            return this.nodeTextContent((Component)valueSupport);
        }
        return this.attribute(((Component)valueSupport).id(), Attribute.value);
    }

    public String source(Image image) {
        return this.attribute(image.id(), Attribute.src);
    }

    public String label(LabelSupport labelSupport) {
        try {
            Component label = new Component((Evaluator)this, By.jQuery("$('label[for=" + ((Component)labelSupport).id() + "]')").id(this));
            return this.nodeTextContent(label);
        }
        catch (EvaluatorException e) {
            try {
                Component label = new Component((Evaluator)this, By.jQuery("$('#" + ((Component)labelSupport).id() + "').parent()").id(this));
                return this.nodeTextContent(label);
            }
            catch (EvaluatorException ex) {
                return "";
            }
        }
    }

    public Integer maxLength(AbstractTextField textfield) {
        if (this.attribute(textfield.id(), Attribute.maxlength).equals("")) {
            return Integer.MAX_VALUE;
        }
        return Integer.valueOf(this.attribute(textfield.id(), Attribute.maxlength));
    }

    public void reset(AbstractTextField textField) {
        this.evaluate(this.jQueryExpression("result = $('#" + textField.id() + "').val('')"));
    }

    public void selectFilePath(String filePath, FileDialog fileDialog) {
        throw new EvaluatorException("Not available for security constraints");
    }

    public String selectedFilePath(FileDialog fileDialog) {
        throw new EvaluatorException("Not available for security constraints");
    }

    public void unselect(String value, ListModel listModel) {
        Select select = this.findEmbeddedSelect(listModel);
        this.selenium.runScript("window.testatoo_tmp = window.tQuery.map(window.tQuery('#" + select.id() + " :selected'), function(e) { return window.tQuery(e).val(); });");
        String[] values = SeleniumHtmlEvaluator.parseCSV(this.evaluate("window.testatoo_tmp"));
        for (Option option : select.options()) {
            List<String> selectedValues = Arrays.asList(values);
            if (!option.value().equals(value) || !selectedValues.contains(option.value())) continue;
            this.evaluate(this.jQueryExpression("result = $('#" + option.id() + "').attr('selected', '')"));
            this.evaluate(this.jQueryExpression("result = $('#" + select.id() + "').simulate('change');"));
        }
        this.waitForCondition();
    }

    public void unselectAll(ListModel listModel) {
        Select select = this.findEmbeddedSelect(listModel);
        this.selenium.runScript("window.testatoo_tmp = window.tQuery.map(window.tQuery('#" + select.id() + " :selected'), function(e) { return window.tQuery(e).val(); });");
        String[] values = SeleniumHtmlEvaluator.parseCSV(this.evaluate("window.testatoo_tmp"));
        for (Option option : select.options()) {
            List<String> selectedValues = Arrays.asList(values);
            if (!selectedValues.contains(option.value())) continue;
            this.evaluate(this.jQueryExpression("result = $('#" + option.id() + "').attr('selected', '')"));
            this.evaluate(this.jQueryExpression("result = $('#" + select.id() + "').simulate('change')"));
        }
        this.waitForCondition();
    }

    public void select(String value, ListModel listModel) {
        Select select = this.findEmbeddedSelect(listModel);
        for (Option option : select.options()) {
            if (!option.value().equals(value)) continue;
            this.evaluate(this.jQueryExpression("result = $('#" + option.id() + "').attr('selected', 'selected');"));
            this.evaluate("if (window.tQuery.browser.msie) {window.tQuery('#" + select.id() + "').simulate('click');} " + "else {window.tQuery('#" + select.id() + "').simulate('change');}");
        }
        this.waitForCondition();
    }

    public Boolean contains(Container container, Component ... component) {
        boolean containsAllElements = true;
        for (Component cmp : component) {
            if (this.selenium.isElementPresent("//*[@id='" + ((Component)container).id() + "']//*[@id='" + cmp.id() + "']")) continue;
            containsAllElements = false;
        }
        return containsAllElements;
    }

    @Override
    public String label(Option option) {
        return this.attribute(option.id(), Attribute.label);
    }

    @Override
    public String label(OptionGroup optionGroup) {
        return this.attribute(optionGroup.id(), Attribute.label);
    }

    @Override
    public Boolean selected(Option option) {
        String id = option.id();
        return this.existComponent(id) != false && (this.attribute(id, Attribute.selected).toLowerCase().equalsIgnoreCase("selected") || this.attribute(id, Attribute.selected).toLowerCase().equals("true"));
    }

    public Boolean hasFocus(Component component) {
        return this.currentFocusedComponent != null && this.currentFocusedComponent.equals((Object)component);
    }

    public String title(TitleSupport titleSupport) {
        if (titleSupport instanceof Page) {
            return this.selenium.getTitle();
        }
        if (titleSupport instanceof FileDialog) {
            return "";
        }
        if (titleSupport instanceof AlertBox || titleSupport instanceof Prompt || titleSupport instanceof DialogBox) {
            this.selenium.isAlertPresent();
            return "";
        }
        if (titleSupport instanceof Column) {
            return this.nodeTextContent((Component)titleSupport);
        }
        return this.attribute(((Component)titleSupport).id(), Attribute.title);
    }

    public String message(AlertBox alertbox) {
        String key = alertbox.id().substring(12);
        if (this.selenium.isAlertPresent()) {
            this.alertBoxMessage.put(key, this.selenium.getAlert());
        }
        return this.alertBoxMessage.get(key) != null ? this.alertBoxMessage.get(key) : "";
    }

    public Selection<Column> columns(DataGrid datagrid) {
        String query = "$('#" + datagrid.id() + " thead tr:last th')";
        int numberOfColumns = Integer.valueOf(this.evaluate(this.jQueryExpression("result = " + query + ".length")));
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int rowNum = 0; rowNum < numberOfColumns; ++rowNum) {
            Column column = new Column((Evaluator)this, this.elementId("jquery:$(" + query + "[" + rowNum + "])"));
            columns.add(column);
        }
        return ListSelection.from(columns);
    }

    public Selection<Row> rows(DataGrid datagrid) {
        ArrayList<Row> rows = new ArrayList<Row>();
        String query = "$('#" + datagrid.id() + " tbody tr')";
        int numberOfRows = Integer.valueOf(this.evaluate(this.jQueryExpression("result = " + query + ".length")));
        for (int rowNum = 0; rowNum < numberOfRows; ++rowNum) {
            Row row = new Row((Evaluator)this, this.elementId("jquery:$(" + query + "[" + rowNum + "])"));
            rows.add(row);
        }
        return ListSelection.from(rows);
    }

    public Selection<Cell> cells(CellContainer cellContainer) {
        String query;
        ArrayList<Cell> cells = new ArrayList<Cell>();
        if (cellContainer instanceof Row) {
            query = "$('#" + ((Component)cellContainer).id() + " td')";
            int numberOfCells = Integer.valueOf(this.evaluate(this.jQueryExpression("result = " + query + ".length")));
            for (int cellNum = 0; cellNum < numberOfCells; ++cellNum) {
                Cell cell = new Cell((Evaluator)this, this.elementId("jquery:$(" + query + "[" + cellNum + "])"));
                cells.add(cell);
            }
        }
        if (cellContainer instanceof Column) {
            query = "$('#" + ((Component)cellContainer).id() + "').parent().find('th')";
            int numberOfColumns = Integer.valueOf(this.evaluate(this.jQueryExpression("result = " + query + ".length")));
            int selectedColumnNum = 0;
            boolean columnNumFind = false;
            for (int colNum = 0; colNum < numberOfColumns; ++colNum) {
                if (!this.elementId("jquery:$(" + query + "[" + colNum + "])").equals(((Component)cellContainer).id())) continue;
                selectedColumnNum = colNum;
                columnNumFind = true;
            }
            if (!columnNumFind) {
                throw new EvaluatorException("Unable to find the Column");
            }
            query = "$('#" + ((Component)cellContainer).id() + "').parents('table').find('tbody tr')";
            int numberOfRows = Integer.valueOf(this.evaluate(this.jQueryExpression("result = " + query + ".length")));
            for (int rowNum = 0; rowNum < numberOfRows; ++rowNum) {
                Cell cell = new Cell((Evaluator)this, this.elementId("jquery:$($(" + query + "[" + rowNum + "]).find('td')[" + selectedColumnNum + "])"));
                cells.add(cell);
            }
        }
        return ListSelection.from(cells);
    }

    public ComponentType componentType(String id) {
        if (id.equals(org.testatoo.cartridge.html4.element.AlertBox.ID)) {
            return ComponentType.AlertBox;
        }
        return ComponentType.valueOf((String)this.evaluate(this.jQueryExpression("result = $('#" + id + "').componentType()")));
    }

    public void click(Component component, Click which) {
        try {
            this.setFocus(component);
            if (which == Click.right) {
                this.evaluate(this.jQueryExpression("$('#" + component.id() + "').simulate('rightclick')"));
            } else if (component instanceof Link && !((Link)component).reference().equals("#")) {
                this.selenium.click(component.id());
            } else {
                this.evaluate(this.jQueryExpression("$('#" + component.id() + "').simulate('click')"));
            }
            this.waitForCondition();
        }
        catch (Exception e) {
            this.waitForCondition();
        }
    }

    public void doubleClick(Component component) {
        this.evaluate(this.jQueryExpression("$('#" + component.id() + "').simulate('dblclick')"));
        this.setFocus(component);
        this.waitForCondition();
    }

    public void mouseOver(Component component) {
        this.evaluate(this.jQueryExpression("$('#" + component.id() + "').simulate('mouseover')"));
        this.waitForCondition();
    }

    public void mouseOut(Component component) {
        this.evaluate(this.jQueryExpression("$('#" + component.id() + "').simulate('mouseout')"));
        this.waitForCondition();
    }

    public void dragAndDrop(Component from, Component to) {
        this.evaluate(this.jQueryExpression("$('#" + from.id() + "').simulate('dragTo', {'target': $('#" + to.id() + "')})"));
        this.waitForCondition();
    }

    public void focusOn(Component component) {
        this.click(component, Click.left);
    }

    public void type(String text) {
        String keyModifier = this.keyModifier();
        if (this.currentFocusedComponent != null) {
            for (byte charCode : text.getBytes()) {
                if (Boolean.valueOf(this.evaluate(this.jQueryExpression("$.browser.msie"))).booleanValue()) {
                    this.evaluate(this.jQueryExpression("$('#" + this.currentFocusedComponent.id() + "')" + ".val($('#" + this.currentFocusedComponent.id() + "').val() + String.fromCharCode(" + charCode + "));"));
                }
                this.evaluate(this.jQueryExpression("$('#" + this.currentFocusedComponent.id() + "').simulate('type', {charCode: " + charCode + keyModifier + "});"));
            }
        } else {
            for (char charCode : text.toCharArray()) {
                this.evaluate(this.jQueryExpression("if ($.browser.mozilla) {$(window.document).simulate('type', {keyCode: " + this.keyboardLayout.convert(charCode) + keyModifier + "})}" + "else {$(window.document).simulate('type', {charCode: " + this.keyboardLayout.convert(charCode) + keyModifier + "})};"));
            }
        }
        this.waitForCondition();
    }

    public void press(Key key) {
        this.typeKey(key.code());
    }

    public void close(AbstractWindow window) {
        if (window instanceof AlertBox && this.selenium.isAlertPresent()) {
            this.selenium.getAlert();
        }
    }

    public String reference(Link link) {
        if (this.attribute(link.id(), Attribute.href).equals("")) {
            return "#";
        }
        return this.attribute(link.id(), Attribute.href);
    }

    @Override
    public void open(String url) {
        if (this.selenium.isAlertPresent()) {
            this.selenium.getAlert();
        }
        this.selenium.open(url);
        this.currentFocusedComponent = null;
        this.release();
        boolean scriptsNotLoaded = true;
        while (scriptsNotLoaded) {
            try {
                this.selenium.getEval("window.tQuery().isTQueryAvailable()");
            }
            catch (Exception e) {
                this.selenium.runScript(this.loadUserExtensions());
            }
            scriptsNotLoaded = false;
        }
        this.waitForCondition();
    }

    @Override
    public String attribute(String id, Attribute attribute) {
        String attributeValue = this.evaluate(this.jQueryExpression("result = $('#" + id + "').attributeValue('" + (Object)((Object)attribute) + "');"));
        if (attributeValue.equals("null")) {
            return "";
        }
        return attributeValue;
    }

    @Override
    public Boolean exist(String id, Attribute attribute) {
        return !this.evaluate(this.jQueryExpression("result = $('#" + id + "[" + (Object)((Object)attribute) + "]')")).isEmpty();
    }

    @Override
    public String pageSource() {
        return this.selenium.getHtmlSource();
    }

    @Override
    public Selection<OptionGroup> optionGroups(Select select) {
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        try {
            for (String id : By.jQuery("$('#" + select.id() + " optgroup')").ids(this)) {
                optionGroups.add(new OptionGroup(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(optionGroups);
        }
        return ListSelection.from(optionGroups);
    }

    @Override
    public Selection<Option> options(Select select) {
        ArrayList<Option> options = new ArrayList<Option>();
        try {
            for (String id : By.jQuery("$('#" + select.id() + " option')").ids(this)) {
                options.add(new Option(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(options);
        }
        return ListSelection.from(options);
    }

    @Override
    public Selection<Option> selectedOptions(Select select) {
        try {
            String[] selectedIds = this.elementsId("jquery:$('#" + select.id() + " option:selected')");
            ArrayList<Option> options = new ArrayList<Option>();
            for (String id : selectedIds) {
                options.add(new Option(this, id));
            }
            return ListSelection.from(options);
        }
        catch (EvaluatorException se) {
            return ListSelection.empty();
        }
    }

    @Override
    public Selection<Option> options(OptionGroup optionGroup) {
        ArrayList<Option> options = new ArrayList<Option>();
        try {
            for (String id : By.jQuery("$('#" + optionGroup.id() + " option')").ids(this)) {
                options.add(new Option(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(options);
        }
        return ListSelection.from(options);
    }

    @Override
    public Selection<Param> params(org.testatoo.cartridge.html4.element.Object object) {
        ArrayList<Param> params = new ArrayList<Param>();
        try {
            for (String id : By.jQuery("$('#" + object.id() + " param')").ids(this)) {
                params.add(new Param(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(params);
        }
        return ListSelection.from(params);
    }

    @Override
    public Selection<Area> areas(org.testatoo.cartridge.html4.element.Map map) {
        ArrayList<Area> areas = new ArrayList<Area>();
        try {
            for (String id : By.jQuery("$('#" + map.id() + " area')").ids(this)) {
                areas.add(new Area(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(areas);
        }
        return ListSelection.from(areas);
    }

    @Override
    public Selection<Col> cols(Colgroup colgroup) {
        ArrayList<Col> cols = new ArrayList<Col>();
        try {
            for (String id : By.jQuery("$('#" + colgroup.id() + " col')").ids(this)) {
                cols.add(new Col(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(cols);
        }
        return ListSelection.from(cols);
    }

    @Override
    public Caption caption(Table table) {
        return new Caption(this, By.jQuery("$('#" + table.id() + " caption')").id(this));
    }

    @Override
    public String content(Component component) {
        return this.nodeTextContent(component);
    }

    @Override
    public THead thead(Table table) {
        return new THead(this, By.jQuery("$('#" + table.id() + " thead')").id(this));
    }

    @Override
    public TBody tbody(Table table) {
        return new TBody(this, By.jQuery("$('#" + table.id() + " tbody')").id(this));
    }

    @Override
    public TFoot tfoot(Table table) {
        return new TFoot(this, By.jQuery("$('#" + table.id() + " tfoot')").id(this));
    }

    @Override
    public Selection<Tr> tr(Component component) {
        ArrayList<Tr> tableRows = new ArrayList<Tr>();
        try {
            for (String id : By.jQuery("$('#" + component.id() + " tr')").ids(this)) {
                tableRows.add(new Tr(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(tableRows);
        }
        return ListSelection.from(tableRows);
    }

    @Override
    public Selection<Td> td(Tr tr) {
        ArrayList<Td> td = new ArrayList<Td>();
        try {
            for (String id : By.jQuery("$('#" + tr.id() + " td')").ids(this)) {
                td.add(new Td(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(td);
        }
        return ListSelection.from(td);
    }

    @Override
    public Selection<Th> th(Tr tr) {
        ArrayList<Th> th = new ArrayList<Th>();
        try {
            for (String id : By.jQuery("$('#" + tr.id() + " th')").ids(this)) {
                th.add(new Th(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(th);
        }
        return ListSelection.from(th);
    }

    @Override
    public Selection<Col> cols(Table table) {
        ArrayList<Col> cols = new ArrayList<Col>();
        try {
            for (String id : By.jQuery("$('#" + table.id() + " col')").ids(this)) {
                cols.add(new Col(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(cols);
        }
        return ListSelection.from(cols);
    }

    @Override
    public Selection<Colgroup> colgroups(Table table) {
        ArrayList<Colgroup> colgroups = new ArrayList<Colgroup>();
        try {
            for (String id : By.jQuery("$('#" + table.id() + " colgroup')").ids(this)) {
                colgroups.add(new Colgroup(this, id));
            }
        }
        catch (EvaluatorException e) {
            return ListSelection.from(colgroups);
        }
        return ListSelection.from(colgroups);
    }

    @Override
    public String content(Option option) {
        return this.nodeTextContent((Component)option);
    }

    @Override
    public void submit(Form form) {
        this.evaluate(this.jQueryExpression("$('#" + form.id() + "').submit()"));
        this.waitForCondition();
    }

    @Override
    public void reset(Form form) {
        this.click((Component)this.getResetButton(form), Click.left);
        this.waitForCondition();
    }

    @Override
    public Boolean isReadOnly(org.testatoo.core.component.Field field) {
        return !this.selenium.isEditable(field.id());
    }

    @Override
    public String elementId(String expression) {
        if (!expression.startsWith("jquery:")) {
            expression = "jquery:$('#" + expression + "')";
        }
        if (!Boolean.valueOf(this.evaluate(this.jQueryExpression("result = " + expression.substring(7) + ".length > 0"))).booleanValue()) {
            throw new EvaluatorException("Cannot find component defined by the jquery expression : " + expression.substring(7));
        }
        if (!Boolean.valueOf(this.evaluate(this.jQueryExpression("result = " + expression.substring(7) + ".length == 1"))).booleanValue()) {
            throw new EvaluatorException("Find more than one component defined by the jquery expression : " + expression.substring(7));
        }
        String id = this.evaluate(this.jQueryExpression("result = " + expression.substring(7) + ".attr('id')"));
        if (id.isEmpty()) {
            id = UUID.randomUUID().toString();
            this.evaluate(this.jQueryExpression(expression.substring(7) + ".attr('id', '" + id + "')"));
        }
        return id;
    }

    @Override
    public String[] elementsId(String expression) {
        if (expression.startsWith("jquery:")) {
            if (!Boolean.valueOf(this.evaluate(this.jQueryExpression("result = " + expression.substring(7) + ".length > 0"))).booleanValue()) {
                throw new EvaluatorException("Cannot find component defined by the jquery expression : " + expression.substring(7));
            }
            String[] resultId = this.extractId(expression);
            for (int i = 0; i < resultId.length; ++i) {
                String id = resultId[i];
                if (!id.equals("")) continue;
                id = UUID.randomUUID().toString();
                this.evaluate(this.jQueryExpression("$(" + expression.substring(7) + "[" + i + "]).attr('id', '" + id + "')"));
                resultId[i] = id;
            }
            return resultId;
        }
        throw new IllegalArgumentException("The expression format is not supported");
    }

    @Override
    public HtmlElementType htmlElementType(String id) {
        return HtmlElementType.valueOfIgnoreCase(this.evaluate(this.jQueryExpression("result = $('#" + id + "').htmlType()")));
    }

    @Override
    public String nodeTextContent(Component component) {
        return this.selenium.getText(component.id());
    }

    @Override
    public String nodename(Component component) {
        return this.evaluate(this.jQueryExpression("result = $('#" + component.id() + "').attr('nodeName')"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SeleniumHtmlEvaluator");
        sb.append("{location='").append(this.selenium.getLocation()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private String[] extractId(String expression) {
        if (expression.startsWith("jquery:")) {
            expression = expression.substring(7, expression.length());
            this.selenium.runScript(this.jQueryExpression("window.testatoo_tmp=[]; " + expression + ".each(function(){window.testatoo_tmp.push($(this).attr('id') ? $(this).attr('id') : 'undefined')});"));
            return SeleniumHtmlEvaluator.parseCSV(this.evaluate("window.testatoo_tmp"));
        }
        return null;
    }

    private void setFocus(Component component) {
        if (component instanceof Link || component instanceof Area || component instanceof Button || component instanceof org.testatoo.cartridge.html4.element.Object || component instanceof ListModel || component instanceof org.testatoo.core.component.Field) {
            this.evaluate(this.jQueryExpression("$('#" + component.id() + "').focus()"));
            this.currentFocusedComponent = component;
        }
    }

    private void typeKey(int keyCode) {
        String keyModifier = this.keyModifier();
        this.evaluate(this.jQueryExpression("if($.browser.webkit) {$(window.document).simulate('type', {charCode: " + keyCode + keyModifier + "});}" + "else {$('body').simulate('type', {keyCode: " + keyCode + keyModifier + "});}"));
    }

    private String keyModifier() {
        if (!this.pressedKeyModifier.isEmpty()) {
            ArrayList<String> options = new ArrayList<String>();
            if (this.pressedKeyModifier.contains(KeyModifier.CONTROL)) {
                options.add("ctrlKey : true");
            }
            if (this.pressedKeyModifier.contains(KeyModifier.SHIFT)) {
                options.add("shiftKey : true");
            }
            if (this.pressedKeyModifier.contains(KeyModifier.ALT)) {
                options.add("altKey : true");
            }
            String result = "";
            for (String option : options) {
                result = result + ", " + option;
            }
            return result;
        }
        return "";
    }

    private static String[] parseCSV(String input) {
        String[] splitedInput = input.split(",");
        for (int i = 0; i < splitedInput.length; ++i) {
            if (!splitedInput[i].equalsIgnoreCase("undefined")) continue;
            splitedInput[i] = "";
        }
        return splitedInput;
    }

    private Button getResetButton(Form form) {
        return new Button((Evaluator)this, By.jQuery("$('#" + form.id() + " :reset')").id(this));
    }

    private void waitForCondition() {
        new Wait(){

            public boolean until() {
                return SeleniumHtmlEvaluator.this.getWaitingCondition().isReach();
            }
        }.wait("One of the waiting conditions has fail", 60000L);
    }

    private Select findEmbeddedSelect(ListModel listModel) {
        try {
            Field[] fields;
            if (listModel instanceof Select) {
                return (Select)listModel;
            }
            ListBox listBox = (ListBox)listModel;
            for (Field field : fields = ((Object)((Object)listBox)).getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.getName().equals("select")) continue;
                return (Select)field.get((Object)listBox);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new EvaluatorException("Unable to identify the type of ListModel");
    }

    private String evaluate(String expression) {
        return this.selenium.getEval(expression);
    }

    private String loadUserExtensions() {
        String script = "";
        script = script + this.addScript("tquery-1.5.js");
        script = script + this.addScript("tquery-simulate.js");
        script = script + this.addScript("tquery-util.js");
        return script;
    }

    private String addScript(String name) {
        try {
            int read;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Bootstraper.class.getResourceAsStream(name)));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error occured when trying to load custom scripts : " + e.getMessage(), e);
        }
    }

    private String jQueryExpression(String expression) {
        return "(function($){var result; " + expression + " ;return result;})(window.tQuery);";
    }
}

