/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.cartridge.html4.element.Select;
import org.testatoo.core.ComponentException;
import org.testatoo.core.Evaluator;
import org.testatoo.core.EvaluatorHolder;
import org.testatoo.core.ListSelection;
import org.testatoo.core.Selection;
import org.testatoo.core.component.AlertBox;
import org.testatoo.core.component.Button;
import org.testatoo.core.component.CheckBox;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.DropDown;
import org.testatoo.core.component.Field;
import org.testatoo.core.component.Image;
import org.testatoo.core.component.Link;
import org.testatoo.core.component.ListBox;
import org.testatoo.core.component.Page;
import org.testatoo.core.component.Panel;
import org.testatoo.core.component.PasswordField;
import org.testatoo.core.component.Radio;
import org.testatoo.core.component.TextField;
import org.testatoo.core.component.datagrid.DataGrid;

public final class ComponentFactory {
    public static Page page() {
        return new Page((Evaluator)ComponentFactory.evaluator(), ComponentFactory.evaluator().pageId());
    }

    public static <T extends Component> T component(Class<T> componentType, String id) {
        return ComponentFactory.component(componentType, By.id(id));
    }

    public static <T extends Component> T component(Class<T> componentType, By by) {
        String id;
        Class<Object> cmpType = componentType;
        if (componentType.equals(AlertBox.class) || componentType.equals(org.testatoo.cartridge.html4.element.AlertBox.class)) {
            return (T)((Object)new org.testatoo.cartridge.html4.element.AlertBox(ComponentFactory.evaluator()));
        }
        if (componentType.equals(DropDown.class)) {
            cmpType = org.testatoo.cartridge.html4.element.DropDown.class;
        }
        if (componentType.equals(ListBox.class)) {
            cmpType = org.testatoo.cartridge.html4.component.ListBox.class;
        }
        try {
            id = by.id(ComponentFactory.evaluator());
        }
        catch (Exception e) {
            throw new ComponentException("Cannot find component defined " + by, (Throwable)e);
        }
        try {
            return (T)((Component)cmpType.getConstructor(HtmlEvaluator.class, String.class).newInstance(ComponentFactory.evaluator(), id));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ComponentException) {
                throw (ComponentException)e.getCause();
            }
            try {
                return (T)((Component)componentType.getConstructor(Evaluator.class, String.class).newInstance(ComponentFactory.evaluator(), id));
            }
            catch (InvocationTargetException ite) {
                throw new ComponentException(ite.getTargetException().getMessage(), ite.getTargetException());
            }
            catch (Exception e1) {
                throw new ComponentException(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public static Selection<? extends Component> components(By by) {
        List<String> ids;
        try {
            ids = by.ids(ComponentFactory.evaluator());
        }
        catch (Exception e) {
            throw new ComponentException("Cannot find component defined " + by, (Throwable)e);
        }
        return ListSelection.from(ids).transform((Function)new Function<String, Component>(){

            public Component apply(String id) {
                return ComponentFactory.component(Component.class, id);
            }
        });
    }

    public static <T extends Component> Selection<T> components(Class<T> componentType, By by) {
        List<String> ids;
        ArrayList<T> components = new ArrayList<T>();
        try {
            ids = by.ids(ComponentFactory.evaluator());
        }
        catch (Exception e) {
            throw new ComponentException("Cannot find component defined " + by, (Throwable)e);
        }
        for (String id : ids) {
            components.add(ComponentFactory.component(componentType, id));
        }
        return ListSelection.from(components).transform(componentType);
    }

    public static <T extends Component> Selection<T> findAll(Class<T> componentType) {
        if (componentType == Button.class) {
            return ListSelection.compose((Iterable[])new Iterable[]{ComponentFactory.components(Button.class, By.jQuery("$('input[type=button]')")), ComponentFactory.components(Button.class, By.jQuery("$('input[type=reset]')")), ComponentFactory.components(Button.class, By.jQuery("$('input[type=submit]')")), ComponentFactory.components(Button.class, By.jQuery("$('button')")), ComponentFactory.components(Button.class, By.jQuery("$('input:image')"))}).transform(componentType);
        }
        if (componentType == TextField.class) {
            return ComponentFactory.components(InputText.class, By.jQuery("$('input:text')")).transform(componentType);
        }
        if (componentType == PasswordField.class) {
            return ComponentFactory.components(PasswordField.class, By.jQuery("$('input:password')")).transform(componentType);
        }
        if (componentType == Field.class) {
            Selection<PasswordField> passwords = ListSelection.empty();
            Selection<TextField> texts = ListSelection.empty();
            try {
                passwords = ComponentFactory.components(PasswordField.class, By.jQuery("$('input:password')"));
            }
            catch (ComponentException e) {
                // empty catch block
            }
            try {
                texts = ComponentFactory.components(TextField.class, By.jQuery("$('input:text')"));
            }
            catch (ComponentException componentException) {
                // empty catch block
            }
            return ListSelection.compose((Iterable[])new Iterable[]{passwords, texts}).transform(componentType);
        }
        if (componentType == Image.class) {
            return ComponentFactory.components(Image.class, By.jQuery("$('img')")).transform(componentType);
        }
        if (componentType == Link.class) {
            return ComponentFactory.components(Link.class, By.jQuery("$('a')")).transform(componentType);
        }
        if (componentType == Radio.class) {
            return ComponentFactory.components(Radio.class, By.jQuery("$('input:radio')")).transform(componentType);
        }
        if (componentType == CheckBox.class) {
            return ComponentFactory.components(CheckBox.class, By.jQuery("$('input:checkbox')")).transform(componentType);
        }
        if (componentType == ListBox.class) {
            return ComponentFactory.components(Select.class, By.jQuery("$('select')"));
        }
        if (componentType == Panel.class) {
            return ComponentFactory.components(Panel.class, By.jQuery("$('div9)")).transform(componentType);
        }
        if (componentType == DataGrid.class) {
            return ComponentFactory.components(DataGrid.class, By.jQuery("$('table')")).transform(componentType);
        }
        return ListSelection.empty();
    }

    private static HtmlEvaluator evaluator() {
        return (HtmlEvaluator)EvaluatorHolder.get();
    }
}

