/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.testatoo.cartridge.html4.EvaluatorException;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.core.ComponentException;
import org.testatoo.core.Duration;

public abstract class By {
    public static By id(final String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot find component with a null id.");
        }
        return new By(){

            @Override
            public String id(HtmlEvaluator evaluator) {
                return this.id(evaluator, new Duration(2000L, TimeUnit.MILLISECONDS), new Duration(500L, TimeUnit.MILLISECONDS));
            }

            @Override
            public String id(HtmlEvaluator evaluator, Duration duration, Duration frequency) {
                return By.waitUntilId(evaluator, id, duration, frequency);
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator) {
                return this.ids(evaluator, new Duration(2000L, TimeUnit.MILLISECONDS), new Duration(500L, TimeUnit.MILLISECONDS));
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator, Duration duration, Duration frequency) {
                return Arrays.asList(By.waitUntilIds(evaluator, id, duration, frequency));
            }

            @Override
            public String toString() {
                return "by id=" + id;
            }
        };
    }

    public static By jQuery(final String jQueryExpression) {
        if (jQueryExpression == null) {
            throw new IllegalArgumentException("Cannot find component when jQueryExpression is null.");
        }
        return new By(){

            @Override
            public String id(HtmlEvaluator evaluator) {
                return this.id(evaluator, new Duration(2000L, TimeUnit.MILLISECONDS), new Duration(500L, TimeUnit.MILLISECONDS));
            }

            @Override
            public String id(HtmlEvaluator evaluator, Duration duration, Duration frequency) {
                return By.waitUntilId(evaluator, "jquery:" + jQueryExpression, duration, frequency);
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator) {
                return this.ids(evaluator, new Duration(2000L, TimeUnit.MILLISECONDS), new Duration(500L, TimeUnit.MILLISECONDS));
            }

            @Override
            public List<String> ids(HtmlEvaluator evaluator, Duration duration, Duration frequency) {
                return Arrays.asList(By.waitUntilIds(evaluator, "jquery:" + jQueryExpression, duration, frequency));
            }

            @Override
            public String toString() {
                return "by jQueryExpression=" + jQueryExpression;
            }
        };
    }

    public abstract String id(HtmlEvaluator var1);

    public abstract String id(HtmlEvaluator var1, Duration var2, Duration var3);

    public abstract List<String> ids(HtmlEvaluator var1);

    public abstract List<String> ids(HtmlEvaluator var1, Duration var2, Duration var3);

    public abstract String toString();

    private static String waitUntilId(HtmlEvaluator evaluator, String expression, Duration duration, Duration frequency) {
        Exception ex = null;
        try {
            long step = frequency.unit.toMillis(frequency.duration);
            for (long timeout = duration.unit.toMillis(duration.duration); timeout > 0L && !Thread.currentThread().isInterrupted(); timeout -= step) {
                try {
                    String[] ids = evaluator.elementsId(expression);
                    if (ids.length != 1) {
                        throw new ComponentException("Find more than one component defined by the jquery expression : " + expression.substring(7));
                    }
                    return ids[0];
                }
                catch (RuntimeException e) {
                    ex = e;
                    Thread.sleep(step);
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ex = e;
        }
        if (ex instanceof EvaluatorException) {
            throw (EvaluatorException)ex;
        }
        throw new RuntimeException("Unable to reach the condition in " + duration.duration + " " + (Object)((Object)duration.unit), ex);
    }

    private static String[] waitUntilIds(HtmlEvaluator evaluator, String expression, Duration duration, Duration frequency) {
        Exception ex = null;
        try {
            long step = frequency.unit.toMillis(frequency.duration);
            for (long timeout = duration.unit.toMillis(duration.duration); timeout > 0L && !Thread.currentThread().isInterrupted(); timeout -= step) {
                try {
                    return evaluator.elementsId(expression);
                }
                catch (RuntimeException e) {
                    ex = e;
                    Thread.sleep(step);
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ex = e;
        }
        if (ex instanceof EvaluatorException) {
            throw (EvaluatorException)ex;
        }
        throw new RuntimeException("Unable to reach the condition in " + duration.duration + " " + (Object)((Object)duration.unit), ex);
    }
}

