/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.cartridge.html4.element.Select;
import org.testatoo.core.ComponentException;
import org.testatoo.core.Evaluator;
import org.testatoo.core.EvaluatorHolder;
import org.testatoo.core.ListSelection;
import org.testatoo.core.Selection;
import org.testatoo.core.component.AlertBox;
import org.testatoo.core.component.Button;
import org.testatoo.core.component.CheckBox;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.DropDown;
import org.testatoo.core.component.Field;
import org.testatoo.core.component.Image;
import org.testatoo.core.component.Link;
import org.testatoo.core.component.ListBox;
import org.testatoo.core.component.Page;
import org.testatoo.core.component.Panel;
import org.testatoo.core.component.PasswordField;
import org.testatoo.core.component.Radio;
import org.testatoo.core.component.TextField;
import org.testatoo.core.component.datagrid.DataGrid;

public final class ComponentFactory {
    public static Page page() {
        return new Page((Evaluator)ComponentFactory.evaluator(), ComponentFactory.evaluator().pageId());
    }

    public static <T extends Component> T component(Class<T> componentType) {
        if (componentType.equals(AlertBox.class) || componentType.equals(org.testatoo.cartridge.html4.element.AlertBox.class)) {
            return (T)((Object)new org.testatoo.cartridge.html4.element.AlertBox(ComponentFactory.evaluator()));
        }
        Selection<T> components = ComponentFactory.findAll(componentType);
        if (components.size() == 1) {
            return (T)((Component)components.get(0));
        }
        if (components.size() > 1) {
            throw new ComponentException("Find more than one component for type : " + componentType.getSimpleName());
        }
        throw new ComponentException("Cannot find component for type " + componentType.getSimpleName());
    }

    public static <T extends Component> Selection<T> components(Class<T> componentType) {
        return ComponentFactory.findAll(componentType);
    }

    public static <T extends Component> T component(Class<T> componentType, String id) {
        if (id.startsWith("$")) {
            return ComponentFactory.component(componentType, By.$(id));
        }
        return ComponentFactory.component(componentType, By.id(id));
    }

    public static <T extends Component> T component(Class<T> componentType, By by) {
        return ComponentFactory.loadComponent(componentType, by.id(ComponentFactory.evaluator()));
    }

    public static Selection<? extends Component> components(By by) {
        return ComponentFactory.components(Component.class, by);
    }

    public static <T extends Component> Selection<T> components(final Class<T> componentType, By by) {
        return ListSelection.from(by.ids(ComponentFactory.evaluator())).transform(new Function<String, T>(){

            public T apply(String id) {
                return ComponentFactory.loadComponent(componentType, id);
            }
        });
    }

    public static <T extends Component> Selection<T> findAll(Class<T> componentType) {
        if (componentType == Button.class) {
            return ListSelection.compose((Iterable[])new Iterable[]{ComponentFactory.components(Button.class, By.$("input[type=button]")), ComponentFactory.components(Button.class, By.$("input[type=reset]")), ComponentFactory.components(Button.class, By.$("input[type=submit]")), ComponentFactory.components(Button.class, By.$("button")), ComponentFactory.components(Button.class, By.$("input:image"))}).transform(componentType);
        }
        if (componentType == TextField.class) {
            return ComponentFactory.components(InputText.class, By.$("input:text")).transform(componentType);
        }
        if (componentType == PasswordField.class) {
            return ComponentFactory.components(PasswordField.class, By.$("input:password")).transform(componentType);
        }
        if (componentType == Field.class) {
            Selection<PasswordField> passwords = ListSelection.empty();
            Selection<TextField> texts = ListSelection.empty();
            try {
                passwords = ComponentFactory.components(PasswordField.class, By.$("input:password"));
            }
            catch (ComponentException e) {
                // empty catch block
            }
            try {
                texts = ComponentFactory.components(TextField.class, By.$("input:text"));
            }
            catch (ComponentException componentException) {
                // empty catch block
            }
            return ListSelection.compose((Iterable[])new Iterable[]{passwords, texts}).transform(componentType);
        }
        if (componentType == Image.class) {
            return ComponentFactory.components(Image.class, By.$("img")).transform(componentType);
        }
        if (componentType == Link.class) {
            return ComponentFactory.components(Link.class, By.$("a")).transform(componentType);
        }
        if (componentType == Radio.class) {
            return ComponentFactory.components(Radio.class, By.$("input:radio")).transform(componentType);
        }
        if (componentType == CheckBox.class) {
            return ComponentFactory.components(CheckBox.class, By.$("input:checkbox")).transform(componentType);
        }
        if (componentType == ListBox.class) {
            return ComponentFactory.components(Select.class, By.$("select"));
        }
        if (componentType == Panel.class) {
            return ComponentFactory.components(Panel.class, By.$("div")).transform(componentType);
        }
        if (componentType == DataGrid.class) {
            return ComponentFactory.components(DataGrid.class, By.$("table")).transform(componentType);
        }
        return ListSelection.empty();
    }

    private static HtmlEvaluator evaluator() {
        return (HtmlEvaluator)EvaluatorHolder.get();
    }

    private static <T extends Component> T loadComponent(Class<T> componentType, String id) {
        Class<Object> cmpType = componentType;
        if (componentType.equals(AlertBox.class) || componentType.equals(org.testatoo.cartridge.html4.element.AlertBox.class)) {
            return (T)((Object)new org.testatoo.cartridge.html4.element.AlertBox(ComponentFactory.evaluator()));
        }
        if (componentType.equals(DropDown.class)) {
            cmpType = org.testatoo.cartridge.html4.element.DropDown.class;
        }
        if (componentType.equals(ListBox.class)) {
            cmpType = org.testatoo.cartridge.html4.component.ListBox.class;
        }
        try {
            return (T)((Component)cmpType.getConstructor(HtmlEvaluator.class, String.class).newInstance(ComponentFactory.evaluator(), id));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ComponentException) {
                throw (ComponentException)e.getCause();
            }
            try {
                return (T)((Component)componentType.getConstructor(Evaluator.class, String.class).newInstance(ComponentFactory.evaluator(), id));
            }
            catch (InvocationTargetException ite) {
                throw new ComponentException(ite.getTargetException().getMessage(), ite.getTargetException());
            }
            catch (Exception e1) {
                throw new ComponentException(e1.getMessage(), (Throwable)e1);
            }
        }
    }
}

