/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.AlertBox;
import org.testatoo.cartridge.html4.element.Button;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;

public class AlertBoxTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("AlertBox.html");
    }

    @Test
    public void can_find_alertBox() {
        try {
            ComponentFactory.alertBox();
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("Cannot find component defined by id=" + AlertBox.ID)));
        }
        Language.clickOn((Component)ComponentFactory.component(Button.class, (By)By.$((String)"#alertButton")));
        AlertBox alertbox = ComponentFactory.alertBox();
        alertbox.close();
    }

    @Test
    @Ignore
    public void exception_thrown_if_component_not_a_alertBox() {
        Language.clickOn((Component)ComponentFactory.component(Button.class, (By)By.$((String)"#dialogButton")));
        try {
            ComponentFactory.alertBox();
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("The component with id=" + AlertBox.ID + " is not a AlertBox but a DialogBox")));
        }
    }

    @Test
    public void can_test_title() {
        Language.clickOn((Component)ComponentFactory.component(Button.class, (By)By.$((String)"#alertButton")));
        AlertBox alertbox = ComponentFactory.alertBox();
        Language.assertThat((Object)alertbox.title(), (Matcher)Matchers.is((Object)""));
        alertbox.close();
    }

    @Test
    public void can_test_message() {
        Language.clickOn((Component)ComponentFactory.component(Button.class, (By)By.$((String)"#alertButton")));
        AlertBox alertbox = ComponentFactory.alertBox();
        Language.assertThat((Object)alertbox.message(), (Matcher)Matchers.is((Object)"Changes saved successfully."));
        alertbox.close();
    }

    @Test
    public void can_close_alertbox() {
        Language.clickOn((Component)ComponentFactory.component(Button.class, (By)By.$((String)"#alertButton")));
        AlertBox alertbox = ComponentFactory.alertBox();
        alertbox.close();
        try {
            ComponentFactory.alertBox();
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("Cannot find component defined by id=" + AlertBox.ID)));
        }
    }

    @Test
    public void test_toString() {
        Language.clickOn((Component)ComponentFactory.component(Button.class, (By)By.$((String)"#alertButton")));
        AlertBox alertbox = ComponentFactory.alertBox();
        Language.assertThat((Object)alertbox.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.AlertBox with state : enabled:true, visible:true, title:, message:Changes saved successfully."));
        alertbox.close();
    }
}

