/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.File;
import org.testatoo.cartridge.html4.element.InputType;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class FileTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("File.html");
    }

    @Test
    public void can_find_file_by_id() {
        ComponentFactory.component(File.class, (By)By.$((String)"#file"));
        try {
            ComponentFactory.component(File.class, (By)By.$((String)"#file_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#file_2')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_file() {
        try {
            ComponentFactory.component(File.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a FileDialog but a Radio"));
        }
    }

    @Test
    public void can_retreive_attributes() {
        File file = (File)ComponentFactory.component(File.class, (By)By.$((String)"#file"));
        Language.assertThat((Object)file.name(), (Matcher)Matchers.is((Object)"fileName"));
        Language.assertThat((Object)file.value(), (Matcher)Matchers.is((Object)""));
        Language.assertThat((Object)file.type(), (Matcher)Matchers.is((Object)InputType.file));
        Language.assertThat((Object)file.alt(), (Matcher)Matchers.is((Object)"short description"));
        Language.assertThat((Object)file.tabindex(), (Matcher)Matchers.is((Object)5));
        Language.assertThat((Object)file.accesskey(), (Matcher)Matchers.is((Object)"C"));
        Language.assertThat((Object)file.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)file.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)file.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)file.id(), (Matcher)Matchers.is((Object)"file"));
        Language.assertThat((Object)file.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)file.title(), (Matcher)Matchers.is((Object)"fileTitle"));
        Language.assertThat((Object)file.accept(), (Matcher)Matchers.is((Object)"application/msword, application/rtf"));
    }

    @Test
    public void test_toString() {
        File file = (File)ComponentFactory.component(File.class, (By)By.$((String)"#file2"));
        Language.assertThat((Object)file.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.File with state : enabled:true, visible:true, title:fileTitle, selectedFilePath:"));
    }
}

