/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Title;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class TitleTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Title.html");
    }

    @Test
    public void can_find_title_by_id() {
        ComponentFactory.component(Title.class, (By)By.$((String)"#h1"));
        try {
            ComponentFactory.component(Title.class, (By)By.$((String)"#someId"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#someId')"));
        }
    }

    @Test
    public void test_title_coreAttributes() {
        Title title = (Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h2"));
        Language.assertThat((Object)title.title(), (Matcher)Matchers.is((Object)"myTitle"));
        Language.assertThat((Object)title.id(), (Matcher)Matchers.is((Object)"h2"));
        Language.assertThat((Object)title.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)title.classname(), (Matcher)Matchers.is((Object)"myClass"));
    }

    @Test
    public void test_title_i18nAttributes() {
        Title title = (Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h2"));
        Language.assertThat((Object)title.language(), (Matcher)Matchers.is((Object)"ca"));
        Language.assertThat((Object)title.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
    }

    @Test
    public void test_title_text() {
        Title title = (Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h3"));
        Language.assertThat((Object)title.text(), (Matcher)Matchers.is((Object)"H3 Title"));
    }

    @Test
    public void test_title_level() {
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h1"))).level(), (Matcher)Matchers.is((Object)Title.Level.H1));
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h2"))).level(), (Matcher)Matchers.is((Object)Title.Level.H2));
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h3"))).level(), (Matcher)Matchers.is((Object)Title.Level.H3));
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h4"))).level(), (Matcher)Matchers.is((Object)Title.Level.H4));
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h5"))).level(), (Matcher)Matchers.is((Object)Title.Level.H5));
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h6"))).level(), (Matcher)Matchers.is((Object)Title.Level.H6));
    }

    @Test
    public void test_title_toString() {
        Language.assertThat((Object)((Title)ComponentFactory.component(Title.class, (By)By.$((String)"#h1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Title with state : enabled:true, visible:true, text:H1 Title"));
    }
}

