/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.multisession;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Button;
import org.testatoo.cartridge.html4.element.CheckBox;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Form;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.cartridge.html4.element.Method;
import org.testatoo.cartridge.html4.element.Radio;
import org.testatoo.cartridge.html4.element.Select;
import org.testatoo.config.annotation.ConcurrentEvaluation;
import org.testatoo.config.annotation.TestatooModules;
import org.testatoo.config.junit.TestatooJunitRunner;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;
import org.testatoo.core.input.Mouse;
import org.testatoo.multisession.ParallelMultiSessionModule;

@RunWith(value=TestatooJunitRunner.class)
@TestatooModules(value={ParallelMultiSessionModule.class})
@ConcurrentEvaluation
public class ParallelMultiSessionTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("Form.html");
    }

    @Test
    public void can_find_form_by_id() {
        ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        try {
            ComponentFactory.component(Form.class, (By)By.$((String)"#otherForm"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Cannot find component defined by jQueryExpression=$('#otherForm')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_form() {
        try {
            ComponentFactory.component(Form.class, (By)By.$((String)"#email"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"The component with id=email is not a Form but a InputText"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Language.assertThat((Object)myForm.direction(), (Matcher)Is.is((Object)Direction.lefttoright));
        Language.assertThat((Object)myForm.language(), (Matcher)Is.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Language.assertThat((Object)myForm.id(), (Matcher)Is.is((Object)"myForm"));
        Language.assertThat((Object)myForm.classname(), (Matcher)Is.is((Object)"myClass"));
        Language.assertThat((Object)myForm.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)myForm.title(), (Matcher)Is.is((Object)"formTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Language.assertThat((Object)myForm.method(), (Matcher)Is.is((Object)Method.post));
        Language.assertThat((Object)myForm.action(), (Matcher)Is.is((Object)"Exit.html"));
        Language.assertThat((Object)myForm.enctype(), (Matcher)Is.is((Object)"application/x-www-form-urlencoded"));
        Language.assertThat((Object)myForm.accept(), (Matcher)Is.is((Object)"all"));
        Language.assertThat((Object)myForm.name(), (Matcher)Is.is((Object)"formName"));
    }

    @Test
    public void if_attribute_are_not_defined_then_return_default_values() {
        Form myForm3 = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm3"));
        Language.assertThat((Object)myForm3.method(), (Matcher)Is.is((Object)Method.get));
        Language.assertThat((Object)myForm3.enctype(), (Matcher)Is.is((Object)"application/x-www-form-urlencoded"));
        Language.assertThat((Object)myForm3.accept(), (Matcher)Is.is((Object)""));
        Language.assertThat((Object)myForm3.name(), (Matcher)Is.is((Object)""));
        Language.assertThat((Object)myForm3.acceptCharset(), (Matcher)Is.is((Object)"UNKNOWN"));
    }

    @Test
    public void test_contains() {
        Form myForm = (Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"));
        Select citiesList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#cities"));
        Language.assertThat((Object)myForm, (Matcher)org.testatoo.core.matcher.Matchers.contains((Component[])new Component[]{citiesList}));
        InputText inputText = (InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#lastname"));
        Language.assertThat((Object)myForm, (Matcher)org.testatoo.core.matcher.Matchers.contains((Component[])new Component[]{inputText}));
        Radio radio = (Radio)ComponentFactory.component(Radio.class, (By)By.$((String)"#male"));
        Language.assertThat((Object)myForm, (Matcher)org.testatoo.core.matcher.Matchers.contains((Component[])new Component[]{radio}));
        CheckBox checkBox = (CheckBox)ComponentFactory.component(CheckBox.class, (By)By.$((String)"[name=yes]"));
        Language.assertThat((Object)myForm, (Matcher)org.testatoo.core.matcher.Matchers.contains((Component[])new Component[]{checkBox}));
        Button button = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage"));
        Language.assertThat((Object)myForm, (Matcher)org.testatoo.core.matcher.Matchers.contains((Component[])new Component[]{button}));
    }

    @Test
    public void can_submit_a_form() {
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Form tests")));
        Button submitButton = (Button)ComponentFactory.component(Button.class, (By)By.$((String)"#submitImage"));
        org.testatoo.cartridge.html4.Language.clickOn((Component)submitButton);
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Exit page")));
        ComponentFactory.page().open("Form.html");
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Form tests")));
        Mouse.clickOn((Component)submitButton);
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Exit page")));
        ComponentFactory.page().open("Form.html");
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Form tests")));
        ((Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"))).submit();
        Language.assertThat((Object)ComponentFactory.page(), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.title((String)"Exit page")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Form)ComponentFactory.component(Form.class, (By)By.$((String)"#myForm"))).toString(), (Matcher)Is.is((Object)"class org.testatoo.cartridge.html4.element.Form with state : enabled:true, visible:true, action:Exit.html"));
    }
}

