/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.IFrame;
import org.testatoo.cartridge.html4.element.Scrolling;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class IFrameTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("IFrame.html");
    }

    @Test
    public void can_find_iFrame_by_id() {
        ComponentFactory.component(IFrame.class, (By)By.$((String)"#iFrame_1"));
        try {
            ComponentFactory.component(IFrame.class, (By)By.$((String)"#iFrame_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"Cannot find component defined by jQueryExpression=$('#iFrame_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_iframe() {
        try {
            ComponentFactory.component(IFrame.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"The component with id=abbr_ess1 is not a IFrame but a Abbr"));
        }
    }

    @Test
    public void test_iFrame_coreAttributes() {
        IFrame iFrame_1 = (IFrame)ComponentFactory.component(IFrame.class, (By)By.$((String)"#iFrame_1"));
        Language.assertThat((Object)iFrame_1.id(), (Matcher)Is.is((Object)"iFrame_1"));
        Language.assertThat((Object)iFrame_1.classname(), (Matcher)Is.is((Object)"MyIFRAMEClass"));
        Language.assertThat((Object)iFrame_1.style(), (Matcher)Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)iFrame_1.title(), (Matcher)Is.is((Object)"iFrameTitle1"));
    }

    @Test
    public void test_iFrame_specifics_attributes() {
        IFrame iFrame_1 = (IFrame)ComponentFactory.component(IFrame.class, (By)By.$((String)"#iFrame_1"));
        Language.assertThat((Object)iFrame_1.name(), (Matcher)Is.is((Object)"iFrameName1"));
        Language.assertThat((Object)iFrame_1.frameborder(), (Matcher)Is.is((Object)1));
        Language.assertThat((Object)iFrame_1.longdesc(), (Matcher)Is.is((Object)""));
        Language.assertThat((Object)iFrame_1.marginheight(), (Matcher)Is.is((Object)1));
        Language.assertThat((Object)iFrame_1.marginwidth(), (Matcher)Is.is((Object)1));
        Language.assertThat((Object)iFrame_1.scrolling(), (Matcher)Is.is((Object)Scrolling.yes));
        Language.assertThat((Object)iFrame_1.src(), (Matcher)Is.is((Object)"http://www.google.com"));
        IFrame iFrame_2 = (IFrame)ComponentFactory.component(IFrame.class, (By)By.$((String)"#iFrame_2"));
        Language.assertThat((Object)iFrame_2.name(), (Matcher)Is.is((Object)""));
        Language.assertThat((Object)iFrame_2.frameborder(), (Matcher)Is.is((Object)1));
        Language.assertThat((Object)iFrame_2.longdesc(), (Matcher)Is.is((Object)""));
        Language.assertThat((Object)iFrame_2.marginheight(), (Matcher)Is.is((Object)1));
        Language.assertThat((Object)iFrame_2.marginwidth(), (Matcher)Is.is((Object)1));
        Language.assertThat((Object)iFrame_2.scrolling(), (Matcher)Is.is((Object)Scrolling.auto));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((IFrame)ComponentFactory.component(IFrame.class, (By)By.$((String)"#iFrame_1"))).toString(), (Matcher)Is.is((Object)"class org.testatoo.cartridge.html4.element.IFrame with state : enabled:true, visible:true, title:iFrameTitle1"));
    }
}

