/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.A;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.Page;
import org.testatoo.core.matcher.Matchers;

public class PageTest
extends WebTest {
    private Page page;

    @Before
    public void setUp() {
        this.page = ComponentFactory.page().open("Page.html");
    }

    @Test
    public void can_open_page() throws Exception {
        Language.assertThat((Object)this.page.source().toLowerCase(), (Matcher)org.hamcrest.Matchers.containsString((String)"<title>page tests</title>"));
    }

    @Test
    public void can_get_the_title() {
        Language.assertThat((Object)this.page, (Matcher)Matchers.has((Matcher)Matchers.title((String)"Page tests")));
    }

    @Test
    public void test_contains() {
        A a1 = (A)ComponentFactory.component(A.class, (By)By.$((String)"#link_1"));
        Language.assertThat((Object)this.page, (Matcher)Matchers.contains((Component[])new Component[]{a1}));
        try {
            ComponentFactory.component(A.class, (By)By.$((String)"#base_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#base_1')"));
        }
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)this.page.toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.core.component.Page with state : enabled:true, visible:true, title:Page tests"));
    }
}

