/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Abbr;
import org.testatoo.cartridge.html4.element.Acronym;
import org.testatoo.cartridge.html4.element.Cite;
import org.testatoo.cartridge.html4.element.Code;
import org.testatoo.cartridge.html4.element.Dfn;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Em;
import org.testatoo.cartridge.html4.element.Kbd;
import org.testatoo.cartridge.html4.element.P;
import org.testatoo.cartridge.html4.element.Samp;
import org.testatoo.cartridge.html4.element.Strong;
import org.testatoo.cartridge.html4.element.Var;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class PhraseTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Text.html");
    }

    @Test
    public void can_find_em_by_id() {
        ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess3"));
        try {
            ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#em_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_em() {
        try {
            ComponentFactory.component(Em.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Em but a Abbr"));
        }
    }

    @Test
    public void test_em_coreAttributes() {
        Em em_ess1 = (Em)ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess1"));
        Em em_ess2 = (Em)ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess2"));
        Language.assertThat((Object)em_ess1.title(), (Matcher)Matchers.is((Object)"em1_Title"));
        Language.assertThat((Object)em_ess1.id(), (Matcher)Matchers.is((Object)"em_ess1"));
        Language.assertThat((Object)em_ess1.style(), (Matcher)Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)em_ess2.classname(), (Matcher)Matchers.is((Object)"MyEMClass"));
    }

    @Test
    public void test_em_i18nAttributes() {
        Em em_ess2 = (Em)ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess2"));
        Em em_ess3 = (Em)ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess3"));
        Language.assertThat((Object)em_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)em_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)em_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)em_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_em_text() {
        Language.assertThat((Object)ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestem2")));
    }

    @Test
    public void testEm_toString() {
        Language.assertThat((Object)((Em)ComponentFactory.component(Em.class, (By)By.$((String)"#em_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Em with state : enabled:true, visible:true, text:TextTestem2"));
    }

    @Test
    public void can_find_strong_by_id() {
        ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess3"));
        try {
            ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#strong_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_strong() {
        try {
            ComponentFactory.component(Strong.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Strong but a Abbr"));
        }
    }

    @Test
    public void test_strong_coreAttributes() {
        Strong strong_ess1 = (Strong)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess1"));
        Strong strong_ess2 = (Strong)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess2"));
        Strong strong_ess3 = (Strong)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess3"));
        Language.assertThat((Object)strong_ess1.title(), (Matcher)Matchers.is((Object)"strong1_Title"));
        Language.assertThat((Object)strong_ess1.id(), (Matcher)Matchers.is((Object)"strong_ess1"));
        Language.assertThat((Object)strong_ess1.style(), (Matcher)Matchers.containsString((String)"color:yellow"));
        Language.assertThat((Object)strong_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:14pt"));
        Language.assertThat((Object)strong_ess2.classname(), (Matcher)Matchers.is((Object)"MySTRONGClass"));
    }

    @Test
    public void test_strong_i18nAttributes() {
        Strong strong_ess2 = (Strong)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess2"));
        Strong strong_ess3 = (Strong)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess3"));
        Language.assertThat((Object)strong_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)strong_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)strong_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)strong_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_strong_text() {
        Language.assertThat((Object)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestStrong2")));
    }

    @Test
    public void testStrong_toString() {
        Language.assertThat((Object)((Strong)ComponentFactory.component(Strong.class, (By)By.$((String)"#strong_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Strong with state : enabled:true, visible:true, text:TextTestStrong2"));
    }

    @Test
    public void can_find_cite_by_id() {
        ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess3"));
        try {
            ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#cite_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_cite() {
        try {
            ComponentFactory.component(Cite.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Cite but a Abbr"));
        }
    }

    @Test
    public void test_cite_coreAttributes() {
        Cite cite_ess1 = (Cite)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess1"));
        Cite cite_ess2 = (Cite)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess2"));
        Cite cite_ess3 = (Cite)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess3"));
        Language.assertThat((Object)cite_ess1.title(), (Matcher)Matchers.is((Object)"cite1_Title"));
        Language.assertThat((Object)cite_ess1.id(), (Matcher)Matchers.is((Object)"cite_ess1"));
        Language.assertThat((Object)cite_ess1.style(), (Matcher)Matchers.containsString((String)"color:pink"));
        Language.assertThat((Object)cite_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:16pt"));
        Language.assertThat((Object)cite_ess2.classname(), (Matcher)Matchers.is((Object)"MyCITEClass"));
    }

    @Test
    public void test_cite_i18nAttributes() {
        Cite cite_ess2 = (Cite)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess2"));
        Cite cite_ess3 = (Cite)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess3"));
        Language.assertThat((Object)cite_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)cite_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)cite_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)cite_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_cite_text() {
        Language.assertThat((Object)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestCite2")));
    }

    @Test
    public void testCite_toString() {
        Language.assertThat((Object)((Cite)ComponentFactory.component(Cite.class, (By)By.$((String)"#cite_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Cite with state : enabled:true, visible:true, text:TextTestCite2"));
    }

    @Test
    public void can_find_dfn_by_id() {
        ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess3"));
        try {
            ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#dfn_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_dfn() {
        try {
            ComponentFactory.component(Dfn.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Dfn but a Abbr"));
        }
    }

    @Test
    public void test_dfn_coreAttributes() {
        Dfn dfn_ess1 = (Dfn)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess1"));
        Dfn dfn_ess2 = (Dfn)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess2"));
        Dfn dfn_ess3 = (Dfn)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess3"));
        Language.assertThat((Object)dfn_ess1.title(), (Matcher)Matchers.is((Object)"dfn1_Title"));
        Language.assertThat((Object)dfn_ess1.id(), (Matcher)Matchers.is((Object)"dfn_ess1"));
        Language.assertThat((Object)dfn_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)dfn_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)dfn_ess2.classname(), (Matcher)Matchers.is((Object)"MyDFNClass"));
    }

    @Test
    public void test_dfn_i18nAttributes() {
        Dfn dfn_ess2 = (Dfn)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess2"));
        Dfn dfn_ess3 = (Dfn)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess3"));
        Language.assertThat((Object)dfn_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)dfn_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)dfn_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)dfn_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_dfn_text() {
        Language.assertThat((Object)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestDfn2")));
    }

    @Test
    public void testDfn_toString() {
        Language.assertThat((Object)((Dfn)ComponentFactory.component(Dfn.class, (By)By.$((String)"#dfn_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Dfn with state : enabled:true, visible:true, text:TextTestDfn2"));
    }

    @Test
    public void can_find_code_by_id() {
        ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess3"));
        try {
            ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#code_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_code() {
        try {
            ComponentFactory.component(Code.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Code but a Abbr"));
        }
    }

    @Test
    public void test_code_coreAttributes() {
        Code code_ess1 = (Code)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess1"));
        Code code_ess2 = (Code)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess2"));
        Code code_ess3 = (Code)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess3"));
        Language.assertThat((Object)code_ess1.title(), (Matcher)Matchers.is((Object)"code1_Title"));
        Language.assertThat((Object)code_ess1.id(), (Matcher)Matchers.is((Object)"code_ess1"));
        Language.assertThat((Object)code_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)code_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)code_ess2.classname(), (Matcher)Matchers.is((Object)"MyCODEClass"));
    }

    @Test
    public void test_code_i18nAttributes() {
        Code code_ess2 = (Code)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess2"));
        Code code_ess3 = (Code)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess3"));
        Language.assertThat((Object)code_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)code_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)code_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)code_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_code_text() {
        Language.assertThat((Object)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestCode2")));
    }

    @Test
    public void testCode_toString() {
        Language.assertThat((Object)((Code)ComponentFactory.component(Code.class, (By)By.$((String)"#code_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Code with state : enabled:true, visible:true, text:TextTestCode2"));
    }

    @Test
    public void can_find_samp_by_id() {
        ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess3"));
        try {
            ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#samp_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_samp() {
        try {
            ComponentFactory.component(Samp.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Samp but a Abbr"));
        }
    }

    @Test
    public void test_samp_coreAttributes() {
        Samp samp_ess1 = (Samp)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess1"));
        Samp samp_ess2 = (Samp)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess2"));
        Samp samp_ess3 = (Samp)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess3"));
        Language.assertThat((Object)samp_ess1.title(), (Matcher)Matchers.is((Object)"samp1_Title"));
        Language.assertThat((Object)samp_ess1.id(), (Matcher)Matchers.is((Object)"samp_ess1"));
        Language.assertThat((Object)samp_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)samp_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)samp_ess2.classname(), (Matcher)Matchers.is((Object)"MySAMPClass"));
    }

    @Test
    public void test_samp_i18nAttributes() {
        Samp samp_ess2 = (Samp)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess2"));
        Samp samp_ess3 = (Samp)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess3"));
        Language.assertThat((Object)samp_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)samp_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)samp_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)samp_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_samp_text() {
        Language.assertThat((Object)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestSamp2")));
    }

    @Test
    public void testSamp_toString() {
        Language.assertThat((Object)((Samp)ComponentFactory.component(Samp.class, (By)By.$((String)"#samp_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Samp with state : enabled:true, visible:true, text:TextTestSamp2"));
    }

    @Test
    public void can_find_kbd_by_id() {
        ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess3"));
        try {
            ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#kbd_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_kbd() {
        try {
            ComponentFactory.component(Kbd.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Kbd but a Abbr"));
        }
    }

    @Test
    public void test_kbd_coreAttributes() {
        Kbd kbd_ess1 = (Kbd)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess1"));
        Kbd kbd_ess2 = (Kbd)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess2"));
        Kbd kbd_ess3 = (Kbd)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess3"));
        Language.assertThat((Object)kbd_ess1.title(), (Matcher)Matchers.is((Object)"kbd1_Title"));
        Language.assertThat((Object)kbd_ess1.id(), (Matcher)Matchers.is((Object)"kbd_ess1"));
        Language.assertThat((Object)kbd_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)kbd_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)kbd_ess2.classname(), (Matcher)Matchers.is((Object)"MyKBDClass"));
    }

    @Test
    public void test_kbd_i18nAttributes() {
        Kbd kbd_ess2 = (Kbd)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess2"));
        Kbd kbd_ess3 = (Kbd)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess3"));
        Language.assertThat((Object)kbd_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)kbd_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)kbd_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)kbd_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_kbd_text() {
        Language.assertThat((Object)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestKbd2")));
    }

    @Test
    public void testKbd_toString() {
        Language.assertThat((Object)((Kbd)ComponentFactory.component(Kbd.class, (By)By.$((String)"#kbd_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Kbd with state : enabled:true, visible:true, text:TextTestKbd2"));
    }

    @Test
    public void can_find_var_by_id() {
        ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess3"));
        try {
            ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#var_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_var() {
        try {
            ComponentFactory.component(Var.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Var but a Abbr"));
        }
    }

    @Test
    public void test_var_coreAttributes() {
        Var var_ess1 = (Var)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess1"));
        Var var_ess2 = (Var)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess2"));
        Var var_ess3 = (Var)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess3"));
        Language.assertThat((Object)var_ess1.title(), (Matcher)Matchers.is((Object)"var1_Title"));
        Language.assertThat((Object)var_ess1.id(), (Matcher)Matchers.is((Object)"var_ess1"));
        Language.assertThat((Object)var_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)var_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)var_ess2.classname(), (Matcher)Matchers.is((Object)"MyVARClass"));
    }

    @Test
    public void test_var_i18nAttributes() {
        Var var_ess2 = (Var)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess2"));
        Var var_ess3 = (Var)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess3"));
        Language.assertThat((Object)var_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)var_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)var_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)var_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_var_text() {
        Language.assertThat((Object)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestVar2")));
    }

    @Test
    public void testVar_toString() {
        Language.assertThat((Object)((Var)ComponentFactory.component(Var.class, (By)By.$((String)"#var_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Var with state : enabled:true, visible:true, text:TextTestVar2"));
    }

    @Test
    public void can_find_abbr_by_id() {
        ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess3"));
        try {
            ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#abbr_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_abbr() {
        try {
            ComponentFactory.component(Abbr.class, (By)By.$((String)"#var_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=var_ess2 is not a Abbr but a Var"));
        }
    }

    @Test
    public void test_abbr_coreAttributes() {
        Abbr abbr_ess1 = (Abbr)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess1"));
        Abbr abbr_ess2 = (Abbr)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess2"));
        Abbr abbr_ess3 = (Abbr)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess3"));
        Language.assertThat((Object)abbr_ess1.title(), (Matcher)Matchers.is((Object)"abbr1_Title"));
        Language.assertThat((Object)abbr_ess1.id(), (Matcher)Matchers.is((Object)"abbr_ess1"));
        Language.assertThat((Object)abbr_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)abbr_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)abbr_ess2.classname(), (Matcher)Matchers.is((Object)"MyABBRClass"));
    }

    @Test
    public void test_abbr_i18nAttributes() {
        Abbr abbr_ess2 = (Abbr)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess2"));
        Abbr abbr_ess3 = (Abbr)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess3"));
        Language.assertThat((Object)abbr_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)abbr_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)abbr_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)abbr_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_abbr_text() {
        Language.assertThat((Object)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestAbbr2")));
    }

    @Test
    public void testAbbr_toString() {
        Language.assertThat((Object)((Abbr)ComponentFactory.component(Abbr.class, (By)By.$((String)"#abbr_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Abbr with state : enabled:true, visible:true, text:TextTestAbbr2"));
    }

    @Test
    public void can_find_acronym_by_id() {
        ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess3"));
        try {
            ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess4"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#acronym_ess4')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_acronym() {
        try {
            ComponentFactory.component(Acronym.class, (By)By.$((String)"#abbr_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess1 is not a Acronym but a Abbr"));
        }
    }

    @Test
    public void test_acronym_coreAttributes() {
        Acronym acronym_ess1 = (Acronym)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess1"));
        Acronym acronym_ess2 = (Acronym)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess2"));
        Acronym acronym_ess3 = (Acronym)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess3"));
        Language.assertThat((Object)acronym_ess1.title(), (Matcher)Matchers.is((Object)"acronym1_Title"));
        Language.assertThat((Object)acronym_ess1.id(), (Matcher)Matchers.is((Object)"acronym_ess1"));
        Language.assertThat((Object)acronym_ess1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)acronym_ess3.style(), (Matcher)Matchers.containsString((String)"font-size:10pt"));
        Language.assertThat((Object)acronym_ess2.classname(), (Matcher)Matchers.is((Object)"MyACRONYMClass"));
    }

    @Test
    public void test_acronym_i18nAttributes() {
        Acronym acronym_ess2 = (Acronym)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess2"));
        Acronym acronym_ess3 = (Acronym)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess3"));
        Language.assertThat((Object)acronym_ess2.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)acronym_ess2.language(), (Matcher)Matchers.is((Object)"fr"));
        Language.assertThat((Object)acronym_ess3.language(), (Matcher)Matchers.is((Object)"es"));
        Language.assertThat((Object)acronym_ess3.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
    }

    @Test
    public void can_obtain_acronym_text() {
        Language.assertThat((Object)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess2")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"TextTestAcronym2")));
    }

    @Test
    public void testAcronym_toString() {
        Language.assertThat((Object)((Acronym)ComponentFactory.component(Acronym.class, (By)By.$((String)"#acronym_ess2"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Acronym with state : enabled:true, visible:true, text:TextTestAcronym2"));
    }

    @Test
    public void can_find_p_by_id() {
        ComponentFactory.component(P.class, (By)By.$((String)"#p_1"));
        try {
            ComponentFactory.component(P.class, (By)By.$((String)"#a_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#a_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_p() {
        try {
            ComponentFactory.component(P.class, (By)By.$((String)"#acronym_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=acronym_ess1 is not a P but a Acronym"));
        }
    }

    @Test
    public void test_p_i18nAttributes() {
        P p = (P)ComponentFactory.component(P.class, (By)By.$((String)"#p_1"));
        Language.assertThat((Object)p.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)p.language(), (Matcher)Matchers.is((Object)"en"));
    }

    @Test
    public void test_p_coreAttributes() {
        P p = (P)ComponentFactory.component(P.class, (By)By.$((String)"#p_1"));
        Language.assertThat((Object)p.id(), (Matcher)Matchers.is((Object)"p_1"));
        Language.assertThat((Object)p.classname(), (Matcher)Matchers.is((Object)"myPClass"));
        Language.assertThat((Object)p.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)p.title(), (Matcher)Matchers.is((Object)"pTitle"));
    }

    @Test
    public void can_obtain_p_text() {
        Language.assertThat((Object)ComponentFactory.component(P.class, (By)By.$((String)"#p_1")), (Matcher)org.testatoo.core.matcher.Matchers.has((Matcher)org.testatoo.core.matcher.Matchers.text((String)"My Paragraph text")));
    }

    @Test
    public void testP_toString() {
        Language.assertThat((Object)((P)ComponentFactory.component(P.class, (By)By.$((String)"#p_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.P with state : enabled:true, visible:true, text:My Paragraph text"));
    }
}

