/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Script;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class ScriptTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Script.html");
    }

    @Test
    public void can_find_script_by_id() {
        ComponentFactory.component(Script.class, (By)By.$((String)"#script_1"));
        try {
            ComponentFactory.component(Script.class, (By)By.$((String)"#script_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#script_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_script() {
        try {
            ComponentFactory.component(Script.class, (By)By.$((String)"#var_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=var_ess1 is not a Script but a Var"));
        }
    }

    @Test
    public void test_script_specifics_attributes() {
        Script script = (Script)ComponentFactory.component(Script.class, (By)By.$((String)"#script_1"));
        Language.assertThat((Object)script.charset(), (Matcher)Matchers.is((Object)"utf-8"));
        Language.assertThat((Object)script.src(), (Matcher)Matchers.is((Object)"addtext.js"));
        Language.assertThat((Object)script.type(), (Matcher)Matchers.is((Object)"text/javascript"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Script)ComponentFactory.component(Script.class, (By)By.$((String)"#script_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Script with state : enabled:true, visible:false, source:addtext.js"));
    }
}

