/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.FileDialog;

@Ignore
public class FileDialogTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("File.html");
    }

    @Test
    public void can_find_fileDialog_by_id() {
        ComponentFactory.component(FileDialog.class, (String)"file");
        try {
            ComponentFactory.component(FileDialog.class, (String)"other");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by id=other"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_fileDialog() {
        try {
            ComponentFactory.component(FileDialog.class, (String)"radio");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a FileDialog but a Radio"));
        }
    }

    @Test
    public void can_select_file_path() {
        FileDialog fileDialog = (FileDialog)ComponentFactory.component(FileDialog.class, (String)"file");
        Language.assertThat((Object)fileDialog.selectedFilePath(), (Matcher)Matchers.is((Object)""));
        fileDialog.selectFilePath("/home/testatoo/file.txt");
        Language.assertThat((Object)fileDialog.selectedFilePath(), (Matcher)Matchers.is((Object)"/home/testatoo/file.txt"));
    }

    @Test
    public void test_toString() {
        FileDialog fileDialog = (FileDialog)ComponentFactory.component(FileDialog.class, (String)"file");
        fileDialog.selectFilePath("/home/testatoo/file.txt");
        Language.assertThat((Object)fileDialog.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.File with state : enabled:true, visible:true, title:fileTitle, selectedFilePath:/home/testatoo/file.txt"));
    }
}

