/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.TextField;
import org.testatoo.core.matcher.Matchers;

public class TextFieldTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("InputText.html");
    }

    @Test
    public void can_find_textField_by_id() {
        ComponentFactory.component(TextField.class, (String)"input_1");
        try {
            ComponentFactory.component(TextField.class, (String)"input_2");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by id=input_2"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_textField() {
        try {
            ComponentFactory.component(TextField.class, (String)"inputTextError");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=inputTextError is not a TextField but a CheckBox"));
        }
    }

    @Test
    public void can_test_max_length() {
        Language.assertThat((Object)((TextField)ComponentFactory.component(TextField.class, (String)"input_1")).maxLength(), (Matcher)org.hamcrest.Matchers.is((Object)10));
        Language.assertThat((Object)((TextField)ComponentFactory.component(TextField.class, (String)"input_language")).maxLength(), (Matcher)org.hamcrest.Matchers.is((Object)20));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(TextField.class, (String)"text"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Text label")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((TextField)ComponentFactory.component(TextField.class, (String)"text")).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.core.component.TextField with state : enabled:false, visible:true, value:textValue, label:Text label, maxLength:20"));
    }
}

