/**
 * Copyright (C) 2008 Ovea <dev@testatoo.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.testatoo.core;

import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.component.Image;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.fail;
import static org.testatoo.core.ComponentFactory.component;
import static org.testatoo.core.ComponentFactory.page;
import static org.testatoo.core.Language.assertThat;

public class ImageTest extends WebTest {

    @BeforeClass
    public static void setUp() {
        page().open("Img.html");
    }

    @Test
    public void can_find_image_by_id() {
        component(Image.class, "image_1");

        try {
            component(Image.class, "image_0");
            fail();
        } catch (ComponentException e) {
            assertThat(e.getMessage(), is("Cannot find component defined by id=image_0"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_image() {
        try {
            component(Image.class, "div_1");
            fail();
        } catch (ComponentException e) {
            assertThat(e.getMessage(), is("The component with id=div_1 is not a Image but a Panel"));
        }
    }

    @Test
    public void can_find_image_source() {
        assertThat(component(Image.class, "image_1").source(), containsString("images/Montpellier.jpg"));
    }

    @Test
    public void test_image_toString() {
        assertThat(component(Image.class, "image_1").toString(), is("class org.testatoo.core.component.Image with state : enabled:true, visible:true, source:images/Montpellier.jpg"));
    }

}

