/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Div;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class DivTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Panel.html");
    }

    @Test
    public void can_find_div_by_id() {
        ComponentFactory.component(Div.class, (By)By.$((String)"#panelId"));
        try {
            ComponentFactory.component(Div.class, (By)By.$((String)"#otherPanel"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#otherPanel')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_div() {
        try {
            ComponentFactory.component(Div.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a Panel but a Radio"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        Div div = (Div)ComponentFactory.component(Div.class, (By)By.$((String)"#panelId"));
        Language.assertThat((Object)div.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)div.language(), (Matcher)Matchers.is((Object)"en"));
    }

    @Test
    public void test_coreAttributes() {
        Div div = (Div)ComponentFactory.component(Div.class, (By)By.$((String)"#panelId"));
        Language.assertThat((Object)div.id(), (Matcher)Matchers.is((Object)"panelId"));
        Language.assertThat((Object)div.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)div.style(), (Matcher)Matchers.containsString((String)"background-color:red"));
        Language.assertThat((Object)div.title(), (Matcher)Matchers.is((Object)"panelTitle"));
    }

    @Test
    public void test_toString() {
        Div div = (Div)ComponentFactory.component(Div.class, (By)By.$((String)"#panelId"));
        Language.assertThat((Object)div.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Div with state : enabled:true, visible:true, title:panelTitle"));
    }
}

