/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Hidden;
import org.testatoo.cartridge.html4.element.InputType;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class HiddenTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Hidden.html");
    }

    @Test
    public void can_find_hidden_field_by_id() {
        ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden_1"));
        try {
            ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#hidden_2')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_hidden() {
        try {
            ComponentFactory.component(Hidden.class, (By)By.$((String)"#hiddenError"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=hiddenError is not a Hidden but a InputText"));
        }
    }

    @Test
    public void test_can_obtain_value() {
        Language.assertThat((Object)ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden")), (Matcher)Matchers.has((Matcher)Matchers.value((String)"hiddenValue")));
    }

    @Test
    public void test_i18nAttributes() {
        Hidden hidden = (Hidden)ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden"));
        Language.assertThat((Object)hidden.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)hidden.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Hidden hidden = (Hidden)ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden"));
        Language.assertThat((Object)hidden.id(), (Matcher)org.hamcrest.Matchers.is((Object)"hidden"));
        Language.assertThat((Object)hidden.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)hidden.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)hidden.title(), (Matcher)org.hamcrest.Matchers.is((Object)"hiddenTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        Hidden hidden = (Hidden)ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden"));
        Language.assertThat((Object)hidden.name(), (Matcher)org.hamcrest.Matchers.is((Object)"hiddenName"));
        Language.assertThat((Object)hidden.type(), (Matcher)org.hamcrest.Matchers.is((Object)InputType.hidden));
        Language.assertThat((Object)hidden.value(), (Matcher)org.hamcrest.Matchers.is((Object)"hiddenValue"));
        Language.assertThat((Object)hidden.alt(), (Matcher)org.hamcrest.Matchers.is((Object)"short description"));
        Language.assertThat((Object)hidden.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)4));
        Language.assertThat((Object)hidden.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)"C"));
        Hidden hidden2 = (Hidden)ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden2"));
        Language.assertThat((Object)hidden2.name(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)hidden2.type(), (Matcher)org.hamcrest.Matchers.is((Object)InputType.hidden));
        Language.assertThat((Object)hidden2.value(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)hidden2.alt(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)hidden2.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)0));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Hidden)ComponentFactory.component(Hidden.class, (By)By.$((String)"#hidden"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Hidden with state : enabled:true, visible:false, value:hiddenValue, label:"));
    }
}

