/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.InputText;
import org.testatoo.cartridge.html4.element.InputType;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class InputTextTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("InputText.html");
    }

    @Test
    public void can_find_inputText_by_id() {
        ComponentFactory.component(InputText.class, (By)By.$((String)"#input_1"));
        try {
            ComponentFactory.component(InputText.class, (By)By.$((String)"#input_2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#input_2')"));
        }
        try {
            ComponentFactory.component(InputText.class, (By)By.$((String)"#inputTextError"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=inputTextError is not a TextField but a CheckBox"));
        }
    }

    @Test
    public void test_i18nAttributes() {
        InputText myText = (InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#text"));
        Language.assertThat((Object)myText.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)myText.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        InputText myText = (InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#text"));
        Language.assertThat((Object)myText.id(), (Matcher)org.hamcrest.Matchers.is((Object)"text"));
        Language.assertThat((Object)myText.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)myText.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)myText.title(), (Matcher)org.hamcrest.Matchers.is((Object)"textTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        InputText myText = (InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#text"));
        Language.assertThat((Object)myText.name(), (Matcher)org.hamcrest.Matchers.is((Object)"myText"));
        Language.assertThat((Object)myText.value(), (Matcher)org.hamcrest.Matchers.is((Object)"textValue"));
        Language.assertThat((Object)myText.alt(), (Matcher)org.hamcrest.Matchers.is((Object)"short description"));
        Language.assertThat((Object)myText.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)5));
        Language.assertThat((Object)myText.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)"C"));
        Language.assertThat((Object)myText.type(), (Matcher)org.hamcrest.Matchers.is((Object)InputType.text));
        Language.assertThat((Object)myText.toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.InputText with state : enabled:false, visible:true, value:textValue, label:Text label, maxLength:20"));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#input_1")), (Matcher)Matchers.has((Matcher)Matchers.size((int)20)));
        InputText myTextDef = (InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#text_def"));
        Language.assertThat((Object)myTextDef.name(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myTextDef.value(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myTextDef.alt(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myTextDef.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)0));
        Language.assertThat((Object)myTextDef.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        Language.assertThat((Object)myTextDef.type(), (Matcher)org.hamcrest.Matchers.is((Object)InputType.text));
        Language.assertThat((Object)myTextDef.size(), (Matcher)org.hamcrest.Matchers.is((Object)10));
    }

    @Test
    public void test_enability() {
        Assert.assertTrue((boolean)((InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#text"))).isReadOnly());
        Assert.assertTrue((boolean)((InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#readonlytext"))).isReadOnly());
        Language.assertThat((Object)((InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#input_language"))).isReadOnly(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#disabledtext")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.enabled())));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#input_language")), (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.enabled()));
    }

    @Test
    public void can_test_max_length() {
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#input_1")), (Matcher)Matchers.has((Matcher)Matchers.maxLength((int)10)));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#input_language")), (Matcher)Matchers.has((Matcher)Matchers.maxLength((int)20)));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"#text")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Text label")));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"[name=cellnumber]")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Cell phone number")));
        Language.assertThat((Object)ComponentFactory.component(InputText.class, (By)By.$((String)"[name=homenumber]")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Home phone number")));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((InputText)ComponentFactory.component(InputText.class, (By)By.$((String)"#text"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.InputText with state : enabled:false, visible:true, value:textValue, label:Text label, maxLength:20"));
    }
}

