/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.element.AlertBox;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Button;
import org.testatoo.core.component.Component;
import org.testatoo.core.input.Mouse;

public class AlertBoxTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("AlertBox.html");
    }

    @Test
    public void can_find_alertbox() {
        try {
            ComponentFactory.alertBox();
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot find component defined by id="));
        }
        Mouse.clickOn((Component)ComponentFactory.component(Button.class, (String)"alertButton"));
        AlertBox alertbox = ComponentFactory.alertBox();
        alertbox.close();
    }

    @Test
    public void can_test_title() {
        Mouse.clickOn((Component)ComponentFactory.component(Button.class, (String)"alertButton"));
        AlertBox alertbox = ComponentFactory.alertBox();
        Language.assertThat((Object)alertbox.title(), (Matcher)Matchers.is((Object)""));
        alertbox.close();
    }

    @Test
    public void can_test_message() {
        Mouse.clickOn((Component)ComponentFactory.component(Button.class, (String)"alertButton"));
        AlertBox alertbox = ComponentFactory.alertBox();
        Language.assertThat((Object)alertbox.message(), (Matcher)Matchers.is((Object)"Changes saved successfully."));
        alertbox.close();
    }

    @Test
    public void can_close_alertbox() {
        Mouse.clickOn((Component)ComponentFactory.component(Button.class, (String)"alertButton"));
        AlertBox alertbox = ComponentFactory.alertBox();
        alertbox.close();
        try {
            ComponentFactory.alertBox();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot find component defined by id="));
        }
    }

    @Test
    public void test_toString() {
        Mouse.clickOn((Component)ComponentFactory.component(Button.class, (String)"alertButton"));
        AlertBox alertbox = ComponentFactory.alertBox();
        Language.assertThat((Object)alertbox.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.AlertBox with state : enabled:true, visible:true, title:, message:Changes saved successfully."));
        alertbox.close();
    }
}

