/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.Selection;
import org.testatoo.core.component.DropDown;
import org.testatoo.core.matcher.Matchers;

public class DropDownTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Select.html");
    }

    @Test
    public void can_find_dropdown_by_id() {
        ComponentFactory.component(DropDown.class, (String)"elements");
        try {
            ComponentFactory.component(DropDown.class, (String)"otherDropdown");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by id=otherDropdown"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_dropdown() {
        try {
            ComponentFactory.component(DropDown.class, (String)"cities");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=cities is not a DropDown but a ListBox"));
        }
    }

    @Test
    public void test_list_values() {
        DropDown countriesList = (DropDown)ComponentFactory.component(DropDown.class, (String)"countries");
        Language.assertThat((Object)countriesList.values(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"Canada", "France", "Spain"}));
        DropDown elementsList = (DropDown)ComponentFactory.component(DropDown.class, (String)"elements");
        Language.assertThat((Object)elementsList.values(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"1", "5", "84", "20", "88"}));
        Language.assertThat((Object)elementsList.values(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"20", "5", "84", "1", "88"}));
        Selection values = ((DropDown)ComponentFactory.component(DropDown.class, (String)"elements")).values();
        Language.assertThat((Object)values.containsAll(Arrays.asList("1", "5", "84", "20", "88")), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void test_can_select_value() {
        DropDown dropdown = (DropDown)ComponentFactory.component(DropDown.class, (String)"elements");
        Language.assertThat((Object)dropdown.selectedValue(), (Matcher)org.hamcrest.Matchers.is((Object)""));
        dropdown.select("84");
        Language.assertThat((Object)dropdown.selectedValue(), (Matcher)org.hamcrest.Matchers.is((Object)"84"));
    }

    @Test
    public void can_select_item() {
        DropDown countriesList = (DropDown)ComponentFactory.component(DropDown.class, (String)"countries");
        countriesList.select("France");
        Language.assertThat((Object)countriesList.selectedValue(), (Matcher)org.hamcrest.Matchers.is((Object)"France"));
        countriesList.select("Spain");
        Language.assertThat((Object)countriesList.selectedValue(), (Matcher)org.hamcrest.Matchers.is((Object)"Spain"));
        DropDown elementsList = (DropDown)ComponentFactory.component(DropDown.class, (String)"elements");
        elementsList.select("84");
        Language.assertThat((Object)elementsList.selectedValue(), (Matcher)org.hamcrest.Matchers.is((Object)"84"));
        elementsList.select("20");
        Language.assertThat((Object)elementsList.selectedValue(), (Matcher)org.hamcrest.Matchers.is((Object)"20"));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(DropDown.class, (String)"elements"), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Elements list")));
    }

    @Test
    public void test_toString() {
        ComponentFactory.page().open("Select.html");
        Language.assertThat((Object)((DropDown)ComponentFactory.component(DropDown.class, (String)"elements")).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.DropDown with state : enabled:true, visible:true, values:[1, 5, 84, 20, 88], selectedValues:[], label:Elements list"));
    }
}

