/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.core;

import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.HtmlEvaluator;
import org.testatoo.cartridge.html4.element.AlertBox;
import org.testatoo.core.ComponentException;
import org.testatoo.core.Evaluator;
import org.testatoo.core.EvaluatorHolder;
import org.testatoo.core.ListSelection;
import org.testatoo.core.Selection;
import org.testatoo.core.component.Component;
import org.testatoo.core.component.DropDown;
import org.testatoo.core.component.ListBox;
import org.testatoo.core.component.Page;

public final class ComponentFactory {
    public static Page page() {
        return new Page((Evaluator)ComponentFactory.evaluator(), ComponentFactory.evaluator().pageId());
    }

    public static <T extends Component> T component(Class<T> componentType, String id) {
        if (id.startsWith("$")) {
            return ComponentFactory.component(componentType, By.$(id));
        }
        return ComponentFactory.component(componentType, By.id(id));
    }

    public static <T extends Component> T component(Class<T> componentType, By by) {
        return ComponentFactory.loadComponent(componentType, by.id(ComponentFactory.evaluator()));
    }

    public static Selection<? extends Component> components(By by) {
        return ComponentFactory.components(Component.class, by);
    }

    public static <T extends Component> Selection<T> components(final Class<T> componentType, By by) {
        return ListSelection.from(by.ids(ComponentFactory.evaluator())).transform(new Function<String, T>(){

            public T apply(String id) {
                return ComponentFactory.loadComponent(componentType, id);
            }
        });
    }

    public static AlertBox alertBox() {
        return new AlertBox(ComponentFactory.evaluator());
    }

    private static HtmlEvaluator evaluator() {
        return (HtmlEvaluator)EvaluatorHolder.get();
    }

    private static <T extends Component> T loadComponent(Class<T> componentType, String id) {
        Class<Object> cmpType = componentType;
        if (componentType.equals(DropDown.class)) {
            cmpType = org.testatoo.cartridge.html4.element.DropDown.class;
        }
        if (componentType.equals(ListBox.class)) {
            cmpType = org.testatoo.cartridge.html4.component.ListBox.class;
        }
        try {
            return (T)((Component)cmpType.getConstructor(HtmlEvaluator.class, String.class).newInstance(ComponentFactory.evaluator(), id));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ComponentException) {
                throw (ComponentException)e.getCause();
            }
            try {
                return (T)((Component)componentType.getConstructor(Evaluator.class, String.class).newInstance(ComponentFactory.evaluator(), id));
            }
            catch (InvocationTargetException ite) {
                throw new ComponentException(ite.getTargetException().getMessage(), ite.getTargetException());
            }
            catch (Exception e1) {
                throw new ComponentException(e1.getMessage(), (Throwable)e1);
            }
        }
    }
}

