/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Dd;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Dl;
import org.testatoo.cartridge.html4.element.Dt;
import org.testatoo.cartridge.html4.element.Li;
import org.testatoo.cartridge.html4.element.Ol;
import org.testatoo.cartridge.html4.element.Ul;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class ListTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("List.html");
    }

    @Test
    public void can_find_ul_by_id() {
        ComponentFactory.component(Ul.class, (By)By.$((String)"#ul_1"));
        try {
            ComponentFactory.component(Ul.class, (By)By.$((String)"#ul_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#ul_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_ul() {
        try {
            ComponentFactory.component(Ul.class, (By)By.$((String)"#abbr_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess2 is not a Ul but a Abbr"));
        }
    }

    @Test
    public void test_ul_coreAttributes() {
        Ul ul_1 = (Ul)ComponentFactory.component(Ul.class, (By)By.$((String)"#ul_1"));
        Language.assertThat((Object)ul_1.id(), (Matcher)Matchers.is((Object)"ul_1"));
        Language.assertThat((Object)ul_1.classname(), (Matcher)Matchers.is((Object)"MyULClass"));
        Language.assertThat((Object)ul_1.style(), (Matcher)Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)ul_1.title(), (Matcher)Matchers.is((Object)"ul_title1"));
    }

    @Test
    public void test_ul_i18nAttributes() {
        Ul ul_1 = (Ul)ComponentFactory.component(Ul.class, (By)By.$((String)"#ul_1"));
        Language.assertThat((Object)ul_1.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)ul_1.language(), (Matcher)Matchers.is((Object)"en"));
    }

    @Test
    public void testUl_toString() {
        Language.assertThat((Object)((Ul)ComponentFactory.component(Ul.class, (By)By.$((String)"#ul_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Ul with state : enabled:true, visible:true, title:ul_title1"));
    }

    @Test
    public void can_find_li_by_id() {
        ComponentFactory.component(Li.class, (By)By.$((String)"#li_1"));
        try {
            ComponentFactory.component(Li.class, (By)By.$((String)"#li_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#li_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_li() {
        try {
            ComponentFactory.component(Li.class, (By)By.$((String)"#abbr_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess2 is not a Li but a Abbr"));
        }
    }

    @Test
    public void test_li_coreAttributes() {
        Li li_1 = (Li)ComponentFactory.component(Li.class, (By)By.$((String)"#li_1"));
        Li li_2 = (Li)ComponentFactory.component(Li.class, (By)By.$((String)"#li_2"));
        Language.assertThat((Object)li_1.id(), (Matcher)Matchers.is((Object)"li_1"));
        Language.assertThat((Object)li_1.classname(), (Matcher)Matchers.is((Object)"MyLIClass"));
        Language.assertThat((Object)li_1.style(), (Matcher)Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)li_1.title(), (Matcher)Matchers.is((Object)"li_title1"));
        Language.assertThat((Object)li_2.title(), (Matcher)Matchers.is((Object)"li_title2"));
    }

    @Test
    public void test_li_i18nAttributes() {
        Li li_1 = (Li)ComponentFactory.component(Li.class, (By)By.$((String)"#li_1"));
        Language.assertThat((Object)li_1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)li_1.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void testLi_toString() {
        Language.assertThat((Object)((Li)ComponentFactory.component(Li.class, (By)By.$((String)"#li_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Li with state : enabled:true, visible:true, title:li_title1, content:Item 1"));
    }

    @Test
    public void can_find_ol_by_id() {
        ComponentFactory.component(Ol.class, (By)By.$((String)"#ol_1"));
        try {
            ComponentFactory.component(Ol.class, (By)By.$((String)"#ol_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#ol_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_ol() {
        try {
            ComponentFactory.component(Ol.class, (By)By.$((String)"#abbr_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess2 is not a Ol but a Abbr"));
        }
    }

    @Test
    public void test_ol_coreAttributes() {
        Ol ol_1 = (Ol)ComponentFactory.component(Ol.class, (By)By.$((String)"#ol_1"));
        Language.assertThat((Object)ol_1.id(), (Matcher)Matchers.is((Object)"ol_1"));
        Language.assertThat((Object)ol_1.classname(), (Matcher)Matchers.is((Object)"MyOLClass"));
        Language.assertThat((Object)ol_1.style(), (Matcher)Matchers.containsString((String)"color:brown"));
        Language.assertThat((Object)ol_1.title(), (Matcher)Matchers.is((Object)"ol_title1"));
    }

    @Test
    public void test_ol_i18nAttributes() {
        Ol ol_1 = (Ol)ComponentFactory.component(Ol.class, (By)By.$((String)"#ol_1"));
        Language.assertThat((Object)ol_1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)ol_1.language(), (Matcher)Matchers.is((Object)"es"));
    }

    @Test
    public void testOl_toString() {
        Language.assertThat((Object)((Ol)ComponentFactory.component(Ol.class, (By)By.$((String)"#ol_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Ol with state : enabled:true, visible:true, title:ol_title1"));
    }

    @Test
    public void can_find_dl_by_id() {
        ComponentFactory.component(Dl.class, (By)By.$((String)"#dl_1"));
        try {
            ComponentFactory.component(Dl.class, (By)By.$((String)"#dl_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#dl_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_dl() {
        try {
            ComponentFactory.component(Dl.class, (By)By.$((String)"#abbr_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess2 is not a Dl but a Abbr"));
        }
    }

    @Test
    public void test_dl_coreAttributes() {
        Dl dl_1 = (Dl)ComponentFactory.component(Dl.class, (By)By.$((String)"#dl_1"));
        Language.assertThat((Object)dl_1.id(), (Matcher)Matchers.is((Object)"dl_1"));
        Language.assertThat((Object)dl_1.classname(), (Matcher)Matchers.is((Object)"MyDLClass"));
        Language.assertThat((Object)dl_1.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)dl_1.title(), (Matcher)Matchers.is((Object)"dl_title1"));
    }

    @Test
    public void test_dl_i18nAttributes() {
        Dl dl_1 = (Dl)ComponentFactory.component(Dl.class, (By)By.$((String)"#dl_1"));
        Language.assertThat((Object)dl_1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)dl_1.language(), (Matcher)Matchers.is((Object)"en"));
    }

    @Test
    public void testDl_toString() {
        Language.assertThat((Object)((Dl)ComponentFactory.component(Dl.class, (By)By.$((String)"#dl_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Dl with state : enabled:true, visible:true, title:dl_title1"));
    }

    @Test
    public void can_find_dt_by_id() {
        ComponentFactory.component(Dt.class, (By)By.$((String)"#dt_1"));
        try {
            ComponentFactory.component(Dt.class, (By)By.$((String)"#dt_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#dt_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_dt() {
        try {
            ComponentFactory.component(Dt.class, (By)By.$((String)"#abbr_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess2 is not a Dt but a Abbr"));
        }
    }

    @Test
    public void test_dt_coreAttributes() {
        Dt dt_1 = (Dt)ComponentFactory.component(Dt.class, (By)By.$((String)"#dt_1"));
        Language.assertThat((Object)dt_1.id(), (Matcher)Matchers.is((Object)"dt_1"));
        Language.assertThat((Object)dt_1.classname(), (Matcher)Matchers.is((Object)"MyDTClass"));
        Language.assertThat((Object)dt_1.style(), (Matcher)Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)dt_1.title(), (Matcher)Matchers.is((Object)"dt_title1"));
    }

    @Test
    public void test_dt_i18nAttributes() {
        Dt dt_1 = (Dt)ComponentFactory.component(Dt.class, (By)By.$((String)"#dt_1"));
        Language.assertThat((Object)dt_1.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)dt_1.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void testDt_toString() {
        Language.assertThat((Object)((Dt)ComponentFactory.component(Dt.class, (By)By.$((String)"#dt_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Dt with state : enabled:true, visible:true, title:dt_title1, content:Red"));
    }

    @Test
    public void can_find_dd_by_id() {
        ComponentFactory.component(Dd.class, (By)By.$((String)"#dd_1"));
        try {
            ComponentFactory.component(Dd.class, (By)By.$((String)"#dd_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#dd_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_dd() {
        try {
            ComponentFactory.component(Dd.class, (By)By.$((String)"#abbr_ess2"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=abbr_ess2 is not a Dd but a Abbr"));
        }
    }

    @Test
    public void test_dd_coreAttributes() {
        Dd dd_1 = (Dd)ComponentFactory.component(Dd.class, (By)By.$((String)"#dd_1"));
        Language.assertThat((Object)dd_1.id(), (Matcher)Matchers.is((Object)"dd_1"));
        Language.assertThat((Object)dd_1.classname(), (Matcher)Matchers.is((Object)"MyDDClass"));
        Language.assertThat((Object)dd_1.style(), (Matcher)Matchers.containsString((String)"color:pink"));
        Language.assertThat((Object)dd_1.title(), (Matcher)Matchers.is((Object)"dd_title1"));
    }

    @Test
    public void test_dd_i18nAttributes() {
        Dd dd_1 = (Dd)ComponentFactory.component(Dd.class, (By)By.$((String)"#dd_1"));
        Language.assertThat((Object)dd_1.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)dd_1.language(), (Matcher)Matchers.is((Object)"en"));
    }

    @Test
    public void testDd_toString() {
        Language.assertThat((Object)((Dd)ComponentFactory.component(Dd.class, (By)By.$((String)"#dd_1"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Dd with state : enabled:true, visible:true, title:dd_title1, content:Constructed by R:255 ; G:0 ; B:0"));
    }
}

