/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Option;
import org.testatoo.cartridge.html4.element.OptionGroup;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.component.Component;
import org.testatoo.core.matcher.Matchers;

public class OptionGroupTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Select.html");
    }

    @Test
    public void can_find_optionGroup_by_id() {
        ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"));
        try {
            ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#someOptionGroup"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#someOptionGroup')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_optionGroup() {
        try {
            ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#var_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=var_ess1 is not a OptionGroup but a Var"));
        }
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"linux")));
    }

    @Test
    public void can_get_options_of_optionGroup() {
        OptionGroup myLinux = (OptionGroup)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"));
        Language.assertThat((Object)myLinux.options(), (Matcher)Matchers.has((Matcher)Matchers.size((int)3)));
        Option optionLinux = (Option)ComponentFactory.component(Option.class, (By)By.$((String)"#kubuntuOption"));
        Language.assertThat((Object)myLinux, (Matcher)Matchers.contains((Component[])new Component[]{optionLinux}));
        Language.assertThat((Object)((Option)myLinux.options().get(0)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Kubuntu"));
        Language.assertThat((Object)((Option)myLinux.options().get(1)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Fedora"));
        Language.assertThat((Object)((Option)myLinux.options().get(2)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Gentoo"));
    }

    @Test
    public void test_i18nAttributes() {
        OptionGroup myLinux = (OptionGroup)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"));
        Language.assertThat((Object)myLinux.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)myLinux.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        OptionGroup myLinux = (OptionGroup)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"));
        Language.assertThat((Object)myLinux.id(), (Matcher)org.hamcrest.Matchers.is((Object)"linux"));
        Language.assertThat((Object)myLinux.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)myLinux.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)myLinux.title(), (Matcher)org.hamcrest.Matchers.is((Object)"linuxGrpTitle"));
    }

    @Test
    public void test_enability() {
        OptionGroup myLinux = (OptionGroup)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"));
        Language.assertThat((Object)myLinux, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.enabled()));
        Language.assertThat((Object)myLinux, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.disabled())));
    }

    @Test
    public void test_contains() {
        OptionGroup myLinux = (OptionGroup)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"));
        Option optionLinux = (Option)ComponentFactory.component(Option.class, (By)By.$((String)"#kubuntuOption"));
        Language.assertThat((Object)myLinux, (Matcher)Matchers.contains((Component[])new Component[]{optionLinux}));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((OptionGroup)ComponentFactory.component(OptionGroup.class, (By)By.$((String)"#linux"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.OptionGroup with state : enabled:true, visible:false, label:linux, optionsValue:[KubuntuValue, RedHatValue, GentooValue]"));
    }
}

