/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Option;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class OptionTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Option.html");
    }

    @Test
    public void can_find_option_by_id() {
        ComponentFactory.component(Option.class, (By)By.$((String)"#1"));
        try {
            ComponentFactory.component(Option.class, (By)By.$((String)"#someOption"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#someOption')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_option() {
        try {
            ComponentFactory.component(Option.class, (By)By.$((String)"#country"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=country is not a Option but a DropDown"));
        }
    }

    @Test
    public void can_test_value() {
        Language.assertThat((Object)ComponentFactory.component(Option.class, (By)By.$((String)"#1")), (Matcher)Matchers.has((Matcher)Matchers.value((String)"Canada_country")));
    }

    @Test
    public void can_retrieve_the_content() {
        Language.assertThat((Object)((Option)ComponentFactory.component(Option.class, (By)By.$((String)"#1"))).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Canada (CA)"));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(Option.class, (By)By.$((String)"#1")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Canada")));
    }

    @Test
    public void can_test_is_selected() {
        Language.assertThat((Object)((Option)ComponentFactory.component(Option.class, (By)By.$((String)"#1"))).selected(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Language.assertThat((Object)((Option)ComponentFactory.component(Option.class, (By)By.$((String)"#2"))).selected(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void test_enability() {
        Language.assertThat((Object)ComponentFactory.component(Option.class, (By)By.$((String)"#1")), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.disabled())));
        Language.assertThat((Object)ComponentFactory.component(Option.class, (By)By.$((String)"#2")), (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.disabled()));
    }

    @Test
    public void test_i18nAttributes() {
        Language.assertThat((Object)((Option)ComponentFactory.component(Option.class, (By)By.$((String)"#2"))).direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)((Option)ComponentFactory.component(Option.class, (By)By.$((String)"#2"))).language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Option my2 = (Option)ComponentFactory.component(Option.class, (By)By.$((String)"#2"));
        Language.assertThat((Object)my2.id(), (Matcher)org.hamcrest.Matchers.is((Object)"2"));
        Language.assertThat((Object)my2.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)my2.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)my2.title(), (Matcher)org.hamcrest.Matchers.is((Object)"optionTitle"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Option)ComponentFactory.component(Option.class, (By)By.$((String)"#2"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Option with state : enabled:false, visible:true, value:France_country, label:France, text:France (FR), selected:false"));
    }
}

