/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Radio;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class RadioTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Radio.html");
    }

    @Test
    public void test_i18nAttributes() {
        Radio radio = (Radio)ComponentFactory.component(Radio.class, (By)By.$((String)"#radio"));
        Language.assertThat((Object)radio.direction(), (Matcher)Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)radio.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Radio radio = (Radio)ComponentFactory.component(Radio.class, (By)By.$((String)"#radio"));
        Language.assertThat((Object)radio.id(), (Matcher)Matchers.is((Object)"radio"));
        Language.assertThat((Object)radio.classname(), (Matcher)Matchers.is((Object)"myClass"));
        Language.assertThat((Object)radio.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)radio.title(), (Matcher)Matchers.is((Object)"radioTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        Radio radio = (Radio)ComponentFactory.component(Radio.class, (By)By.$((String)"#radio"));
        Language.assertThat((Object)radio.name(), (Matcher)Matchers.is((Object)"myRadio"));
        Language.assertThat((Object)radio.value(), (Matcher)Matchers.is((Object)"radioValue"));
        Language.assertThat((Object)radio.alt(), (Matcher)Matchers.is((Object)"short description"));
        Language.assertThat((Object)radio.tabindex(), (Matcher)Matchers.is((Object)5));
        Language.assertThat((Object)radio.accesskey(), (Matcher)Matchers.is((Object)"C"));
    }

    @Test
    public void exception_thrown_if_component_not_a_html_radio() {
        try {
            ComponentFactory.component(Radio.class, (By)By.$((String)"#var_ess1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=var_ess1 is not a Radio but a Var"));
        }
    }

    @Test
    public void exception_thrown_if_component_is_a_html_checkbox() {
        try {
            ComponentFactory.component(Radio.class, (By)By.$((String)"#firstChoice"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=firstChoice is not a Radio but a CheckBox"));
        }
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Radio)ComponentFactory.component(Radio.class, (By)By.$((String)"#radio"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Radio with state : enabled:true, visible:true, label:Radio label, checked:false"));
    }
}

