/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Option;
import org.testatoo.cartridge.html4.element.OptionGroup;
import org.testatoo.cartridge.html4.element.Select;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.Selection;
import org.testatoo.core.matcher.Matchers;

public class SelectTest
extends WebTest {
    @Before
    public void setUp() {
        ComponentFactory.page().open("Select.html");
    }

    @Test
    public void can_find_select_by_id() {
        ComponentFactory.component(Select.class, (By)By.$((String)"#cities"));
        try {
            ComponentFactory.component(Select.class, (By)By.$((String)"#otherSelect"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#otherSelect')"));
        }
    }

    @Test
    public void test_if_multiple_select() {
        Language.assertThat((Object)((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#cities"))).isMultiple(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void test_number_of_visible_rows() {
        Language.assertThat((Object)((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#elements"))).visibleRows(), (Matcher)org.hamcrest.Matchers.is((Object)2));
    }

    @Test
    public void test_i18nAttributes() {
        Select select = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#elements"));
        Language.assertThat((Object)select.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)select.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_coreAttributes() {
        Select select = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#elements"));
        Language.assertThat((Object)select.id(), (Matcher)org.hamcrest.Matchers.is((Object)"elements"));
        Language.assertThat((Object)select.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"myClass"));
        Language.assertThat((Object)select.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)select.title(), (Matcher)org.hamcrest.Matchers.is((Object)"elementTitle"));
    }

    @Test
    public void test_specifics_attributes() {
        Select select = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#elements"));
        Language.assertThat((Object)select.name(), (Matcher)org.hamcrest.Matchers.is((Object)"elementName"));
        Language.assertThat((Object)select.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)2));
        Language.assertThat((Object)select.size(), (Matcher)org.hamcrest.Matchers.is((Object)2));
        Language.assertThat((Object)select.visibleRows(), (Matcher)org.hamcrest.Matchers.is((Object)2));
        Select emptySelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#emptyList"));
        Language.assertThat((Object)emptySelect.size(), (Matcher)org.hamcrest.Matchers.is((Object)0));
        Language.assertThat((Object)emptySelect.visibleRows(), (Matcher)org.hamcrest.Matchers.is((Object)0));
    }

    @Test
    public void test_enability() {
        Select select = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#elements"));
        Language.assertThat((Object)select, (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.enabled()));
        Language.assertThat((Object)select, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.not((Matcher)Matchers.disabled())));
        Language.assertThat((Object)ComponentFactory.component(Select.class, (By)By.$((String)"#name")), (Matcher)org.hamcrest.Matchers.is((Matcher)Matchers.disabled()));
    }

    @Test
    public void can_retrieve_all_options() {
        Selection options = ((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#cities"))).options();
        Language.assertThat((Object)((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#cities"))).optionGroups(), (Matcher)Matchers.has((Matcher)Matchers.size((int)0)));
        Language.assertThat((Object)options, (Matcher)Matchers.has((Matcher)Matchers.size((int)6)));
        Language.assertThat((Object)((Option)options.get(0)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Montreal"));
        Language.assertThat((Object)((Option)options.get(1)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Quebec"));
        Language.assertThat((Object)((Option)options.get(2)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Montpellier"));
        Language.assertThat((Object)((Option)options.get(3)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"New York"));
        Language.assertThat((Object)((Option)options.get(4)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Casablanca"));
        Language.assertThat((Object)((Option)options.get(5)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Munich"));
    }

    @Test
    public void can_retrieve_optionGroups() {
        Selection optionGroups = ((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#os"))).optionGroups();
        Language.assertThat((Object)optionGroups, (Matcher)Matchers.has((Matcher)Matchers.size((int)3)));
        Language.assertThat((Object)optionGroups.get(0), (Matcher)Matchers.has((Matcher)Matchers.label((String)"linux")));
        Language.assertThat((Object)optionGroups.get(1), (Matcher)Matchers.has((Matcher)Matchers.label((String)"win32")));
        Language.assertThat((Object)optionGroups.get(2), (Matcher)Matchers.has((Matcher)Matchers.label((String)"BSD")));
    }

    @Test
    public void can_retrieve_options_from_a_optionGroup() {
        Selection optionGroups = ((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#os"))).optionGroups();
        Selection options = ((OptionGroup)optionGroups.get(1)).options();
        Language.assertThat((Object)options, (Matcher)Matchers.has((Matcher)Matchers.size((int)2)));
        Language.assertThat((Object)((Option)options.get(0)).label(), (Matcher)org.hamcrest.Matchers.is((Object)"XPLabel"));
        Language.assertThat((Object)((Option)options.get(0)).value(), (Matcher)org.hamcrest.Matchers.is((Object)"XPValue"));
        Language.assertThat((Object)((Option)options.get(0)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"XP"));
        Language.assertThat((Object)((Option)options.get(1)).label(), (Matcher)org.hamcrest.Matchers.is((Object)"VistaLabel"));
        Language.assertThat((Object)((Option)options.get(1)).value(), (Matcher)org.hamcrest.Matchers.is((Object)"VistaValue"));
        Language.assertThat((Object)((Option)options.get(1)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Vista"));
    }

    @Test
    public void can_select_options() {
        Select osSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#os"));
        Language.assertThat((Object)osSelect.optionGroups().get(0), (Matcher)Matchers.has((Matcher)Matchers.label((String)"linux")));
        Language.assertThat((Object)osSelect.options(), (Matcher)Matchers.has((Matcher)Matchers.size((int)8)));
        osSelect.select("KubuntuValue");
        Language.assertThat((Object)osSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)1)));
        Option osSelectedOption = (Option)osSelect.selectedOptions().get(0);
        Language.assertThat((Object)osSelectedOption.label(), (Matcher)org.hamcrest.Matchers.is((Object)"KubuntuLabel"));
        Language.assertThat((Object)osSelectedOption.value(), (Matcher)org.hamcrest.Matchers.is((Object)"KubuntuValue"));
        Language.assertThat((Object)osSelectedOption.content(), (Matcher)org.hamcrest.Matchers.is((Object)"Kubuntu"));
        osSelect.select("FreeBSDValue");
        Language.assertThat((Object)osSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)1)));
        osSelectedOption = (Option)osSelect.selectedOptions().get(0);
        Language.assertThat((Object)osSelectedOption.label(), (Matcher)org.hamcrest.Matchers.is((Object)"FreeBSDLabel"));
        Language.assertThat((Object)osSelectedOption.value(), (Matcher)org.hamcrest.Matchers.is((Object)"FreeBSDValue"));
        Language.assertThat((Object)osSelectedOption.content(), (Matcher)org.hamcrest.Matchers.is((Object)"FreeBSD"));
        Select planetsSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#planets"));
        planetsSelect.select("3");
        planetsSelect.select("5");
        Language.assertThat((Object)planetsSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)2)));
        Selection planetsSelectedOptions = planetsSelect.selectedOptions();
        Language.assertThat((Object)((Option)planetsSelectedOptions.get(0)).label(), (Matcher)org.hamcrest.Matchers.is((Object)"Earth"));
        Language.assertThat((Object)((Option)planetsSelectedOptions.get(0)).value(), (Matcher)org.hamcrest.Matchers.is((Object)"3"));
        Language.assertThat((Object)((Option)planetsSelectedOptions.get(0)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Earth"));
        Language.assertThat((Object)((Option)planetsSelectedOptions.get(1)).label(), (Matcher)org.hamcrest.Matchers.is((Object)"Jupiter"));
        Language.assertThat((Object)((Option)planetsSelectedOptions.get(1)).value(), (Matcher)org.hamcrest.Matchers.is((Object)"5"));
        Language.assertThat((Object)((Option)planetsSelectedOptions.get(1)).content(), (Matcher)org.hamcrest.Matchers.is((Object)"Jupiter"));
    }

    @Test
    public void can_retrieve_values() {
        Select countriesList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#countries"));
        Language.assertThat((Object)countriesList.values(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"Canada", "France", "Spain"}));
        Select oceansList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#oceans"));
        Language.assertThat((Object)oceansList.values(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"304", "208", "378", "153", "357"}));
        Language.assertThat((Object)oceansList.values(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"357", "208", "378", "153", "304"}));
        Language.assertThat((Object)oceansList.values(), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"305", "209", "378", "153", "357"})));
    }

    @Test
    public void can_retrieve_selected_values() {
        Select countriesList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#countries"));
        countriesList.select("France");
        Language.assertThat((Object)countriesList.selectedValues(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"France"}));
        Select componentsList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#elements"));
        componentsList.select("1");
        Language.assertThat((Object)componentsList.selectedValues().get(0), (Matcher)org.hamcrest.Matchers.is((Object)"1"));
        componentsList.select("20");
        Language.assertThat((Object)componentsList.lstSelectedValues().get(0), (Matcher)org.hamcrest.Matchers.is((Object)"20"));
        Language.assertThat((Object)componentsList.lstSelectedValues(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"20"}));
        try {
            componentsList.select("2");
        }
        catch (Exception e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"ERROR: Option with value '2' not found"));
        }
        Select planetsSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#planets"));
        planetsSelect.select("2");
        planetsSelect.select("4");
        planetsSelect.select("6");
        Language.assertThat((Object)planetsSelect.selectedValues().get(0), (Matcher)org.hamcrest.Matchers.is((Object)"2"));
        Language.assertThat((Object)planetsSelect.selectedValues().get(1), (Matcher)org.hamcrest.Matchers.is((Object)"4"));
        Language.assertThat((Object)planetsSelect.selectedValues().get(2), (Matcher)org.hamcrest.Matchers.is((Object)"6"));
        Language.assertThat((Object)planetsSelect.lstSelectedValues().get(0), (Matcher)org.hamcrest.Matchers.is((Object)"2"));
        Language.assertThat((Object)planetsSelect.lstSelectedValues().get(1), (Matcher)org.hamcrest.Matchers.is((Object)"4"));
        Language.assertThat((Object)planetsSelect.lstSelectedValues().get(2), (Matcher)org.hamcrest.Matchers.is((Object)"6"));
        Language.assertThat((Object)planetsSelect.lstSelectedValues(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"2", "4", "6"}));
        Select oceansList = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#oceans"));
        oceansList.select("378");
        oceansList.select("153");
        Language.assertThat((Object)oceansList.selectedValues().get(0), (Matcher)org.hamcrest.Matchers.is((Object)"378"));
        Language.assertThat((Object)oceansList.selectedValues().get(1), (Matcher)org.hamcrest.Matchers.is((Object)"153"));
        Language.assertThat((Object)oceansList.selectedValues(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"378", "153"}));
    }

    @Test
    public void can_unselect_options() {
        Select osSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#os"));
        Language.assertThat((Object)osSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)1)));
        Language.assertThat((Object)osSelect.selectedOptions().get(0), (Matcher)Matchers.has((Matcher)Matchers.value((String)"none")));
        osSelect.select("KubuntuValue");
        Language.assertThat((Object)osSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)1)));
        Language.assertThat((Object)osSelect.selectedOptions().get(0), (Matcher)Matchers.has((Matcher)Matchers.value((String)"KubuntuValue")));
        try {
            osSelect.unselect("KubuntuValue");
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)true, (Matcher)org.hamcrest.Matchers.is((Object)true));
        }
        Select planetsSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#planets"));
        planetsSelect.select("3");
        planetsSelect.select("5");
        Language.assertThat((Object)planetsSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)2)));
        planetsSelect.unselect("5");
        Language.assertThat((Object)planetsSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)1)));
        planetsSelect.unselect("3");
        Language.assertThat((Object)planetsSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)0)));
        osSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#os"));
        Language.assertThat((Object)osSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)1)));
        try {
            osSelect.unselectAll();
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)true, (Matcher)org.hamcrest.Matchers.is((Object)true));
        }
        planetsSelect = (Select)ComponentFactory.component(Select.class, (By)By.$((String)"#planets"));
        planetsSelect.select("1");
        planetsSelect.select("2");
        Language.assertThat((Object)planetsSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)2)));
        planetsSelect.unselectAll();
        Language.assertThat((Object)planetsSelect.selectedOptions(), (Matcher)Matchers.has((Matcher)Matchers.size((int)0)));
    }

    @Test
    public void test_label() {
        Language.assertThat((Object)ComponentFactory.component(Select.class, (By)By.$((String)"#cities")), (Matcher)Matchers.has((Matcher)Matchers.label((String)"Cities list")));
        Language.assertThat((Object)((Select)ComponentFactory.component(Select.class, (By)By.$((String)"[name=girlsList]"))).label(), (Matcher)org.hamcrest.Matchers.containsString((String)"girls list"));
    }

    @Test
    public void test_toString() {
        Language.assertThat((Object)((Select)ComponentFactory.component(Select.class, (By)By.$((String)"#cities"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Select with state : enabled:true, visible:true, values:[Montreal, Quebec, Montpellier, New York, Casablanca, Munich], selectedValues:[New York, Munich], optionGroup:[], visibleRows:3"));
    }
}

